/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.swingsupport;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleSubAttribute;
import com.elluminate.groupware.whiteboard.interfaces.ToolActivationListener;
import com.elluminate.groupware.whiteboard.interfaces.ToolSelectionListener;
import com.elluminate.groupware.whiteboard.listeners.ScreenChangeListener;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.ComponentMouseAdapter;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.TextEditorToolModel;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class WBUIComponent
implements ToolSelectionListener,
ToolActivationListener,
ScreenChangeListener {
    private JComponent ui;
    private AbstractToolModel tool;
    private ComponentMouseAdapter wbMouseAdapter;

    protected WBUIComponent() {
    }

    public WBUIComponent(AbstractToolModel tool) {
        this();
        this.tool = tool;
        ControllerPane controller = (ControllerPane)tool.getContext().getController();
        this.wbMouseAdapter = new ComponentMouseAdapter(controller.getCanvas());
        this.wbMouseAdapter.addMouseListener(controller.getMouseListener());
        this.wbMouseAdapter.addMouseMotionListener(controller.getMouseListener());
    }

    public void render(Graphics g) {
        if (this.tool == null) {
            this.ui.setVisible(false);
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle rect = this.tool.getVBounds();
        WhiteboardContext context = this.tool.getContext();
        double zoomX = context.getScaleX();
        double zoomY = context.getScaleY();
        g2.translate((double)rect.x * zoomX, (double)rect.y * zoomY);
        ((WBPanel)this.ui).paintMe(g2);
    }

    public void setToolModel(AbstractToolModel tool) {
        this.tool = tool;
    }

    public void dispose() {
        this.ui.removeAll();
    }

    public JComponent getUI() {
        if (this.ui == null) {
            this.createUI();
        }
        return this.ui;
    }

    public String toString() {
        if (this.ui != null) {
            return this.ui.getName() + " Location: (" + this.ui.getX() + ", " + this.ui.getY() + "),  " + "Size: (" + this.ui.getWidth() + ", " + this.ui.getHeight() + ")";
        }
        return "UI Component has not been initialized yet!!!";
    }

    public void setPosition(Rectangle rec) {
        int x = Math.min(rec.x, rec.x + rec.width);
        int y = Math.min(rec.y, rec.y + rec.height);
        int width = rec.width;
        int height = rec.height;
        width = width >= 0 ? width : -width;
        height = height >= 0 ? height : -height;
        WhiteboardContext context = this.tool.getContext();
        if (context.isScaled()) {
            x = (int)((double)x * context.getScaleX());
            width = (int)((double)width * context.getScaleX());
            y = (int)((double)y * context.getScaleY());
            height = (int)((double)height * context.getScaleY());
        }
        if (x != this.ui.getX() || y != this.ui.getY()) {
            this.ui.setLocation(x, y);
        }
        if (width != this.ui.getWidth() || height != this.ui.getHeight()) {
            this.ui.setSize(new Dimension(width, height));
        }
    }

    public void setUI(JComponent ui) {
        this.ui = ui;
    }

    public void setWbMouseAdapter(ComponentMouseAdapter wbMouseAdapter) {
        if (this.wbMouseAdapter == null || this.wbMouseAdapter != wbMouseAdapter) {
            this.wbMouseAdapter = wbMouseAdapter;
        }
    }

    public abstract void endComposition();

    public void setTool(AbstractToolModel tool) {
        this.tool = tool;
    }

    public ComponentMouseAdapter getWbMouseAdapter() {
        return this.wbMouseAdapter;
    }

    public AbstractToolModel getTool() {
        return this.tool;
    }

    public void createUI() {
        try {
            this.ui = new WBPanel();
            this.ui.setBackground((Color)((TextEditorToolModel)this.tool).getFillColor().getColor());
            this.ui.setLayout(new GridBagLayout());
            this.ui.setVisible(true);
            this.ui.setOpaque(false);
            this.ui.setName("WBPanel");
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"WhiteboardUIComponent", (Throwable)ex, (boolean)true);
            this.ui = new JPanel();
        }
    }

    public boolean isVisible() {
        if (this.ui != null) {
            return this.ui.isVisible();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (this.ui != null) {
            this.ui.setVisible(visible);
        }
    }

    public void onSelectTool(AbstractToolModel tool) {
    }

    public void onDeSelectTool(AbstractToolModel tool) {
    }

    public void onActivateTool(AbstractToolModel tool) {
    }

    public void onDeActivateTool(AbstractToolModel tool) {
    }

    public Dimension getRealSize() {
        return this.ui.getSize();
    }

    public void grabFocus() {
        this.ui.grabFocus();
    }

    public boolean hasFocus() {
        return this.ui.hasFocus();
    }

    public boolean isLink(MouseEvent e) {
        return false;
    }

    public void handleMouseRelease(MouseEvent e, int scaleX, int scaleY) {
    }

    public abstract void updateUIFromConference(AbstractAttribute var1);

    public abstract boolean applyAttributeChange(StyleSubAttribute var1, int var2, int var3);

    public abstract Image getImage();

    public abstract void setBorder(Color var1, int var2);

    private class WBPanel
    extends JPanel {
        private WBPanel() {
        }

        public void paintMe(Graphics g) {
            this.paintComponent(g);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2D = (Graphics2D)g.create();
            g2D.setColor((Color)((TextEditorToolModel)WBUIComponent.this.tool).getFillColor().getColor());
            g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g2D);
            g2D.dispose();
        }
    }
}

