/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.swingsupport;

import com.elluminate.groupware.whiteboard.module.ui.swingsupport.StringsProperties;
import com.elluminate.gui.FontUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.textparser.TextParserStyledDocument;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class TextEditorStyledDocument
extends TextParserStyledDocument {
    protected static final I18n I18N = I18n.create(TextEditorStyledDocument.class);
    int ignored = 0;
    boolean warningOverlimit = false;
    int commulativeIgnored = 0;
    public static final int PAUSE_FOR_MULTIPLE_PASTES_MILLISECONDS = 20;

    public TextEditorStyledDocument(boolean parseSmileys) {
        super(parseSmileys);
    }

    public void insertString(int offset, String text, AttributeSet attr) throws BadLocationException {
        int rawTextLength = this.getRawText().length();
        if (rawTextLength + text.length() > 10000) {
            int availableSpace = 10000 - rawTextLength;
            if (availableSpace < 0) {
                availableSpace = 0;
            }
            this.ignored = text.length() - availableSpace;
            this.commulativeIgnored += this.ignored;
            text = text.substring(0, availableSpace);
            if (!this.warningOverlimit) {
                this.warningOverlimit = true;
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ModalDialog.showMessageDialog(null, (Object)I18N.getString((PropertiesEnum)StringsProperties.DOC_CHARSOVERLIMIT, new Object[]{new Long(10000L), new Integer(TextEditorStyledDocument.this.commulativeIgnored)}), (String)I18N.getString((PropertiesEnum)StringsProperties.DOC_CHARSOVERLIMITTITLE), (int)2);
                        TextEditorStyledDocument.this.warningOverlimit = false;
                        TextEditorStyledDocument.this.commulativeIgnored = 0;
                    }
                });
            }
        }
        super.insertString(offset, text, this.validateFont(attr));
    }

    public void superInsertString(int offset, String text, AttributeSet attr) throws BadLocationException {
        super.superInsertString(offset, text, this.validateFont(attr));
    }

    private AttributeSet validateFont(AttributeSet attr) {
        String fontName = StyleConstants.getFontFamily(attr);
        List<String> availableFonts = Arrays.asList(FontUtils.getFontNames());
        SimpleAttributeSet mAttr = new SimpleAttributeSet();
        mAttr.addAttributes(attr);
        if (!availableFonts.contains(fontName)) {
            StyleConstants.setFontFamily(mAttr, "Serif");
        }
        return mAttr;
    }

    protected int getSmileySpacePadding(String smileyPattern) {
        return smileyPattern.length() - 1;
    }
}

