/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.gui.Mnemonic;
import com.elluminate.util.I18n;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public abstract class WBAbstractAction
extends AbstractAction
implements ActionFeatureListener {
    protected static I18n i18n = I18n.create((Object)new Object(){});
    String propertiesName = null;
    Image iconImage = null;
    Icon actionIcon = null;
    WhiteboardContext context = null;
    protected ActionFeature feature = null;

    public WBAbstractAction(WhiteboardContext context, Object housing, String propertiesName) {
        super(Mnemonic.getText((String)WBAbstractAction.getActionName(propertiesName)));
        try {
            this.actionIcon = i18n.getIcon(propertiesName + ".icon");
            this.iconImage = i18n.getImage(propertiesName + ".icon");
            this.putValue("SmallIcon", this.actionIcon);
        }
        catch (Exception ex) {
            this.actionIcon = null;
        }
        this.context = context;
        this.propertiesName = propertiesName;
        Object obj = null;
        if (housing instanceof JMenu) {
            JMenu menu = (JMenu)housing;
            menu.add(WBAbstractAction.menuItemFactory(this));
            obj = menu.getMenuComponent(menu.getMenuComponentCount() - 1);
        } else if (housing instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)housing;
            popup.add(WBAbstractAction.menuItemFactory(this));
            obj = popup.getComponent(popup.getComponentCount() - 1);
        } else {
            obj = housing;
        }
        if (obj instanceof AbstractButton) {
            if (obj instanceof JMenuItem) {
                KeyStroke keyStroke = this.getAccelerator();
                if (keyStroke != null) {
                    ((JMenuItem)obj).setAccelerator(keyStroke);
                }
            } else {
                Mnemonic.setMnemonic((AbstractButton)((AbstractButton)obj), (String)WBAbstractAction.getActionName(propertiesName));
            }
        }
    }

    public static JMenuItem menuItemFactory(WBAbstractAction action) {
        JMenuItem item = new JMenuItem(action);
        String text = WBAbstractAction.getActionName(action.getPropertiesName());
        if (action.isInteractive()) {
            text = text + "...";
        }
        Mnemonic.setTextAndMnemonic((AbstractButton)item, (String)text);
        item.setIcon(null);
        return item;
    }

    public JMenuItem menuItemFactory() {
        return WBAbstractAction.menuItemFactory(this);
    }

    public ActionFeature actionFeatureFactory(FeatureBroker broker, Object owner, String path) {
        if (this.feature != null) {
            throw new IllegalStateException("ActionFeature already bound: " + this.feature);
        }
        this.feature = broker.createActionFeature(owner, path, WBAbstractAction.getActionName(this.propertiesName), this.getToolTipText());
        this.feature.setDefaultIcon(this.iconImage);
        this.feature.setEnabled(this.isEnabled());
        this.feature.setInteractive(this.isInteractive());
        this.feature.addActionFeatureListener((ActionFeatureListener)this);
        return this.feature;
    }

    public void actionPerformed(ActionFeatureEvent e) {
        throw new UnsupportedOperationException("ActionFeatureListener not implemented: " + this);
    }

    public boolean isInteractive() {
        return false;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this.feature != null) {
            this.feature.setEnabled(enable);
        }
    }

    public Icon getActionIcon() {
        return this.actionIcon;
    }

    public String getToolTipText() {
        try {
            return i18n.getStringLegacy(this.propertiesName + ".toolTip");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getActionName(String propertiesName) {
        String actionName = propertiesName + ".item";
        try {
            actionName = i18n.getStringLegacy(actionName);
        }
        catch (Exception ex) {
            return null;
        }
        return actionName;
    }

    public String getPropertiesName() {
        return this.propertiesName;
    }

    public KeyStroke getMnemonic() {
        try {
            String property = i18n.getStringLegacy(this.propertiesName + ".mnemonic");
            KeyStroke keyStroke = KeyStroke.getKeyStroke(property);
            return keyStroke;
        }
        catch (Exception e) {
            return null;
        }
    }

    public KeyStroke getAccelerator() {
        try {
            String property = i18n.getStringLegacy(this.propertiesName + ".accelerator");
            if (property.length() == 1) {
                return KeyStroke.getKeyStroke((int)property.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            }
            return KeyStroke.getKeyStroke(property);
        }
        catch (Exception e) {}
        finally {
            return null;
        }
    }

    public int screenCount(TreePath[] paths) {
        DisplayNode peer = null;
        int screenCount = 0;
        for (int i = 0; i < paths.length; ++i) {
            peer = (DisplayNode)paths[i].getLastPathComponent();
            if (peer.whiteboardPeer() instanceof ScreenRoot) continue;
            ++screenCount;
        }
        return screenCount;
    }

    public static JButton jButtonFactory(WBAbstractAction action) {
        String text = Mnemonic.getText((String)WBAbstractAction.getActionName(action.getPropertiesName()));
        Icon icon = action.getActionIcon();
        JButton result = new JButton(text, icon);
        result.addActionListener(action);
        result.setToolTipText(action.getToolTipText());
        return result;
    }

    public JButton jButtonFactory() {
        return WBAbstractAction.jButtonFactory(this);
    }
}

