/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.AbstractWBFileFilter;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.WBDSaveProcessor;
import com.elluminate.groupware.whiteboard.module.WhiteboardWBDFileFilter;
import com.elluminate.groupware.whiteboard.module.ui.FileChoice;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.groupware.whiteboard.xml.WhiteboardDataFile;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;

public class ToolExportWBDAction
extends WBAbstractAction {
    ScreenModel screen;
    File fileToSave;
    boolean fileSaveError;
    WhiteboardDataFile jdom = null;

    public ToolExportWBDAction(WhiteboardContext context, Object housing, ScreenModel screen) {
        super(context, housing, "ToolExportWBDAction");
        this.screen = screen;
        this.setEnabled(!screen.getSelectedToolList().isEmpty() && screen.canSave());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChoice choice = FileUtils.getSaveFile(this.context, this.context.fileToSave, new AbstractWBFileFilter[]{new WhiteboardWBDFileFilter()});
        this.fileToSave = choice.getFile();
        if (this.fileToSave != null) {
            WBDSaveProcessor saveProcessor = new WBDSaveProcessor(this.context);
            saveProcessor.setPathsToProcess(null);
            saveProcessor.setDepth(1);
            FileUtils.saveThisFile(this.context, this.fileToSave.getPath(), saveProcessor);
            if (!this.fileSaveError) {
                this.context.fileToSave = this.fileToSave;
            }
        }
    }

    public void saveProcessor(ProgressUpdate progress) {
        ScreenModel[] proxyScreens = new ScreenModel[]{this.screen.proxySelectedTools()};
        try {
            this.jdom = new WhiteboardDataFile(this.context);
            this.jdom.writeData(this.fileToSave, proxyScreens, progress);
        }
        catch (Exception e) {
            Component comp = progress instanceof Component ? (Component)progress : this.context.getDialogParentFrame();
            ModalDialog.showMessageDialog((Component)comp, (Object)i18n.getString((PropertiesEnum)StringsProperties.TOOLEXPORTWBDACTION_ERROR), (String)i18n.getString((PropertiesEnum)StringsProperties.TOOLEXPORTWBDACTION_ERRORTITLE), (int)0);
            this.fileSaveError = true;
        }
        this.jdom = null;
    }

    public void endOperation() {
        if (this.jdom != null) {
            this.jdom.endOperation();
        }
    }
}

