/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

public class NewScreenAction
extends WBAbstractAction {
    TreePath[] paths;
    Component housing;

    public NewScreenAction(WhiteboardContext context, Object housing, TreePath[] paths) {
        super(context, housing, "NewScreenAction");
        this.housing = (Component)housing;
        this.setPaths(paths);
    }

    public void setPaths(TreePath[] paths) {
        this.paths = paths;
    }

    public void evaluateEnable(JMenuItem item) {
        boolean enable = ActionUtilities.canCreateTree((WhiteboardContext)this.context, (TreePath[])this.paths);
        this.setEnabled(enable);
        if (item != null) {
            item.setEnabled(enable);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAction();
    }

    @Override
    public void actionPerformed(ActionFeatureEvent e) {
        this.performAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAction() {
        Long gotoUID = null;
        ScreenModel[] parents = new ScreenModel[this.paths.length];
        this.context.getDataExporter().blockCodecs();
        try {
            for (int i = 0; i < this.paths.length; ++i) {
                Object obj = this.paths[i].getLastPathComponent();
                if (!(obj instanceof DisplayNode)) continue;
                DisplayNode peer = (DisplayNode)obj;
                ScreenModel screenParent = (ScreenModel)peer.whiteboardPeer();
                if (this.context.getController().getScreen() == screenParent) {
                    gotoUID = screenParent.getObjectID();
                }
                parents[i] = screenParent;
            }
            this.context.getController().postNewScreenDialog((Component)this.context.getDialogParentFrame(), parents);
            if (gotoUID != null) {
                this.context.getController().gotoUIScreen(gotoUID, false);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)ex, (boolean)true);
        }
        finally {
            this.context.getDataExporter().unblockCodecs();
        }
    }
}

