/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.AbstractWBFileFilter;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.WBDSaveProcessor;
import com.elluminate.groupware.whiteboard.module.WhiteboardWBDFileFilter;
import com.elluminate.groupware.whiteboard.module.WhiteboardWBPFileFilter;
import com.elluminate.groupware.whiteboard.module.ui.FileChoice;
import com.elluminate.groupware.whiteboard.module.ui.menu.PathSelectionDialog;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.tree.TreePath;

public class NavExportWBDAction
extends WBAbstractAction {
    TreePath[] paths;
    TreePath[] pathsToProcess;
    int depth;
    int selectedDepth;
    File fileToSave;
    PathSelectionDialog selectionDialog = null;

    public NavExportWBDAction(WhiteboardContext context, Object housing, TreePath[] paths, int depth) {
        super(context, housing, "NavExportWBDAction");
        this.depth = depth;
        this.setPaths(paths);
    }

    public void setPaths(TreePath[] paths) {
        this.paths = paths;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pathsToProcess = this.paths;
        this.selectedDepth = this.depth;
        if (this.selectionDialog == null) {
            this.selectionDialog = new PathSelectionDialog(this.context, 1, true, true, true);
        }
        if (this.pathsToProcess == null || this.pathsToProcess.length == 0) {
            this.selectionDialog.setDepthNeeded(false);
            this.selectionDialog.setVisible(this.pathsToProcess, this.depth);
            if (this.selectionDialog.isCancelled()) {
                return;
            }
            this.pathsToProcess = this.selectionDialog.getPaths();
            this.selectedDepth = this.selectionDialog.getDepth();
            if (this.selectedDepth < Integer.MAX_VALUE) {
                this.depth = this.selectedDepth;
            }
        }
        if (this.pathsToProcess == null || this.pathsToProcess.length == 0) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.EXPORTACTIONS_NOPATHS), (String)i18n.getString((PropertiesEnum)StringsProperties.EXPORTACTIONS_NOPATHSTITLE), (int)0);
            return;
        }
        WhiteboardWBPFileFilter pFilter = new WhiteboardWBPFileFilter();
        WhiteboardWBDFileFilter dFilter = new WhiteboardWBDFileFilter();
        FileChoice choice = FileUtils.getSaveFile(this.context, this.context.fileToSave, new AbstractWBFileFilter[]{dFilter, pFilter});
        this.fileToSave = choice.getFile();
        if (this.fileToSave != null) {
            this.pathsToProcess = ActionUtilities.orderPaths((TreePath[])this.pathsToProcess, (WhiteboardContext)this.context);
            WBDSaveProcessor saveProcessor = new WBDSaveProcessor(this.context);
            saveProcessor.setPathsToProcess(this.pathsToProcess);
            saveProcessor.setDepth(this.selectedDepth);
            saveProcessor.setFileToSave(this.fileToSave);
            FileUtils.saveThisFile(this.context, this.fileToSave.getPath(), saveProcessor);
            if (!saveProcessor.getFileSaveError()) {
                this.context.fileToSave = new File(this.fileToSave.getPath().substring(0, this.fileToSave.getPath().length() - choice.getFilter().getSuffix().length() - 1));
            }
        }
    }
}

