/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.util.log.LogSupport;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class ImportToScreenAction
extends WBAbstractAction {
    TreePath[] paths;

    public ImportToScreenAction(WhiteboardContext context, Object housing, TreePath[] paths) {
        super(context, housing, "ImportToScreenAction");
        this.setPaths(paths);
    }

    public void setPaths(TreePath[] paths) {
        this.paths = paths;
        this.setEnabled(paths != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScreenModel[] screens = new ScreenModel[this.paths.length];
        for (int i = 0; i < this.paths.length; ++i) {
            DisplayNode peer = (DisplayNode)this.paths[i].getLastPathComponent();
            screens[i] = (ScreenModel)peer.whiteboardPeer();
        }
        ImportToScreenAction.loadToScreen(screens, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadToScreen(ScreenModel[] screens, WhiteboardContext context) {
        WhiteboardModel model = FileUtils.getLoadModel(context, context.fileToLoad, true, screens[0].getScreenSize().width, screens[0].getScreenSize().height);
        if (model == null) {
            return;
        }
        context.getDataExporter().blockCodecs();
        try {
            for (int i = 0; i < screens.length; ++i) {
                for (int j = 0; j < model.getChildCount(); ++j) {
                    ScreenModel child = (ScreenModel)model.getChildAt(j);
                    ScreenModel clonedChild = (ScreenModel)child.clone();
                    screens[i].add((WBNode)clonedChild);
                }
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ImportToScreenAction.class, (String)"loadToScreen", (Throwable)ex, (boolean)true);
        }
        finally {
            model.delete();
            context.getDataExporter().unblockCodecs();
        }
    }
}

