/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class ImportReplaceScreenAction
extends WBAbstractAction {
    TreePath[] paths;

    public ImportReplaceScreenAction(WhiteboardContext context, Object housing, TreePath[] paths) {
        super(context, housing, "ImportReplaceScreenAction");
        this.setPaths(paths);
    }

    public void setPaths(TreePath[] paths) {
        this.paths = paths;
        this.setEnabled(paths != null && this.screenCount(paths) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        boolean watchingScreen = false;
        DisplayNode peer = (DisplayNode)this.paths[0].getLastPathComponent();
        ScreenModel screen = (ScreenModel)peer.whiteboardPeer();
        WhiteboardModel model = FileUtils.getLoadModel(this.context, this.context.fileToLoad, true, screen.getScreenSize().width, screen.getScreenSize().height);
        if (model == null) {
            return;
        }
        this.context.getDataExporter().blockCodecs();
        try {
            for (int i = 0; i < this.paths.length; ++i) {
                peer = (DisplayNode)this.paths[i].getLastPathComponent();
                screen = (ScreenModel)peer.whiteboardPeer();
                if (!(screen instanceof ScreenRoot)) {
                    int screenIndex;
                    ScreenModel parent = screen.getScreenParent();
                    int watchingIndex = screenIndex = parent.getIndex((WBNode)screen);
                    boolean bl = watchingScreen = this.context.getController().getScreen() == screen;
                    if (this.context.getDataModel() != null) {
                        screen.setOriginator();
                        parent.remove((WBNode)screen);
                    }
                    for (int j = 0; j < model.getChildCount(); ++j) {
                        ScreenModel child = (ScreenModel)model.getChildAt(j);
                        ScreenModel clonedChild = (ScreenModel)child.clone();
                        parent.insert((WBNode)clonedChild, screenIndex++);
                    }
                    if (!watchingScreen) continue;
                    this.context.getController().gotoUIScreen(((ScreenModel)parent.getChildAt(watchingIndex)).getObjectID(), false);
                    continue;
                }
                this.context.getDataExporter().unblockCodecs();
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.IMPORTREPLACESCREENACTION_CANTREPLACEMESSAGE, new Object[]{screen.getScreenName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.IMPORTREPLACESCREENACTION_CANTREPLACETITLE), (int)0);
                this.context.getDataExporter().blockCodecs();
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)ex, (boolean)true);
        }
        finally {
            model.delete();
            this.context.getDataExporter().unblockCodecs();
        }
    }
}

