/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.util.log.LogSupport;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class ImportBeforeScreenAction
extends WBAbstractAction {
    TreePath[] paths;

    public ImportBeforeScreenAction(WhiteboardContext context, Object housing, TreePath[] paths) {
        super(context, housing, "ImportBeforeScreenAction");
        this.setPaths(paths);
    }

    public void setPaths(TreePath[] paths) {
        this.paths = paths;
        this.setEnabled(paths != null && this.screenCount(paths) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        boolean watchingScreen = false;
        DisplayNode peer = (DisplayNode)this.paths[0].getLastPathComponent();
        ScreenModel screen = (ScreenModel)peer.whiteboardPeer();
        WhiteboardModel model = FileUtils.getLoadModel(this.context, this.context.fileToLoad, true, screen.getScreenSize().width, screen.getScreenSize().height);
        if (model == null) {
            return;
        }
        this.context.getDataExporter().blockCodecs();
        try {
            for (int i = 0; i < this.paths.length; ++i) {
                int screenIndex;
                peer = (DisplayNode)this.paths[i].getLastPathComponent();
                screen = (ScreenModel)peer.whiteboardPeer();
                if (screen instanceof ScreenRoot) continue;
                ScreenModel parent = screen.getScreenParent();
                int watchingIndex = screenIndex = parent.getIndex((WBNode)screen);
                watchingScreen = this.context.getController().getScreen() == screen;
                for (int j = 0; j < model.getChildCount(); ++j) {
                    ScreenModel child = (ScreenModel)model.getChildAt(j);
                    ScreenModel clonedChild = (ScreenModel)child.clone();
                    parent.insert((WBNode)clonedChild, screenIndex++);
                }
                if (!watchingScreen) continue;
                this.context.getController().gotoUIScreen(((ScreenModel)parent.getChildAt(watchingIndex)).getObjectID(), false);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)ex, (boolean)true);
        }
        finally {
            model.delete();
            this.context.getDataExporter().unblockCodecs();
        }
    }
}

