/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.event.ActionEvent;

public class DistributeVSpaceAction
extends WBAbstractAction {
    ScreenModel screen;

    public DistributeVSpaceAction(WhiteboardContext context, Object housing, ScreenModel screen) {
        super(context, housing, "DistributeVSpaceAction");
        this.setScreen(screen);
    }

    public void setScreen(ScreenModel screen) {
        this.screen = screen;
        this.setEnabled(screen != null && screen.getSelectedToolList().size() > 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        int toolCount = this.screen.getSelectedToolList().size();
        AbstractToolModel[] tools = new AbstractToolModel[toolCount];
        double heights = 0.0;
        for (i = 0; i < toolCount; ++i) {
            tools[i] = (AbstractToolModel)this.screen.getSelectedToolList().get(i);
            heights += tools[i].getNormalSize().getHeight();
        }
        double totalHeight = tools[tools.length - 1].getNormalLocation().getY() + tools[tools.length - 1].getNormalSize().getHeight() - tools[0].getNormalLocation().getY();
        double space = (totalHeight - heights) / (double)(toolCount - 1);
        double topEdge = tools[0].getNormalLocation().getY() + tools[0].getNormalSize().getHeight() + space;
        for (i = 1; i < toolCount - 1; ++i) {
            double topCorrection = tools[i].getNormalLocation().getY() - topEdge;
            tools[i].setLocation(tools[i].getLocation().getX(), tools[i].getLocation().getY() - topCorrection);
            topEdge += tools[i].getNormalSize().getHeight() + space;
        }
    }
}

