/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.event.ActionEvent;
import java.util.Iterator;

public class AlignCenterAction
extends WBAbstractAction {
    int toolcount;
    ScreenModel screen;

    public AlignCenterAction(WhiteboardContext context, Object housing, ScreenModel screen) {
        super(context, housing, "AlignCenterAction");
        this.setScreen(screen);
    }

    public void setScreen(ScreenModel screen) {
        this.screen = screen;
        this.setEnabled(screen != null && screen.getSelectedToolList().size() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double yVerticalCenter;
        Iterator iter = this.screen.getSelectedToolList().iterator();
        if (this.screen.getSelectedToolCount() == 1) {
            yVerticalCenter = (double)this.screen.getScreenSize().height / 2.0;
        } else {
            AbstractToolModel anchor = (AbstractToolModel)iter.next();
            yVerticalCenter = anchor.getLocation().getY() + anchor.getSize().getHeight() / 2.0;
        }
        while (iter.hasNext()) {
            AbstractToolModel tool = (AbstractToolModel)iter.next();
            if (yVerticalCenter - tool.getSize().getHeight() / 2.0 == tool.getLocation().getY()) continue;
            tool.setLocation(tool.getLocation().getX(), yVerticalCenter - tool.getSize().getHeight() / 2.0);
        }
    }
}

