/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.dnd;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.module.ui.dnd.WBNodeSelection;
import com.elluminate.groupware.whiteboard.tools.NoUIProgress;
import com.elluminate.groupware.whiteboard.xml.WhiteboardDataFile;
import com.elluminate.gui.dnd.DropHelperInterface;
import com.elluminate.util.log.LogSupport;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.io.BufferedInputStream;
import java.util.ArrayList;

public class WBToolPasteHelper
implements DropHelperInterface {
    WhiteboardContext context = null;

    public WBToolPasteHelper(WhiteboardContext context) {
        this.context = context;
    }

    public boolean isDataValid(Transferable transferable, DataFlavor chosen, int action, Point location) {
        if (transferable == null || chosen == null) {
            return false;
        }
        Object data = null;
        try {
            data = transferable.getTransferData(chosen);
        }
        catch (Exception ex) {
            return false;
        }
        return chosen.equals(WBNodeSelection.wbXMLFlavor) && data instanceof BufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean objectDropped(Transferable transferable, DataFlavor chosen, Point location, Object extra) {
        ScreenModel toScreen = (ScreenModel)extra;
        if (transferable == null || chosen == null) {
            return false;
        }
        Object data = null;
        WhiteboardModel whiteboardModel = null;
        try {
            data = transferable.getTransferData(chosen);
            if (WhiteboardDebug.DATAFLAVORS.show()) {
                LogSupport.message(WBToolPasteHelper.class, (String)"objectDropped()", (String)("Pasting, \nflavor: " + chosen + "\ndata: " + data));
            }
            NoUIProgress progress = new NoUIProgress();
            WhiteboardDataFile jdom = new WhiteboardDataFile(this.context);
            if (jdom.readDataStream((BufferedInputStream)data)) {
                whiteboardModel = jdom.processJDOM(jdom, this.context, (ProgressUpdate)progress);
                if (whiteboardModel == null) {
                    boolean bl = false;
                    return bl;
                }
                ArrayList allTools = new ArrayList();
                for (int i = 0; i < whiteboardModel.getChildCount(); ++i) {
                    ScreenModel screen = (ScreenModel)whiteboardModel.getChildAt(i);
                    allTools.addAll(screen.getTools());
                }
                if (!allTools.isEmpty()) {
                    WBNode[] nodes = new WBNode[allTools.size()];
                    DPoint dloc = null;
                    if (location != null) {
                        dloc = new DPoint(location);
                    }
                    allTools.toArray(nodes);
                    ActionUtilities.pasteTools((ScreenModel)toScreen, (WhiteboardContext)this.context, (DPoint)dloc, (WBNode[])nodes);
                }
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"Can't read data from the transferable", (Throwable)ex, (boolean)true);
            boolean bl = false;
            return bl;
        }
        finally {
            if (whiteboardModel != null) {
                whiteboardModel.delete();
            }
        }
        return false;
    }

    public void updateUI(int event, DropTargetContext context, DataFlavor flavor, int action, Point location) {
    }
}

