/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.attributes.ToolImageAlpha;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AbstractToolEditorUI;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AlphaPicker;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.ColorPicker;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ToolImageAlphaEditorUI
extends AbstractToolEditorUI {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static int COLOR_PICKER_WIDTH = 200;
    private static int COLOR_PICKER_HEIGHT = 20;
    private static int HIDE_FRAME_INDEX = 1;
    private static int FRAME_VISIBLE_INDEX = 2;
    private HashSet attributes = new HashSet();
    private JPanel framePanel = new JPanel(new GridBagLayout());
    private JLabel colorComboLabel = new JLabel();
    private ColorPicker colorCombo;
    private JLabel frameLabel = new JLabel();
    private JComboBox frameCombo = new JComboBox();
    private JPanel alphaPanel = new JPanel(new GridBagLayout());
    private JLabel alphaComboLabel = new JLabel();
    private AlphaPicker alphaCombo;
    private AbstractAttribute attribute = null;
    private WhiteboardContext context;
    private boolean evaluating = false;

    public ToolImageAlphaEditorUI() {
        try {
            this.initialize();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        TitledBorder panelBorder = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.TOOLCOLOREDITORUI_PANELBORDERTITLE));
        this.setBorder(panelBorder);
        this.colorCombo = new ColorPicker();
        this.frameCombo = new JComboBox<Object>(new Object[]{i18n.getString((PropertiesEnum)StringsProperties.EDITORS_NOCHANGE), i18n.getString((PropertiesEnum)StringsProperties.IMAGEALPHA_HIDEFRAME), i18n.getString((PropertiesEnum)StringsProperties.IMAGEALPHA_SHOWFRAME)});
        this.alphaCombo = new AlphaPicker();
        this.add((Component)this.alphaPanel, "North");
        this.add((Component)this.framePanel, "South");
        this.framePanel.add((Component)this.colorCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.framePanel.add((Component)this.frameCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.alphaPanel.add((Component)this.alphaCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.colorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ToolImageAlphaEditorUI.this.evaluating) {
                    ToolImageAlphaEditorUI.this.fireTabPropertiesChange(ToolImageAlphaEditorUI.this);
                }
            }
        });
        this.alphaCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ToolImageAlphaEditorUI.this.evaluating) {
                    ToolImageAlphaEditorUI.this.fireTabPropertiesChange(ToolImageAlphaEditorUI.this);
                }
            }
        });
        this.frameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ToolImageAlphaEditorUI.this.evaluating) {
                    ToolImageAlphaEditorUI.this.evaluateEnables();
                    ToolImageAlphaEditorUI.this.fireTabPropertiesChange(ToolImageAlphaEditorUI.this);
                }
            }
        });
    }

    public void setContext(WhiteboardContext context) {
        this.context = context;
    }

    public AttributeEditorInterface newInstance() {
        ToolImageAlphaEditorUI ui = new ToolImageAlphaEditorUI();
        ui.setContext(this.context);
        return ui;
    }

    public void addAttribute(AbstractAttribute attribute) {
        if (this.attribute == null) {
            this.attribute = attribute;
        }
        this.attributes.add(attribute);
        this.colorCombo.makeAndAdd((Color)((ToolImageAlpha)attribute).getColor());
        this.evaluateAttributes();
    }

    public boolean removeAttribute(AbstractAttribute attribute) {
        this.attributes.remove(attribute);
        this.evaluateAttributes();
        return this.attributes.isEmpty();
    }

    public void applyChanges() {
        boolean ignoreAlpha;
        boolean ignoreColor;
        int alpha = 0;
        int rgb = 0;
        boolean bl = ignoreColor = !(this.colorCombo.getColor() instanceof Color);
        if (!ignoreColor) {
            rgb = this.colorCombo.getColor().getRGB() & 0xFFFFFF;
        }
        boolean bl2 = ignoreAlpha = this.alphaCombo.getAlpha() < 0;
        if (!ignoreAlpha) {
            alpha = this.alphaCombo.getAlpha();
        }
        boolean ignoreFrame = this.frameCombo.getSelectedIndex() == 0;
        boolean frameVisible = this.frameCombo.getSelectedIndex() == FRAME_VISIBLE_INDEX;
        for (ToolImageAlpha toolAlpha : this.attributes) {
            if (ignoreColor) {
                rgb = ((Color)toolAlpha.getColor()).getRGB() & 0xFFFFFF;
            }
            if (ignoreAlpha) {
                alpha = toolAlpha.getAlpha();
            }
            if (!ignoreColor || !ignoreAlpha) {
                Color color = new Color(rgb);
                toolAlpha.setColor((Object)color, alpha);
            }
            if (ignoreFrame || toolAlpha.isFrameVisible() == frameVisible) continue;
            toolAlpha.setFrameVisible(frameVisible);
        }
        this.evaluateEnables();
    }

    public boolean isApplyValid() {
        return true;
    }

    public String getTabName() {
        return this.attribute.getTabName();
    }

    public String getDisplayName() {
        return this.attribute.getDisplayName();
    }

    public void evaluateAttributes() {
        boolean commonColor = this.attributes.size() > 0;
        boolean commonAlpha = this.attributes.size() > 0;
        boolean commonVisibleFrame = this.attributes.size() > 0;
        boolean visibleFrame = false;
        boolean firstTime = true;
        int rgb = 0;
        int alpha = 0;
        int test = 0;
        this.evaluating = true;
        for (ToolImageAlpha toolAlpha : this.attributes) {
            if (firstTime) {
                alpha = toolAlpha.getAlpha();
                rgb = 0xFFFFFF & ((Color)toolAlpha.getColor()).getRGB();
                visibleFrame = toolAlpha.isFrameVisible();
                firstTime = false;
                continue;
            }
            if (alpha != toolAlpha.getAlpha()) {
                commonAlpha = false;
            }
            if (rgb != (test = 0xFFFFFF & ((Color)toolAlpha.getColor()).getRGB())) {
                commonColor = false;
            }
            if (toolAlpha.isFrameVisible() == visibleFrame) continue;
            commonVisibleFrame = false;
        }
        int itemIndex = 0;
        if (commonColor && !firstTime) {
            for (itemIndex = this.colorCombo.getItemCount() - 1; itemIndex > 0 && (this.colorCombo.getColorAt(itemIndex) == null || (test = 0xFFFFFF & this.colorCombo.getColorAt(itemIndex).getRGB()) != rgb); --itemIndex) {
            }
        }
        if (this.colorCombo.getSelectedIndex() != itemIndex) {
            this.colorCombo.setSelectedIndex(itemIndex);
        }
        int alphaIndex = 0;
        if (commonAlpha) {
            for (alphaIndex = this.alphaCombo.getItemCount() - 1; alphaIndex > 0 && (alpha < this.alphaCombo.getAlphaAt(alphaIndex) || this.alphaCombo.getAlphaAt(alphaIndex) < 0); --alphaIndex) {
            }
        }
        if (this.alphaCombo.getSelectedIndex() != alphaIndex) {
            this.alphaCombo.setSelectedIndex(alphaIndex);
        }
        int frameVisibleIndex = 0;
        if (commonVisibleFrame) {
            for (frameVisibleIndex = this.frameCombo.getItemCount() - 1; frameVisibleIndex > 0 && frameVisibleIndex == FRAME_VISIBLE_INDEX != visibleFrame; --frameVisibleIndex) {
            }
        }
        if (this.frameCombo.getSelectedIndex() != frameVisibleIndex) {
            this.frameCombo.setSelectedIndex(frameVisibleIndex);
        }
        this.evaluateEnables();
        this.evaluating = false;
    }

    private void evaluateEnables() {
        this.colorCombo.setEnabled(!this.attributes.isEmpty());
        this.frameCombo.setEnabled(!this.attributes.isEmpty());
        this.alphaCombo.setEnabled(!this.attributes.isEmpty());
    }
}

