/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.attributes.AttributeSetEvent;
import com.elluminate.groupware.whiteboard.attributes.ToolColorInterface;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickAlphaPicker;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickEditorPanel;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.QuickEditorInterface;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesPanel;
import com.elluminate.gui.component.PopupColorPicker;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.event.ThrowableListener;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class QuickColorPanel
extends QuickEditorPanel
implements QuickEditorInterface {
    private static final Dimension BUTTON_SIZE = new Dimension(24, 24);
    private static final Color NO_COLOR = null;
    private I18n i18n = I18n.create((Object)this);
    private PopupColorPicker colorPicker;
    private QuickAlphaPicker alphaPicker;
    private HashSet<Object> sourceNodes = new HashSet();
    private HashMap colorSources = new HashMap();
    private LinkedList attributes = new LinkedList();
    private boolean evaluating = false;
    private boolean colorChanged = false;
    private boolean alphaChanged = false;
    private WhiteboardContext context;

    public QuickColorPanel(ThrowableListener tl) {
        try {
            this.jbInit(tl);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    public QuickColorPanel(WhiteboardContext context) {
        this(context.getThrowableListener());
        this.setContext(context);
    }

    void jbInit(ThrowableListener tl) throws Exception {
        this.colorPicker = new PopupColorPicker(BUTTON_SIZE, NO_COLOR);
        this.colorPicker.setFocusable(false);
        this.colorPicker.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.QUICKCOLORPANEL_COLORPICKERTIP));
        this.colorPicker.addPropertyChangeListener("QuickColorPicker.chosenColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                QuickColorPanel.this.colorChanged = true;
                QuickColorPanel.this.changedAction();
            }
        });
        this.alphaPicker = new QuickAlphaPicker(tl);
        this.alphaPicker.setFocusable(false);
        this.alphaPicker.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.QUICKCOLORPANEL_ALPHAPICKERTIP));
        this.alphaPicker.setTriggerButtonToolTipText(this.alphaPicker.getToolTipText());
        this.alphaPicker.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.alphaPicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QuickColorPanel.this.alphaChanged = true;
                QuickColorPanel.this.changedAction();
            }
        });
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.colorPicker);
        this.add(new JSeparator(1));
        this.add(this.alphaPicker);
    }

    public AttributeEditorInterface newInstance() {
        QuickColorPanel ui = new QuickColorPanel(this.context);
        ui.setContext(this.context);
        return ui;
    }

    private void changedAction() {
        if (!this.evaluating) {
            this.fireTabPropertiesChange(this);
        }
    }

    @Override
    public void addQuickAttribute(AbstractAttribute attribute, ToolPropertiesPanel panel) {
        if (attribute.getParent() != null) {
            this.sourceNodes.add(attribute.getParent());
        }
        if (attribute.isQuickAttribute() && attribute instanceof ToolColorInterface) {
            String attributeGroup = attribute.getName();
            QuickEditorInterface.RefCount refCount = (QuickEditorInterface.RefCount)this.colorSources.get(attributeGroup);
            if (refCount == null) {
                refCount = new QuickEditorInterface.RefCount();
                this.colorSources.put(attributeGroup, refCount);
            }
            refCount.addRef();
            this.attributes.add(attribute);
            this.evaluateAttributes();
        }
        this.validateQuickVisibility();
    }

    @Override
    public void removeQuickAttribute(AbstractAttribute attribute) {
        this.sourceNodes.remove(attribute.getParent());
        if (attribute.isQuickAttribute() && attribute instanceof ToolColorInterface) {
            String attributeGroup = attribute.getName();
            QuickEditorInterface.RefCount refCount = (QuickEditorInterface.RefCount)this.colorSources.get(attributeGroup);
            if (refCount == null) {
                return;
            }
            refCount.removeRef();
            if (refCount.isEmpty()) {
                this.colorSources.remove(attributeGroup);
            }
            this.attributes.remove(attribute);
            this.evaluateAttributes();
        }
        this.validateQuickVisibility();
    }

    @Override
    public void validateQuickVisibility() {
        boolean visible = this.attributes.size() > 0 && this.attributes.size() == this.sourceNodes.size();
        boolean enable = this.attributes.size() > 0;
        this.colorPicker.setEnabled(enable);
        this.alphaPicker.setEnabled(enable);
        this.setVisible(visible);
    }

    public void setContext(WhiteboardContext context) {
        this.context = context;
    }

    public void addAttribute(AbstractAttribute attribute) {
        this.addQuickAttribute(attribute, null);
    }

    public boolean removeAttribute(AbstractAttribute attribute) {
        this.removeQuickAttribute(attribute);
        return this.colorSources.size() == 0;
    }

    public void applyChanges() {
        if (!this.colorChanged && !this.alphaChanged) {
            return;
        }
        this.alphaChanged = false;
        this.colorChanged = false;
        for (ToolColorInterface toolColor : this.attributes) {
            Color oldColor = (Color)toolColor.getColor();
            Color color = null;
            Color curColor = this.colorPicker.getColor();
            if (curColor != null) {
                color = new Color(curColor.getRGB());
            }
            if (color == null && oldColor != null) {
                color = new Color(oldColor.getRGB());
            }
            if (color == null) continue;
            int alpha = this.alphaPicker.getAlpha();
            if (alpha < 0 || alpha > 255) {
                alpha = toolColor.getAlpha();
            }
            if (alpha < 0 || alpha > 255) continue;
            toolColor.setColor((Object)color, alpha);
        }
        this.fireEvaluate(this);
    }

    public void evaluateAttributes() {
        Color colorToSelect = NO_COLOR;
        int alphaToSelect = -1;
        this.evaluating = true;
        int colorCount = 0;
        int alphaCount = 0;
        this.validateQuickVisibility();
        if (this.isEnabled()) {
            for (ToolColorInterface toolColor : this.attributes) {
                int alpha;
                Color color = new Color(((Color)toolColor.getColor()).getRGB());
                if (color != null && !color.equals(colorToSelect)) {
                    ++colorCount;
                    if (colorToSelect == NO_COLOR) {
                        colorToSelect = color;
                    }
                }
                if ((alpha = toolColor.getAlpha()) < 0 || alpha == alphaToSelect || ++alphaCount != 1) continue;
                alphaToSelect = alpha;
            }
        }
        if (colorCount == 1) {
            this.colorPicker.setColor(colorToSelect);
        } else {
            this.colorPicker.setColor(NO_COLOR);
        }
        if (alphaCount == 1 && alphaToSelect >= 0) {
            this.alphaPicker.setAlpha(alphaToSelect);
        } else {
            this.alphaPicker.clearAlpha();
        }
        this.evaluating = false;
    }

    public boolean isApplyValid() {
        return true;
    }

    public String getTabName() {
        return "QuickColor";
    }

    public String getDisplayName() {
        return "QuickColor";
    }

    @Override
    public void onAttributeSetChange(AttributeSetEvent e) {
        AttributeSet attributeSet = e.getData();
        Color textColor = StyleConstants.getForeground(attributeSet);
        this.colorPicker.setColor(textColor);
        this.evaluateAttributes();
    }
}

