/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.gui.component.ColorIcon;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class ColorPicker
extends JComboBox {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static Border lineBorder = BorderFactory.createLineBorder(Color.black, 2);
    private static Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    protected static Color[] colors = new Color[]{Color.black, Color.gray, new Color(128, 0, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 128), new Color(128, 0, 128), new Color(128, 64, 0), Color.white, Color.lightGray, Color.red, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta, new Color(255, 128, 0)};
    private static String[] names = new String[]{"editors.Black", "editors.Gray", "editors.Maroon", "editors.Olive", "editors.Forest", "editors.Teal", "editors.Navy", "editors.Purple", "editors.Brown", "editors.White", "editors.LightGray", "editors.Red", "editors.Yellow", "editors.Green", "editors.Cyan", "editors.Blue", "editors.Magenta", "editors.Peach"};
    protected static String[] colorNames = new String[names.length];
    private Dialog chooser = null;
    private JColorChooser colorChooser = null;
    private ComboItem previousItem = null;
    private LinkedList listeners = new LinkedList();
    private ActionListener okListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = ColorPicker.this.colorChooser.getColor();
            ComboItem customColorItem = ColorPicker.this.makeAndAdd(color);
            ColorPicker.this.setSelectedItem(customColorItem);
        }
    };
    private ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorPicker.this.setSelectedItem(ColorPicker.this.previousItem);
        }
    };

    public ColorPicker() {
        super.addItem(new ComboItem(null, i18n.getString((PropertiesEnum)StringsProperties.EDITORS_NOCHANGE)));
        super.addItem(new ComboItem(new CustomColor(), i18n.getString((PropertiesEnum)StringsProperties.EDITORS_CUSTOM)));
        for (int i = 0; i < colors.length; ++i) {
            super.addItem(new ComboItem(colors[i], colorNames[i]));
        }
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboItem item = (ComboItem)ColorPicker.this.getSelectedItem();
                if (item.getObject() instanceof CustomColor) {
                    ((CustomColor)item.getObject()).chooseColor();
                }
                ColorPicker.this.previousItem = (ComboItem)ColorPicker.this.getSelectedItem();
                ColorPicker.this.fireActionListeners(e);
            }
        });
        super.setRenderer(new ColorCellRenderer());
    }

    @Override
    public void addActionListener(ActionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    private void fireActionListeners(ActionEvent e) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ActionListener)iter.next()).actionPerformed(e);
        }
    }

    public Color getColor() {
        Object object = this.getSelectedItem();
        if (object instanceof ComboItem && ((ComboItem)object).getObject() instanceof Color) {
            return (Color)((ComboItem)object).getObject();
        }
        return null;
    }

    public Color getColorAt(int index) {
        Object object = this.getItemAt(index);
        if (object instanceof ComboItem && ((ComboItem)object).getObject() instanceof Color) {
            return (Color)((ComboItem)object).getObject();
        }
        return null;
    }

    protected ComboItem makeAndAdd(Color color) {
        ComboItem comboItem;
        int rgb = 0xFFFFFF & color.getRGB();
        for (int i = 0; i < this.getItemCount(); ++i) {
            comboItem = (ComboItem)super.getItemAt(i);
            if (!(comboItem.getObject() instanceof Color) || rgb != (0xFFFFFF & ((Color)comboItem.getObject()).getRGB())) continue;
            return comboItem;
        }
        int red = color.getRed();
        int blue = color.getBlue();
        int green = color.getGreen();
        ComboItem item = new ComboItem(color, "(" + red + "," + blue + "," + green + ")");
        for (int i = 0; i < this.getItemCount(); ++i) {
            comboItem = (ComboItem)super.getItemAt(i);
            if (!(comboItem.getObject() instanceof Color) || (((Color)comboItem.getObject()).getRGB() & 0xFFFFFF) != rgb) continue;
            return item;
        }
        super.addItem(item);
        return item;
    }

    static {
        for (int i = 0; i < names.length; ++i) {
            ColorPicker.colorNames[i] = i18n.getStringLegacy(names[i]);
        }
    }

    class ColorCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ColorIcon icon = new ColorIcon();

        ColorCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ComboItem item = (ComboItem)value;
            if (item != null && item.getObject() instanceof Color) {
                this.icon.setColor((Color)item.getObject());
                if (this.getIcon() != this.icon) {
                    this.setIcon((Icon)this.icon);
                }
            } else if (this.getIcon() != null) {
                this.setIcon(null);
            }
            if (item == null) {
                if (!this.getText().equals("null")) {
                    this.setText("null");
                }
            } else if (!this.getText().equals(item.getDescription())) {
                this.setText(item.getDescription());
            }
            if (isSelected) {
                if (this.getBorder() != lineBorder) {
                    this.setBorder(lineBorder);
                }
            } else if (this.getBorder() != emptyBorder) {
                this.setBorder(emptyBorder);
            }
            return this;
        }
    }

    class ComboItem {
        Object object;
        String description;

        public ComboItem(Object object, String description) {
            this.object = object;
            this.description = description;
        }

        public Object getObject() {
            return this.object;
        }

        public String getDescription() {
            return this.description;
        }
    }

    class CustomColor {
        public void chooseColor() {
            if (ColorPicker.this.chooser == null) {
                ColorPicker.this.colorChooser = new JColorChooser();
                ColorPicker.this.chooser = JColorChooser.createDialog(ColorPicker.this, i18n.getString((PropertiesEnum)StringsProperties.TOOLCOLOREDITORUI_CHOOSECOLOR), true, ColorPicker.this.colorChooser, ColorPicker.this.okListener, ColorPicker.this.cancelListener);
            }
            ColorPicker.this.chooser.setVisible(true);
            ColorPicker.this.chooser.dispose();
            ColorPicker.this.chooser = null;
        }
    }
}

