/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.module.ui.BoxUI;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class AlphaPicker
extends JComboBox {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static Border lineBorder = BorderFactory.createLineBorder(Color.black, 2);
    private static Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    static int[] ALPHA_LEVELS = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100};
    static String[] ALPHA_TEXT = new String[]{"Clear", " 5%", "10%", "15%", "20%", "25%", "30%", "35%", "40%", "45%", "50%", "55%", "60%", "65%", "70%", "75%", "80%", "85%", "90%", "95%", "Solid"};
    private JLabel alphaCellLabel = new JLabel();
    private ComboItem previousItem = null;
    private LinkedList listeners = new LinkedList();

    public AlphaPicker() {
        this.addItem(new ComboItem(null, i18n.getString((PropertiesEnum)StringsProperties.EDITORS_NOCHANGE)));
        for (int i = 0; i < ALPHA_LEVELS.length; ++i) {
            this.addItem(new ComboItem(new Integer(ALPHA_LEVELS[i]), ALPHA_TEXT[i]));
        }
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaPicker.this.fireActionListeners(e);
            }
        });
        super.setRenderer(new AlphaCellRenderer());
    }

    @Override
    public void addActionListener(ActionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    private void fireActionListeners(ActionEvent e) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ActionListener)iter.next()).actionPerformed(e);
        }
    }

    public int findAlpha(int alpha) {
        double alphaVal = (double)alpha * 100.0 / 255.0;
        for (int ix = 0; ix < this.getItemCount(); ++ix) {
            double curVal;
            Object item = this.getItemAt(ix);
            if (!(item instanceof ComboItem)) continue;
            ComboItem cItem = (ComboItem)item;
            if (cItem.object == null || !(Math.abs(alphaVal - (curVal = ((Integer)cItem.object).doubleValue())) < 1.0)) continue;
            return ix;
        }
        return -1;
    }

    public int getAlpha() {
        return this.decodedAlpha(this.getSelectedItem());
    }

    public int getAlphaAt(int index) {
        return this.decodedAlpha(this.getItemAt(index));
    }

    private int decodedAlpha(Object object) {
        if (object instanceof ComboItem && ((ComboItem)object).getObject() instanceof Integer) {
            int alpha = (Integer)((ComboItem)object).getObject() * 255;
            return alpha / 100;
        }
        return -1;
    }

    class AlphaCellRenderer
    implements ListCellRenderer {
        private AlphaIcon icon;

        AlphaCellRenderer() {
            this.icon = new AlphaIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ComboItem item = (ComboItem)value;
            if (item.getObject() instanceof Integer) {
                int percent = (Integer)item.getObject();
                this.icon.setDensity(percent * 255 / 100);
            } else {
                this.icon.setDensity(-1);
            }
            if (!AlphaPicker.this.alphaCellLabel.getText().equals(item.getDescription())) {
                AlphaPicker.this.alphaCellLabel.setText(item.getDescription());
            }
            if (AlphaPicker.this.alphaCellLabel.getIcon() != this.icon) {
                AlphaPicker.this.alphaCellLabel.setIcon(this.icon);
            }
            if (isSelected) {
                if (AlphaPicker.this.alphaCellLabel.getBorder() != lineBorder) {
                    AlphaPicker.this.alphaCellLabel.setBorder(lineBorder);
                }
            } else if (AlphaPicker.this.alphaCellLabel.getBorder() != emptyBorder) {
                AlphaPicker.this.alphaCellLabel.setBorder(emptyBorder);
            }
            return AlphaPicker.this.alphaCellLabel;
        }
    }

    class AlphaIcon
    implements Icon {
        private int width;
        private int height;
        private int density = -1;
        private Color fill;
        private int thickness;
        private int offset;

        public AlphaIcon() {
            this(15, 15);
        }

        public AlphaIcon(int width, int height) {
            this.width = width;
            this.height = height;
            this.thickness = (height - 2) / 2;
            this.offset = this.thickness / 2 + 1;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawRect(x, y, this.width - 1, this.height - 1);
            if (this.density < 0 || this.density > 255) {
                g.setColor(c.getBackground());
                g.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
                g.setColor(Color.black);
                for (int i = 0; i < this.width; i += this.width / 5) {
                    g.drawLine(x + i, y, x + i, y + this.height);
                }
            } else {
                g.setColor(Color.white);
                g.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
                BoxUI.fillRect(g, x + 1, y + this.offset, this.width - 2, this.thickness, Color.black, this.density);
            }
        }

        public void setDensity(int density) {
            this.density = density;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    class ComboItem {
        Object object;
        String description;

        public ComboItem(Object object, String description) {
            this.object = object;
            this.description = description;
        }

        public Object getObject() {
            return this.object;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

