/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.module.ui.ProgressInputStream;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.groupware.whiteboard.xml.WhiteboardDataFile;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jdom.JDOMException;

public class WBDLoadDialog
extends CDialog
implements ProgressUpdate {
    private final I18n i18n = I18n.create((Object)((Object)this));
    private WhiteboardContext context = null;
    private File fileToLoad = null;
    private int modalReturn = 64;
    private WhiteboardDataFile jdom = null;
    private JProgressBar progress = null;
    private WhiteboardModel modelRead = null;
    private int delta = 0;
    JPanel panel = new JPanel();
    GridBagLayout progressLayout = new GridBagLayout();
    JLabel fileName = new JLabel();
    JLabel readLabel = new JLabel();
    JProgressBar readProgress = new JProgressBar();
    JLabel convertLabel = new JLabel();
    JProgressBar conversionProgress = new JProgressBar();
    String progressName;
    int nameWidth = 0;
    Thread jdomLoader = null;

    public WBDLoadDialog(WhiteboardContext context, Frame frame, String title, File fileToLoad, boolean modal) {
        super(frame, title, modal);
        this.getRootPane().putClientProperty("Window.style", "small");
        this.context = context;
        this.fileToLoad = fileToLoad;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    void jbInit() throws Exception {
        this.panel.setLayout(this.progressLayout);
        this.fileName.setText(this.fileToLoad.getName());
        this.readLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_FILEREADING));
        this.convertLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_DATACONVERSION));
        this.readProgress.setMinimumSize(new Dimension(300, 16));
        this.readProgress.setPreferredSize(new Dimension(300, 16));
        this.conversionProgress.setMinimumSize(new Dimension(300, 16));
        this.conversionProgress.setPreferredSize(new Dimension(300, 16));
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.fileName, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.readLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.readProgress, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.convertLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.conversionProgress, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.readProgress.setStringPainted(true);
        this.conversionProgress.setStringPainted(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (WBDLoadDialog.this.jdomLoader != null) {
                    WBDLoadDialog.this.jdomLoader.start();
                }
            }
        });
    }

    public void dispose() {
        this.jdom = null;
        this.modelRead = null;
        super.dispose();
    }

    public void processFile(boolean b) {
        Runnable loader = new Runnable(){

            @Override
            public void run() {
                Runtime rt = Runtime.getRuntime();
                long avail = rt.freeMemory() + rt.maxMemory() - rt.totalMemory();
                if (avail < 3L * WBDLoadDialog.this.fileToLoad.length()) {
                    WBDLoadDialog.fullGC();
                }
                if ((avail = rt.freeMemory() + rt.maxMemory() - rt.totalMemory()) < 3L * WBDLoadDialog.this.fileToLoad.length()) {
                    String title = WBDLoadDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_MEMORYWARNINGTITLE);
                    String msg = WBDLoadDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_MEMORYWARNINGMSG, new Object[]{WBDLoadDialog.this.fileToLoad.getName()});
                    int which = ModalDialog.showConfirmDialog((Component)WBDLoadDialog.this.context.getDialogParentFrame(), (Object)msg, (String)title, (int)0);
                    if (which == 1) {
                        WBDLoadDialog.this.setVisible(false);
                        return;
                    }
                    System.gc();
                }
                WBDLoadDialog.this.progress = WBDLoadDialog.this.readProgress;
                try {
                    BufferedInputStream in = new BufferedInputStream(new ProgressInputStream(WBDLoadDialog.this.readProgress, new FileInputStream(WBDLoadDialog.this.fileToLoad)));
                    WBDLoadDialog.this.jdom.readDataStream(in);
                }
                catch (Throwable e) {
                    WBDLoadDialog.this.jdom = null;
                    WBDLoadDialog.this.setVisible(false);
                    System.gc();
                    if (e instanceof JDOMException) {
                        LogSupport.message((Object)this, (String)"run", (String)Debug.getStackTrace((Throwable)e));
                    }
                    StringBuffer details = new StringBuffer();
                    details.append(e.toString());
                    for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        details.append("\n" + cause.toString());
                    }
                    String title = WBDLoadDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_ERRORREADINGWBD);
                    String msg = "";
                    msg = e instanceof OutOfMemoryError ? WBDLoadDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_MEMORYERRORREADINGWBDMSG, new Object[]{WBDLoadDialog.this.fileToLoad.getName()}) : WBDLoadDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_ERRORREADINGWBDMSG, new Object[]{WBDLoadDialog.this.fileToLoad.getName(), details});
                    ModalDialog.showMessageDialog((Component)WBDLoadDialog.this.context.getDialogParentFrame(), (Object)msg, (String)title, (int)0);
                    return;
                }
                int reserve = WBDLoadDialog.this.jdom.getMaxInstances() / 10;
                WBDLoadDialog.this.progress = WBDLoadDialog.this.conversionProgress;
                WBDLoadDialog.this.setMaximum(WBDLoadDialog.this.jdom.getMaxInstances() + reserve);
                try {
                    WBDLoadDialog.this.modelRead = WBDLoadDialog.this.jdom.processJDOM(WBDLoadDialog.this.jdom, WBDLoadDialog.this.context, (ProgressUpdate)WBDLoadDialog.this);
                    WBDLoadDialog.this.jdom = null;
                    if (WBDLoadDialog.this.progress != null) {
                        WBDLoadDialog.this.setValue(WBDLoadDialog.this.progress.getValue() + reserve);
                    }
                }
                catch (Throwable e) {
                    WBDLoadDialog.this.jdom = null;
                    if (e instanceof JDOMException) {
                        LogSupport.message((Object)this, (String)"run", (String)Debug.getStackTrace((Throwable)e));
                    }
                    StringBuffer details = new StringBuffer();
                    details.append(e.toString());
                    for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        details.append("\n" + cause.toString());
                    }
                    String title = WBDLoadDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_ERRORCONVERTINGWBD);
                    String msg = WBDLoadDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_ERRORCONVERTINGWBDMSG, new Object[]{WBDLoadDialog.this.fileToLoad.getName(), details});
                    WBDLoadDialog.this.setVisible(false);
                    System.gc();
                    ModalDialog.showMessageDialog((Component)WBDLoadDialog.this.context.getDialogParentFrame(), (Object)msg, (String)title, (int)0);
                    return;
                }
                WBDLoadDialog.this.setVisible(false);
            }
        };
        this.jdom = new WhiteboardDataFile(this.context);
        this.jdomLoader = new WorkerThread(loader, "Whiteboard Loader");
        this.jdomLoader.setDaemon(true);
        Dimension paneSize = this.getSize();
        Frame appFrame = this.context.getDialogParentFrame();
        Point screenLocation = appFrame.getLocation();
        Dimension screenSize = appFrame.getSize();
        this.setLocation(screenLocation.x + (screenSize.width - paneSize.width) / 2, screenLocation.y + (screenSize.height - paneSize.height) / 2);
        if (b) {
            this.setVisible(b);
        } else {
            this.jdomLoader.start();
        }
    }

    public WhiteboardModel getModel() {
        return this.modelRead;
    }

    public void setMaximum(final int value) {
        this.delta = value / 100;
        if (this.progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WBDLoadDialog.this.progress.setMaximum(value);
                }
            });
        }
    }

    public void incrementMaximum(final int increment) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WBDLoadDialog.this.progress.setMaximum(WBDLoadDialog.this.progress.getMaximum() + increment);
            }
        });
    }

    public int getValue() {
        return this.progress != null ? this.progress.getValue() : 0;
    }

    public void setValue(final int value) {
        if (this.progress != null && (value - this.delta >= this.progress.getValue() || value >= this.progress.getMaximum())) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WBDLoadDialog.this.progress.setValue(value);
                }
            });
        }
    }

    public void setValue(WBElement element) {
        this.setValue(element.getInstanceCount());
    }

    public void setFilename(String name) {
        this.progressName = name;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WBDLoadDialog.this.fileName.setText(WBDLoadDialog.this.progressName);
            }
        });
    }

    public static void fullGC() {
        long wasFree;
        Runtime rt = Runtime.getRuntime();
        long isFree = rt.freeMemory();
        do {
            wasFree = isFree;
            rt.runFinalization();
            rt.gc();
        } while ((isFree = rt.freeMemory()) > wasFree);
    }
}

