/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.CompatibleFont;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.TextToolModel;
import com.elluminate.groupware.whiteboard.tools.TextUIInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class TextUI
extends AbstractUI
implements TextUIInterface {
    private TextHitInfo textHit = null;
    private TextLayout textLayout = null;
    private AttributedCharacterIterator iter = null;
    private static FontRenderContext fontContext = null;
    private float cloneYHeight;
    private static Stroke boundStroke = new BasicStroke(1.0f, 0, 2, 0.0f);
    private double scaleX = 0.0;
    private double scaleY = 0.0;
    private double oldScaleX = 0.0;
    private double oldScaleY = 0.0;

    public void draw(Graphics g, AbstractToolModel tool) {
        TextToolModel toolModel = (TextToolModel)tool;
        if (toolModel.getDisplayText() == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.scaleX = g2.getTransform().getScaleX();
        this.scaleY = g2.getTransform().getScaleX();
        if (this.oldScaleX != this.scaleX || this.oldScaleY != this.scaleY) {
            tool.setUIInvalid(true);
            this.oldScaleX = this.scaleX;
            this.oldScaleY = this.scaleY;
        }
        if (fontContext == null) {
            fontContext = g2.getFontRenderContext();
        }
        if (toolModel.isUIInvalid()) {
            LineMetrics metrics = toolModel.getFont().getLineMetrics(toolModel.getDisplayText(), fontContext);
            toolModel.setAscent(metrics.getAscent(), true);
            this.textHit = null;
            tool.getVBounds();
        }
        if (tool.getColor() != null) {
            g2.setColor((Color)tool.getColor().getColor());
        }
        try {
            if (toolModel.getDisplayText() != null && toolModel.getDisplayText().length() > 0) {
                if (toolModel.isUIInvalid() || this.iter == null) {
                    AttributedString attText = new AttributedString(toolModel.getDisplayText());
                    attText.addAttribute(TextAttribute.FONT, toolModel.getFont());
                    if (toolModel.getFont().isUnderline()) {
                        attText.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                    }
                    this.iter = attText.getIterator();
                    this.textLayout = new TextLayout(this.iter, fontContext);
                }
                g2.drawString(this.iter, (float)tool.getLocation().getX(), (float)tool.getLocation().getY() + toolModel.getAscent());
            }
            g2.setColor(Color.black);
            if (toolModel.isCreating()) {
                if (this.textLayout != null) {
                    this.textHit = toolModel.getStringIndx() <= 0 ? this.textLayout.getNextLeftHit(1) : this.textLayout.getNextRightHit(toolModel.getStringIndx() - 1);
                    if (this.textHit != null) {
                        AffineTransform at = AffineTransform.getTranslateInstance(tool.getLocation().getX(), tool.getLocation().getY() + (double)toolModel.getAscent());
                        Shape caret = at.createTransformedShape(this.textLayout.getCaretShape(this.textHit));
                        g2.draw(caret);
                    }
                }
                int x = tool.getVBounds().x - 3;
                int y = tool.getVBounds().y - 2;
                int width = tool.getVBounds().width;
                int height = tool.getVBounds().height + 4;
                g2.setColor(Color.black);
                g2.setStroke(boundStroke);
                g2.drawRect(x, y, width, height);
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        toolModel.setUIInvalid(false);
    }

    public int getTextIndex(AbstractToolModel tool, int x, int y) {
        TextToolModel toolModel = (TextToolModel)tool;
        int index = toolModel.getDisplayText().length();
        if (this.textLayout != null) {
            TextHitInfo textHit = this.textLayout.hitTestChar(x, y);
            index = textHit.getInsertionIndex();
        }
        return index;
    }

    public Rectangle evaluateBounds(AbstractToolModel tool) {
        TextToolModel textTool = (TextToolModel)tool;
        CompatibleFont font = textTool.getFont();
        if (fontContext == null) {
            return tool.getBounds();
        }
        Rectangle2D stringRect = font.getStringBounds(textTool.getDisplayText(), fontContext);
        double w = stringRect.getWidth();
        if (textTool.isCreating()) {
            w += 8.0;
            if (textTool.getFont().isItalic()) {
                w += Math.ceil(textTool.getFont().getSize() / 3);
            }
        }
        float h = font.getLineMetrics(textTool.getDisplayText(), fontContext).getHeight();
        return new Rectangle(tool.getBounds().x, (int)Math.floor(tool.getLocation().getY()), (int)Math.ceil(w), (int)Math.ceil(h));
    }
}

