/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleSubAttribute;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.WBTextPane;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.WBUIComponent;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.TextEditorToolModel;
import com.elluminate.groupware.whiteboard.tools.TextEditorUIInterface;
import com.elluminate.util.log.LogSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class TextEditorUI
extends AbstractUI
implements TextEditorUIInterface {
    public void draw(Graphics g, AbstractToolModel tool) {
        this.draw(g, g, tool);
    }

    public void draw(Graphics g, Graphics unscaledG, AbstractToolModel tool) {
        TextEditorToolModel editorTool = (TextEditorToolModel)tool;
        WBTextPane wbTextPane = (WBTextPane)editorTool.getUIData();
        ControllerPane controller = (ControllerPane)editorTool.getContext().getController();
        if (wbTextPane == null) {
            wbTextPane = (WBTextPane)controller.getCanvas().getUIComponent((AbstractToolModel)editorTool);
            editorTool.setUIData((Object)wbTextPane);
            controller.getCanvas().addComponent(wbTextPane);
        }
        boolean leaveVisible = wbTextPane.isVisible();
        if (tool.getScreenParent() != controller.getCanvas().getScreen()) {
            wbTextPane.setVisible(true);
        }
        if (!editorTool.isSelected()) {
            editorTool.setUiComponentActive(false);
        }
        try {
            if (editorTool.isCreating()) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setStroke((BasicStroke)tool.getStroke().getStroke());
                g2.setColor(Color.black);
                int x = tool.getBounds().x;
                int y = tool.getBounds().y;
                int width = tool.getBounds().width;
                int height = tool.getBounds().height;
                g2.drawRect(x, y, width, height);
            } else {
                wbTextPane.render(unscaledG);
            }
        }
        catch (Throwable ex) {
            LogSupport.exception((Object)((Object)this), (String)"draw() - Repainting the tool", (Throwable)ex, (boolean)true);
        }
        if (editorTool.isUIInvalid()) {
            editorTool.setUIInvalid(false);
        }
        if (!leaveVisible) {
            wbTextPane.setVisible(false);
        }
    }

    public void endComposition(AbstractToolModel tool) {
        TextEditorToolModel editorTool = (TextEditorToolModel)tool;
        WBUIComponent wbTextPane = (WBUIComponent)editorTool.getUIData();
        wbTextPane.endComposition();
    }

    public void removeEditor(AbstractToolModel tool) {
        TextEditorToolModel editorTool = (TextEditorToolModel)tool;
        editorTool.setUiComponentActive(false);
        ControllerPane controller = (ControllerPane)tool.getContext().getController();
        controller.getCanvas().removeComponent((WBUIComponent)tool.getUIData());
        controller.getCanvas().disposeUIComponent(tool);
    }

    public boolean hasFocus(AbstractToolModel tool) {
        try {
            WBUIComponent wbTextPane = (WBUIComponent)tool.getUIData();
            if (wbTextPane != null) {
                return wbTextPane.hasFocus();
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"hasFocus", (Throwable)ex, (boolean)true);
        }
        return false;
    }

    public void grabFocus(AbstractToolModel tool) {
        try {
            WBUIComponent wbTextPane = (WBUIComponent)tool.getUIData();
            if (wbTextPane != null) {
                wbTextPane.grabFocus();
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"grabFocus", (Throwable)ex, (boolean)true);
        }
    }

    public void applyAttributeChange(AbstractToolModel tool, StyleSubAttribute sa) {
        try {
            WBUIComponent wbTextPane = (WBUIComponent)tool.getUIData();
            if (wbTextPane != null) {
                int xStart = ((TextEditorToolModel)tool).getXStart();
                int offset = ((TextEditorToolModel)tool).getXEnd() - ((TextEditorToolModel)tool).getXStart();
                wbTextPane.applyAttributeChange(sa, xStart, offset);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"attributeChange", (Throwable)ex, (boolean)true);
        }
    }

    public void updateUIFromConference(AbstractToolModel tool, AbstractAttribute att) {
        try {
            WBUIComponent wbTextPane = (WBUIComponent)tool.getUIData();
            if (wbTextPane != null) {
                wbTextPane.updateUIFromConference(att);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"attributeChange", (Throwable)ex, (boolean)true);
        }
    }

    public void drawImage(Graphics g, AbstractToolModel tool) {
        TextEditorToolModel editorTool = (TextEditorToolModel)tool;
        WBUIComponent wbTextPane = (WBUIComponent)editorTool.getUIData();
        if (wbTextPane == null) {
            ControllerPane controller = (ControllerPane)editorTool.getContext().getController();
            wbTextPane = controller.getCanvas().getUIComponent((AbstractToolModel)editorTool);
            editorTool.setUIData((Object)wbTextPane);
        }
        try {
            Graphics2D g2 = (Graphics2D)g.create();
            int x = tool.getVBounds().x;
            int y = tool.getVBounds().y;
            int width = tool.getVBounds().width;
            int height = tool.getVBounds().height;
            Image textImage = wbTextPane.getImage();
            g2.drawImage(textImage, x, y, width, height, null);
            g2.dispose();
        }
        catch (Throwable ex) {
            LogSupport.exception((Object)((Object)this), (String)"drawImage", (Throwable)ex, (boolean)true, (String)"Repainting the tool");
        }
    }

    public boolean isLink(AbstractToolModel tool, MouseEvent e) {
        WBUIComponent wbTextPane = (WBUIComponent)tool.getUIData();
        if (wbTextPane != null) {
            return wbTextPane.isLink(e);
        }
        return false;
    }

    public Cursor getCurrentCursor(AbstractToolModel tool) {
        JComponent ui;
        WBUIComponent wbTextPane = (WBUIComponent)tool.getUIData();
        if (wbTextPane != null && (ui = wbTextPane.getUI()) != null) {
            return ui.getCursor();
        }
        return null;
    }

    public void handleMouseRelease(MouseEvent e, AbstractToolModel tool) {
        WBUIComponent wbTextPane = (WBUIComponent)tool.getUIData();
        wbTextPane.handleMouseRelease(e, tool.getToolXOffset(), tool.getToolYOffset());
    }
}

