/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ScreenCellRenderer
extends DefaultTreeCellRenderer {
    private int bottomGap = 8;
    private Font clientRootFont;
    private WhiteboardContext context;
    private Font defaultFont = UIManager.getFont("Tree.font");
    protected Icon icon = ScreenModel.getStaticIcon();
    private Font privateRootFont;
    private ScreenModel screen = null;
    private int depth = 0;
    private Font serverRootFont;

    public ScreenCellRenderer(WhiteboardContext context) {
        this.context = context;
        String fontName = this.defaultFont.getName();
        int fontSize = this.defaultFont.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefferedSize = super.getPreferredSize();
        return new Dimension(prefferedSize.width, prefferedSize.height + this.bottomGap);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DisplayNode dNode;
        WBNode peer;
        boolean enabled = false;
        Font font = this.defaultFont;
        if (value instanceof DisplayNode && tree.isVisible() && (peer = (dNode = (DisplayNode)value).whiteboardPeer()) instanceof ScreenModel) {
            Icon icon;
            this.screen = (ScreenModel)peer;
            enabled = this.screen.isVisible();
            if (this.screen instanceof ScreenRoot) {
                font = ((ScreenRoot)this.screen).isPrivate() ? this.privateRootFont : (ObjectUID.decodeClientId((Long)this.screen.getObjectID()) == 1 ? this.serverRootFont : this.clientRootFont);
            }
            if (this.screen.getIcon() == null) {
                ScreenCellRenderer screenCellRenderer = this;
                icon = screenCellRenderer.screen.getStaticIcon();
            } else {
                icon = this.screen.getIcon();
            }
            this.icon = icon;
        }
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        label.setFont(font);
        label.setEnabled(enabled);
        return label;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public Icon getLeafIcon() {
        return this.icon;
    }

    @Override
    public Icon getOpenIcon() {
        return this.icon;
    }

    @Override
    public Icon getClosedIcon() {
        return this.icon;
    }

    @Override
    public Icon getDefaultLeafIcon() {
        return this.icon;
    }

    @Override
    public Icon getDefaultOpenIcon() {
        return this.icon;
    }

    @Override
    public Icon getDefaultClosedIcon() {
        return this.icon;
    }

    @Override
    public Icon getDisabledIcon() {
        return this.icon;
    }

    public void setCellGap(int bottomGap) {
        this.bottomGap = bottomGap;
    }
}

