/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.ui.PasteClerkContext;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.PaletteImage;
import com.elluminate.gui.dnd.UriListDataFlavor;
import com.elluminate.gui.dnd.XJavaSerializedObjectDataFlavor;
import com.elluminate.platform.Platform;
import com.elluminate.util.ExternalDataBean;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.PICTImporter;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PasteClerk {
    private static final int MAX_TEXT_DATA_LENGTH = 524288;
    private PasteClerkContext context;

    public PasteClerk(PasteClerkContext context) {
        this.context = context;
    }

    public boolean objectDropped(Transferable transferable, DataFlavor chosen, Point location, Object extra) {
        ScreenModel screen = (ScreenModel)extra;
        Object data = null;
        try {
            data = transferable.getTransferData(chosen);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"Can't read data from the transferable", (Throwable)ex, (boolean)true);
            return false;
        }
        if (WhiteboardDebug.DATAFLAVORS.show()) {
            DataFlavor[] flavList = transferable.getTransferDataFlavors();
            for (int ix = 0; ix < flavList.length; ++ix) {
                String val = PasteClerk.getContentAsText(transferable, flavList[ix], null, 256);
                LogSupport.message((Object)this, (String)"objectDropped", (String)("flavour " + ix + ": " + flavList[ix].getMimeType() + "\n  => " + val));
            }
            LogSupport.message((Object)this, (String)"objectDropped", (String)("flavor: " + chosen + " data: " + data + " type: " + (data == null ? "" : data.getClass().getName())));
        }
        if (screen == null) {
            screen = this.context.getScreen();
        }
        ExternalDataBean toolData = new ExternalDataBean(chosen.getMimeType(), null);
        ArrayList<AbstractToolModel> allTools = new ArrayList<AbstractToolModel>();
        AbstractToolModel realTool2 = null;
        if (data instanceof AbstractList) {
            AbstractList trList = (AbstractList)data;
            for (int ix = 0; ix < trList.size(); ++ix) {
                File file = null;
                try {
                    file = (File)trList.get(ix);
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"Can't read the file", (Throwable)ex, (boolean)true);
                }
                String mimeType = Platform.getMimeType((String)file.getName());
                if (PICTImporter.isPICT((String)mimeType)) {
                    try {
                        BufferedImage pictImage = PICTImporter.loadPICT((File)file);
                        if (pictImage == null) {
                            return false;
                        }
                        toolData.setData((Object)pictImage);
                    }
                    catch (Exception ex) {
                        LogSupport.exception((Object)this, (String)"Can't process the PICT image", (Throwable)ex, (boolean)true);
                    }
                } else if (ImageMimeUtilities.isValidImageMimeFile((File)file)) {
                    toolData.setData((Object)file);
                } else {
                    return false;
                }
                realTool2 = this.context.getToolByName("imagetool", screen, toolData);
                if (realTool2 == null) continue;
                allTools.add(realTool2);
            }
        } else if (data instanceof Image) {
            toolData.setData(data);
            realTool2 = this.context.getToolByName("imagetool", screen, toolData);
            if (realTool2 != null) {
                allTools.add(realTool2);
            }
        } else if (data instanceof PaletteImage) {
            toolData.setData(data);
            realTool2 = this.context.getToolByName("imagetool", screen, toolData);
            if (realTool2 != null) {
                allTools.add(realTool2);
            }
        } else if (data instanceof Reader || data instanceof InputStream || data instanceof String) {
            boolean toolCreated = false;
            toolData.setData(data);
            ArrayList<AbstractToolModel> realToolList = new ArrayList<AbstractToolModel>();
            try {
                List transferFiles;
                UriListDataFlavor df;
                DataFlavor mozImage = null;
                DataFlavor mozURL = null;
                try {
                    mozImage = new DataFlavor("application/x-moz-nativeimage");
                    mozURL = new DataFlavor("application/x-moz-file-promise-url");
                }
                catch (Throwable t) {
                    mozImage = null;
                }
                if (PICTImporter.isPICT((String)chosen.getMimeType())) {
                    if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                        toolData.setContentType(DataFlavor.imageFlavor.getMimeType());
                        toolData.setData(transferable.getTransferData(DataFlavor.imageFlavor));
                    }
                    realTool2 = this.context.getToolByName("imagetool", screen, toolData);
                    realToolList.add(realTool2);
                    toolCreated = true;
                } else if (mozImage != null && transferable.isDataFlavorSupported(mozImage) && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    toolData.setContentType(DataFlavor.imageFlavor.getMimeType());
                    toolData.setData(transferable.getTransferData(DataFlavor.imageFlavor));
                    realTool2 = this.context.getToolByName("imagetool", screen, toolData);
                    if (realTool2 != null) {
                        allTools.add(realTool2);
                    }
                } else if (mozImage != null && transferable.isDataFlavorSupported(mozImage) && mozURL != null && transferable.isDataFlavorSupported(mozURL)) {
                    String uriEncoding = Platform.getByteOrder() == 601 ? "UTF-16BE" : (Platform.getByteOrder() == 602 ? "UTF-16LE" : "UTF-16");
                    String uri = PasteClerk.getContentAsText(transferable, mozURL, uriEncoding);
                    if (uri.length() >= 524288) {
                        throw new IOException("URI list unreasonably large");
                    }
                    List transferFiles2 = UriListDataFlavor.getTransferFiles((String)uri, (boolean)true);
                    toolCreated = this.addToolsFromFileList(transferFiles2, realToolList);
                } else if (transferable.isDataFlavorSupported((DataFlavor)new UriListDataFlavor())) {
                    df = new UriListDataFlavor();
                    transferFiles = df.getTransferFiles(transferable);
                    toolCreated = this.addToolsFromFileList(transferFiles, realToolList);
                } else if (transferable.isDataFlavorSupported((DataFlavor)new XJavaSerializedObjectDataFlavor())) {
                    df = new XJavaSerializedObjectDataFlavor();
                    transferFiles = df.getTransferFiles(transferable);
                    if (transferFiles.isEmpty()) {
                        toolData.setData(transferable.getTransferData(DataFlavor.plainTextFlavor));
                        toolData.setContentType(DataFlavor.plainTextFlavor.getMimeType());
                        AbstractToolModel tool = this.context.getToolByName("texteditortool", this.context.getScreen(), toolData);
                        if (tool != null) {
                            realToolList.add(tool);
                            toolCreated = true;
                        }
                    } else {
                        toolCreated = this.addToolsFromFileList(transferFiles, realToolList);
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                toolCreated = false;
            }
            catch (IOException ioe) {
                toolCreated = false;
            }
            catch (UnsupportedFlavorException ufe) {
                toolCreated = false;
            }
            if (!toolCreated) {
                realTool2 = this.context.getToolByName("texteditortool", screen, toolData);
                realToolList.add(realTool2);
            }
            for (AbstractToolModel realTool2 : realToolList) {
                allTools.add(realTool2);
            }
        } else {
            return false;
        }
        if (!allTools.isEmpty()) {
            try {
                DPoint dloc = null;
                if (location != null) {
                    dloc = new DPoint(location);
                }
                WBNode[] nodes = new WBNode[allTools.size()];
                allTools.toArray(nodes);
                this.context.pasteTools(screen, dloc, nodes);
            }
            catch (Exception ex) {
                LogSupport.exception(this.getClass(), (String)"objectDropped()", (Throwable)ex, (boolean)true);
            }
        }
        this.context.setLocalSelectMode();
        return true;
    }

    private boolean addToolsFromFileList(List transferFiles, List realToolList) {
        boolean toolAdded = false;
        ExternalDataBean toolData = new ExternalDataBean();
        AbstractToolModel tool = null;
        Iterator it = transferFiles.iterator();
        while (it.hasNext()) {
            File file = null;
            Object o = it.next();
            file = o instanceof File ? (File)o : new File(o.toString());
            if (ImageMimeUtilities.isValidImageMimeFile((File)file)) {
                toolData.setData((Object)file);
                tool = this.context.getToolByName("imagetool", this.context.getScreen(), toolData);
            } else {
                toolData.setData((Object)o.toString());
                tool = this.context.getToolByName("texteditortool", this.context.getScreen(), toolData);
            }
            if (tool == null) continue;
            realToolList.add(tool);
            toolAdded = true;
        }
        return toolAdded;
    }

    private static String readContent(Reader rdr, int maxLength) throws IOException {
        StringBuilder output = new StringBuilder();
        char[] buf = new char[1024];
        int totalRead = 0;
        while (maxLength <= 0 || totalRead < maxLength) {
            try {
                int n = rdr.read(buf);
                if (n < 0) break;
                output.append(buf, 0, n);
                totalRead += n;
            }
            catch (EOFException ignored) {}
        }
        return output.toString();
    }

    private static String getCharsetEncoding(DataFlavor f) {
        StringTokenizer parser = new StringTokenizer(f.getMimeType(), ";");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken().trim();
            if (!token.startsWith("charset=")) continue;
            return token.substring(8);
        }
        return Charset.defaultCharset().name();
    }

    private static String getContentAsText(Transferable t, DataFlavor f) {
        return PasteClerk.getContentAsText(t, f, null);
    }

    private static String getContentAsText(Transferable t, DataFlavor f, String enc) {
        return PasteClerk.getContentAsText(t, f, enc, 524288);
    }

    private static String getContentAsText(Transferable t, DataFlavor f, String enc, int maxLength) {
        if (f.isFlavorTextType()) {
            try {
                Reader rdr = f.getReaderForText(t);
                return PasteClerk.readContent(rdr, maxLength);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        Object val = null;
        try {
            val = t.getTransferData(f);
        }
        catch (Throwable ignored) {
            return null;
        }
        if (enc == null) {
            enc = PasteClerk.getCharsetEncoding(f);
        }
        if (val instanceof InputStream) {
            try {
                InputStreamReader rdr = new InputStreamReader((InputStream)val, enc);
                return PasteClerk.readContent(rdr, maxLength);
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        if (val instanceof char[]) {
            return new String((char[])val);
        }
        if (val instanceof byte[]) {
            try {
                return new String((byte[])val, enc);
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        if (val != null) {
            return val.toString();
        }
        return null;
    }
}

