/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.ScreenName;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenPasteEntry;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.module.ui.ScreenRelationPanel;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanel;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanelListener;
import com.elluminate.groupware.whiteboard.module.ui.SizedNumericFilter;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.AbstractDocument;

public class NewScreenDialog
extends EasyDialog
implements ScreenSizePanelListener {
    private static final int NUMBER_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int TOTAL_COLUMNS = 2;
    private static I18n i18n = I18n.create((Object)new Object(){});
    private JPanel dialogPanel = new JPanel(new GridBagLayout());
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();
    private JButton applyButton = new JButton();
    private ScreenSizePanel screenSizePanel;
    private ScreenRelationPanel creationLocation;
    private JPanel screenNamesPanel = new JPanel(new GridBagLayout());
    private TitledBorder screenNamesBorder;
    private JLabel numberOfScreens = new JLabel();
    private JTextField numberOfScreensText = new JTextField();
    private JTable screenNameTable = new CTable();
    private ScreenNameTableModel tableModel = new ScreenNameTableModel();
    private JScrollPane scrollPane;
    private int defaultButtonSelection = 1;
    private ScreenName[] screenNames = new ScreenName[0];
    private boolean editLock = false;
    private int screenCount = 1;
    private String lastScreenCountText = "";
    private boolean validScreenCount = true;
    private ScreenModel[] screenParents = new ScreenModel[0];
    private String numberColumnHeaderText;
    private String nameColumnHeaderText;
    private boolean haveChanges = true;
    private WhiteboardContext context;
    private MouseAdapter clickAdapter = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            NewScreenDialog.this.processScreenCount();
        }
    };

    public NewScreenDialog(WhiteboardContext context) {
        super((Component)context.getDialogParentFrame(), "", true);
        this.setDefaultCloseOperation(1);
        this.context = context;
        this.setTitle(i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_DIALOGTITLE));
        this.numberColumnHeaderText = i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_NUMBERCOLUMN);
        this.nameColumnHeaderText = i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_NAMECOLUMN);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.creationLocation = new ScreenRelationPanel(i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_LOCATIONBORDER), this.defaultButtonSelection, true);
        this.screenSizePanel = new ScreenSizePanel(this.context, this, 4200, 4200);
        this.screenSizePanel.setDefaultSize(WhiteboardContext.DEFAULT_SIZE);
        this.cancelButton.setText(i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_CANCEL));
        this.okButton.setText(i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_OK));
        this.applyButton.setText(i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_APPLY));
        this.screenNamesBorder = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_SCREENNUMBERBORDER));
        this.screenNamesPanel.setBorder(BorderFactory.createCompoundBorder(this.screenNamesBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.numberOfScreens.setHorizontalAlignment(2);
        this.numberOfScreens.setText(i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_NUMBEROFSCREENS));
        AbstractDocument doc = (AbstractDocument)this.numberOfScreensText.getDocument();
        doc.setDocumentFilter(new SizedNumericFilter(2));
        this.numberOfScreensText.setHorizontalAlignment(2);
        this.numberOfScreensText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewScreenDialog.this.processScreenCount();
            }
        });
        this.numberOfScreensText.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_SCREENCOUNTRANGE, new Object[]{new Integer(99)}));
        this.dialogPanel.add((Component)this.creationLocation, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPanel.add((Component)this.screenSizePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.dialogPanel.add((Component)this.screenNamesPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        this.screenNamesPanel.add((Component)this.numberOfScreens, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.screenNamesPanel.add((Component)this.numberOfScreensText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.screenNameTable.createDefaultColumnsFromModel();
        this.screenNameTable.setModel(this.tableModel);
        this.screenNameTable.setIntercellSpacing(new Dimension(0, 1));
        this.screenNameTable.setShowHorizontalLines(false);
        this.screenNameTable.setShowVerticalLines(false);
        this.scrollPane = new JScrollPane(this.screenNameTable, 22, 31);
        this.scrollPane.getViewport().setBackground(this.screenNameTable.getBackground());
        this.scrollPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NewScreenDialog.this.screenNameTable.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                NewScreenDialog.this.screenNameTable.clearSelection();
            }
        });
        this.screenNameTable.setPreferredScrollableViewportSize(new Dimension(100, 150));
        this.screenNamesPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewScreenDialog.this.okProcessing();
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewScreenDialog.this.createScreens();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewScreenDialog.this.cancelDialog();
            }
        });
        this.screenNameTable.setAutoResizeMode(3);
        TableColumn col = this.screenNameTable.getColumnModel().getColumn(0);
        col.setMinWidth(50);
        col.setPreferredWidth(50);
        col.setMaxWidth(50);
        this.screenNameTable.getTableHeader().setReorderingAllowed(false);
        this.screenNameTable.getTableHeader().setResizingAllowed(false);
        this.setHaveChanges(true);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewScreenDialog.this.setHaveChanges(true);
            }
        };
        this.creationLocation.addActionListener(buttonListener);
        this.creationLocation.addActionListener(this.createLocationListener());
        this.addMouseListener(this.clickAdapter);
        this.numberOfScreensText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                NewScreenDialog.this.setHaveChanges(true);
            }
        });
        this.screenNameTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                NewScreenDialog.this.setHaveChanges(NewScreenDialog.this.screenNameTable.columnAtPoint(e.getPoint()) == 1);
            }
        });
        this.numberOfScreensText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                NewScreenDialog.this.numberOfScreensText.removeFocusListener(this);
                if (!NewScreenDialog.this.screenSizePanel.isSizeValid()) {
                    NewScreenDialog.this.numberOfScreensText.setEnabled(false);
                }
                NewScreenDialog.this.numberOfScreensText.addFocusListener(this);
            }

            @Override
            public void focusLost(FocusEvent e) {
                NewScreenDialog.this.numberOfScreensText.removeFocusListener(this);
                if (e.getOppositeComponent() != NewScreenDialog.this.cancelButton) {
                    NewScreenDialog.this.processScreenCount();
                }
                NewScreenDialog.this.numberOfScreensText.addFocusListener(this);
            }
        });
        this.setContent(this.dialogPanel);
        this.addActionButton(this.okButton, true);
        this.addCancelButton(this.cancelButton);
    }

    private ActionListener createLocationListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewScreenDialog.this.formatNames();
            }
        };
    }

    private void setHaveChanges(boolean changes) {
        this.haveChanges = changes;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                NewScreenDialog.this.applyButton.setEnabled(NewScreenDialog.this.haveChanges && NewScreenDialog.this.screenSizePanel.isSizeValid());
                NewScreenDialog.this.numberOfScreensText.setEnabled(NewScreenDialog.this.haveChanges && NewScreenDialog.this.screenSizePanel.isSizeValid());
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void okProcessing() {
        if (this.haveChanges || !this.validScreenCount) {
            if (!this.screenSizePanel.isSizeValid() || !this.validScreenCount) {
                int j = ModalDialog.showConfirmDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_CANNOTDOOK), (String)i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_CANNOTDOOKTITLE), (int)0, (int)0);
                if (j != 0) return;
                this.cancelDialog();
            } else if (!this.createScreens()) {
                return;
            }
        }
        this.exitDialog();
    }

    private void cancelDialog() {
        this.screenSizePanel.restoreSettings();
        this.creationLocation.restoreSettings();
        this.exitDialog();
    }

    @Override
    public void onScreenSizePanelChange() {
        this.setHaveChanges(true);
    }

    private void processScreenCount() {
        if (!this.screenSizePanel.isSizeValid()) {
            this.numberOfScreensText.setEnabled(false);
            return;
        }
        if (this.screenNameTable.isEditing()) {
            TableCellEditor cellEditor = this.screenNameTable.getCellEditor();
            cellEditor.stopCellEditing();
        }
        this.setHaveChanges(true);
        if (this.numberOfScreensText.getText().equals(this.lastScreenCountText)) {
            return;
        }
        this.validScreenCount = false;
        this.lastScreenCountText = this.numberOfScreensText.getText();
        try {
            this.screenCount = Integer.parseInt(this.numberOfScreensText.getText());
            if (this.screenCount <= 0) {
                this.numberOfScreensText.setText("1");
                this.screenCount = 1;
            } else if (this.screenCount > 99) {
                this.numberOfScreensText.setText(String.valueOf(99));
                this.screenCount = 99;
            }
            this.validScreenCount = true;
            this.createRows(this.screenCount);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.setHaveChanges(false);
            this.numberOfScreensText.setEnabled(true);
            return;
        }
    }

    private boolean createScreens() {
        String screenName = "";
        boolean success = true;
        this.lastScreenCountText = "";
        if (!this.screenSizePanel.isSizeValid() || !this.validScreenCount) {
            return false;
        }
        this.processScreenCount();
        LinkedList parents = ActionUtilities.determinePastedParents((ScreenModel[])this.screenParents, (WhiteboardContext)this.context, (int)this.creationLocation.getSelectedRelation());
        for (ScreenPasteEntry entry : parents) {
            ScreenModel parentScreen = entry.screen;
            try {
                for (int i = 0; i < this.screenCount; ++i) {
                    if (!parentScreen.canCreate()) continue;
                    Dimension screenSize = this.screenSizePanel.getSize(WhiteboardContext.DEFAULT_SIZE);
                    ActionUtilities.createScreen((ScreenName)this.screenNames[i], (WhiteboardContext)this.context, (Dimension)screenSize, (ScreenModel)parentScreen, (int)entry.index++, (boolean)false);
                }
            }
            catch (Exception ex) {
                ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_ADDERROR, new Object[]{screenName, ex.getMessage()}), (String)i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_ADDERRORTITLE), (int)0);
                success = false;
            }
        }
        if (success) {
            this.setHaveChanges(false);
        }
        return success;
    }

    void exitDialog() {
        this.defaultButtonSelection = this.creationLocation.getSelectedRelation();
        this.setVisible(false);
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible, new ScreenModel[]{this.context.getController().getScreen()});
    }

    public void setVisible(boolean visible, ScreenModel[] screenParents) {
        boolean canModify = false;
        this.screenCount = 1;
        this.lastScreenCountText = "";
        this.haveChanges = false;
        this.validScreenCount = true;
        if (visible) {
            this.screenParents = screenParents;
            this.numberOfScreensText.setText(Integer.toString(this.screenCount));
            this.createRows(this.screenCount);
            this.setHaveChanges(true);
            boolean enable = false;
            for (int i = 0; i < screenParents.length; ++i) {
                if (!(screenParents[i] instanceof ScreenRoot)) {
                    enable = true;
                }
                if (!screenParents[i].canCreate()) continue;
                canModify = true;
            }
            this.screenSizePanel.setEnabled(canModify);
            this.numberOfScreensText.setEnabled(canModify);
            this.screenNameTable.setEnabled(canModify);
            this.creationLocation.enableButtons(enable && canModify, 7);
            if (enable) {
                this.creationLocation.setButtonSelected(this.defaultButtonSelection);
            } else {
                this.creationLocation.setButtonSelected(ActionUtilities.SUBTOPIC);
            }
        } else {
            this.screenNames = new ScreenName[0];
        }
        this.screenSizePanel.saveSettings();
        this.creationLocation.saveSettings();
        super.setVisible(visible);
    }

    void createRows(int screenCount) {
        int oldLength = this.screenNames.length;
        if (screenCount == oldLength) {
            return;
        }
        int newIndex = 0;
        ScreenName[] names = new ScreenName[screenCount];
        for (newIndex = 0; newIndex < oldLength && newIndex < screenCount; ++newIndex) {
            names[newIndex] = this.screenNames[newIndex];
        }
        if (screenCount > oldLength) {
            while (newIndex < screenCount) {
                ScreenModel screenParent = null;
                boolean singleParent = true;
                for (int i = 0; i < this.screenParents.length; ++i) {
                    if (screenParent == null) {
                        screenParent = this.screenParents[i].getRoot();
                        continue;
                    }
                    if (screenParent == this.screenParents[i].getRoot()) continue;
                    singleParent = false;
                    break;
                }
                String screenName = singleParent ? ActionUtilities.nextScreenName((ScreenModel)this.screenParents[0], (WhiteboardContext)this.context) : ActionUtilities.nextScreenName(null, (WhiteboardContext)this.context);
                names[newIndex] = new ScreenName(this.context, screenName, true);
                ++newIndex;
            }
        }
        this.screenNames = names;
        this.formatNames();
        if (screenCount > oldLength) {
            this.tableModel.fireTableRowsInserted(oldLength, screenCount);
        } else {
            this.tableModel.fireTableRowsDeleted(screenCount, oldLength);
        }
    }

    private void formatNames() {
    }

    private int calcIndexOffset(ScreenModel parent) {
        if (parent == null) {
            return 1;
        }
        int relation = this.creationLocation.getSelectedRelation();
        switch (relation) {
            case 8: {
                return 1;
            }
            case 1: {
                return parent.getIndex() + 2;
            }
            case 4: {
                return Math.max(parent.getIndex(), 1);
            }
            case 2: {
                return parent.getParent().getChildCount() + 1;
            }
        }
        return 1;
    }

    class ScreenNameTableModel
    extends AbstractTableModel {
        ScreenNameTableModel() {
        }

        @Override
        public int getRowCount() {
            return NewScreenDialog.this.screenNames.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                switch (column) {
                    case 0: {
                        return new Integer(row + 1);
                    }
                    case 1: {
                        return NewScreenDialog.this.screenNames[row].getScreenName();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 1 && value instanceof String) {
                if (((String)value).length() <= 0) {
                    if (!NewScreenDialog.this.editLock) {
                        ModalDialog.showMessageDialog((Component)NewScreenDialog.this.dialogPanel, (Object)i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_EMPTYNAME), (String)i18n.getString((PropertiesEnum)StringsProperties.NEWSCREENDIALOG_EMPTYNAMETITLE), (int)0);
                        Thread.currentThread();
                        Thread.dumpStack();
                    }
                    return;
                }
                if (row >= 0 && row < NewScreenDialog.this.screenNames.length) {
                    if (NewScreenDialog.this.screenNames[row].getScreenName().equals(value.toString())) {
                        return;
                    }
                    NewScreenDialog.this.screenNames[row].setScreenName(value.toString());
                    NewScreenDialog.this.screenNames[row].setASystemGeneratedScreenName(false);
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NewScreenDialog.this.numberColumnHeaderText;
                }
                case 1: {
                    return NewScreenDialog.this.nameColumnHeaderText;
                }
            }
            return "unknown";
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }
    }
}

