/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.ButtonBehaviour;
import com.elluminate.groupware.whiteboard.WhiteboardChairListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenResolver;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ACLList;
import com.elluminate.groupware.whiteboard.module.navigation.NavigationEnabledClerk;
import com.elluminate.groupware.whiteboard.module.navigation.PostionOfCurrentScreenClerk;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.TopicElement;
import com.elluminate.groupware.whiteboard.module.ui.TopicElementListener;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.NullableActionButton;
import com.elluminate.gui.component.NullableTimedActionButton;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;

public class NavigatorPane
implements ScreenResolver,
WhiteboardChairListener {
    static I18n i18n = I18n.create((Object)new Object(){});
    private JPanel titlePanel = new JPanel();
    private PostionOfCurrentScreenClerk positionClerk;
    private NullableActionButton prevButton = null;
    private NullableActionButton nextButton = null;
    private NullableActionButton lastButton = null;
    private Insets insets = new Insets(0, 0, 0, 0);
    private WhiteboardContext context;
    private JPanel westPanel = new JPanel();
    private GridBagLayout westPanelLayout = new GridBagLayout();
    private NavComboBox titleCombo = new NavComboBox();
    private ScreenModel currentScreen = null;
    private ScreenModel previousScreen = null;
    private ScreenModel nextScreen = null;
    private ControllerPane controllerPane;
    private NavigationEnabledClerk enabledClerk;
    private Object deselectedItem = null;
    private boolean suppressStateChanged = false;

    public PostionOfCurrentScreenClerk getPositionClerk() {
        return this.positionClerk;
    }

    public NavigatorPane(WhiteboardContext context, ControllerPane controllerPane) {
        this.context = context;
        this.controllerPane = controllerPane;
        this.enabledClerk = new NavigationEnabledClerk(context);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"NavigatorPane", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.prevButton = new NullableTimedActionButton((Icon)i18n.getIcon("NavigatorPane.prevArrowIcon"));
        this.prevButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.NAVIGATORPANE_PREVTIP));
        this.nextButton = new NullableTimedActionButton((Icon)i18n.getIcon("NavigatorPane.nextArrowIcon"));
        this.nextButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.NAVIGATORPANE_NEXTTIP));
        this.lastButton = new NullableActionButton((Icon)i18n.getIcon("NavigatorPane.lastArrowIcon"));
        this.lastButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.NAVIGATORPANE_LASTTIP));
        this.positionClerk.setEnabled(true);
        this.titleCombo.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.NAVIGATORPANE_TITLETIP));
        this.prevButton.setMargin(new Insets(0, 0, 0, 0));
        this.prevButton.setOpaque(false);
        this.prevButton.setPreferredSize(new Dimension(28, 20));
        this.context.getButtonBehaviour().setButtonBehaviour((AbstractButton)this.prevButton, ButtonBehaviour.normalBorder, false);
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPane.this.prevButton_actionPerformed(e);
            }
        });
        this.nextButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextButton.setOpaque(false);
        this.nextButton.setPreferredSize(new Dimension(28, 20));
        this.context.getButtonBehaviour().setButtonBehaviour((AbstractButton)this.nextButton, ButtonBehaviour.normalBorder, false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPane.this.nextButton_actionPerformed(e);
            }
        });
        this.lastButton.setMargin(new Insets(0, 0, 0, 0));
        this.lastButton.setOpaque(false);
        this.lastButton.setPreferredSize(new Dimension(28, 20));
        this.context.getButtonBehaviour().setButtonBehaviour((AbstractButton)this.lastButton, ButtonBehaviour.normalBorder, false);
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPane.this.lastButton_actionPerformed(e);
            }
        });
        this.titlePanel.setLayout(new GridBagLayout());
        this.westPanel.setLayout(this.westPanelLayout);
        this.westPanel.setAlignmentY(0.0f);
        this.titlePanel.setAlignmentX(0.0f);
        this.titlePanel.setAlignmentY(0.0f);
        this.westPanel.setAlignmentX(0.0f);
        this.westPanel.add((Component)this.prevButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0));
        this.westPanel.add((Component)this.nextButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0));
        this.westPanel.add((Component)this.lastButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, this.insets, 0, 0));
    }

    public ScreenModel getScreen() {
        return this.currentScreen;
    }

    public void setCurrentScreen(ScreenModel screen) {
        this.currentScreen = screen;
        this.setTitlePath(screen);
        this.evaluateNavigator();
    }

    private void evaluateNavigator() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.evalNavigatorLocal();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    NavigatorPane.this.evalNavigatorLocal();
                }
            });
        }
    }

    private void evalNavigatorLocal() {
        this.titleCombo.setEnabled(this.enabledClerk.isNavArrowsEnabled());
    }

    public void setEnabled(boolean enabled) {
        this.enabledClerk.setEnabled(enabled);
    }

    public void enablePositionOfText(boolean visiblePositionOfText) {
        this.positionClerk.setEnabled(visiblePositionOfText);
    }

    public void enableNavigation(boolean navEnabled) {
        this.enabledClerk.enableNavigation(navEnabled);
    }

    public NavigationEnabledClerk getEnabledClerk() {
        return this.enabledClerk;
    }

    public void evaluateVisible(ACLList aclList) {
        if (aclList instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)aclList;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.titleCombo.getModel();
            if (model.getIndexOf(screen) >= 0) {
                if (!screen.isVisible()) {
                    this.setTitlePath(this.currentScreen);
                }
            } else if (screen.isVisible()) {
                this.setTitlePath(this.currentScreen);
            }
        }
    }

    public void setWhiteboardAccessible(boolean whiteboardAccessible) {
        this.enabledClerk.setWhiteboardAcessible(whiteboardAccessible);
    }

    public void keyEvent(final KeyEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.keyEventLocal(event);
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    NavigatorPane.this.keyEventLocal(event);
                }
            });
        }
    }

    private void keyEventLocal(KeyEvent event) {
        this.evaluateNavigator();
        if (this.context.getController().canNavigate()) {
            switch (event.getKeyCode()) {
                case 33: {
                    if (!this.prevButton.isEnabled()) break;
                    this.prevButton_actionPerformed(null);
                    break;
                }
                case 34: {
                    if (!this.nextButton.isEnabled()) break;
                    this.nextButton_actionPerformed(null);
                    break;
                }
                case 35: {
                    if (!this.lastButton.isEnabled()) break;
                    this.lastButton_actionPerformed(null);
                }
            }
        }
    }

    private void getFocus() {
        if (!this.controllerPane.hasFocus()) {
            this.controllerPane.requestFocus();
        }
    }

    public void nodeAdded(WBNode addedNode, WBNode parentNode) {
        if (!addedNode.isConferenceNode()) {
            return;
        }
        if (addedNode instanceof ScreenModel) {
            if (this.titleCombo.isPopupVisible()) {
                this.setTitlePath(this.currentScreen);
            }
            this.processDeferredGoTo();
        }
        this.evaluateNavigator();
    }

    private void processDeferredGoTo() {
        Long pendingGoToNodeID = this.context.getController().getPendingScreenUID();
        if (pendingGoToNodeID != null) {
            try {
                RegisteredTemplate template = (RegisteredTemplate)this.context.getObjectManager().getObjectFromMap(pendingGoToNodeID);
                if (template instanceof ScreenModel) {
                    this.controllerPane.onGotoScreen(((ScreenModel)template).getObjectID());
                    this.setTitlePath(this.currentScreen);
                    this.evaluateNavigator();
                }
            }
            catch (Exception exception) {}
        } else if (this.currentScreen instanceof ScreenRoot && this.currentScreen.getScreenDelegate() instanceof ScreenModel) {
            this.controllerPane.onGotoScreen(this.currentScreen.getScreenDelegate().getObjectID());
            this.setTitlePath(this.currentScreen);
            this.evaluateNavigator();
        }
    }

    public void nodeRemoved(WBNode removedNode, int removedIndex, WBNode parentNode) {
        ScreenModel gotoTarget = null;
        Long pending = null;
        if (!(removedNode instanceof ScreenModel)) {
            return;
        }
        if (this.titleCombo.isPopupVisible()) {
            this.setTitlePath(this.currentScreen);
        }
        if (!ActionUtilities.isUIDInScreen((Long)this.currentScreen.getObjectID(), (WBNode)removedNode)) {
            this.evaluateNavigator();
            return;
        }
        if (parentNode.getRoot() != null && parentNode.getParent() != null || parentNode instanceof ScreenGroups) {
            pending = this.controllerPane.getPendingScreenUID();
            gotoTarget = ActionUtilities.getGotoTarget((WBNode[])new WBNode[]{removedNode}, (int)removedIndex, (WBNode)parentNode, (Long)this.currentScreen.getObjectID());
            if (gotoTarget != this.currentScreen && (parentNode.getRoot() != null && parentNode.getParent() != null || parentNode instanceof ScreenGroups) && gotoTarget != null) {
                boolean roaming = this.controllerPane.isExplorerSelected();
                this.controllerPane.setExplorer(false);
                this.controllerPane.gotoConferenceScreen(gotoTarget.getObjectID());
                this.setTitlePath(this.currentScreen);
                if (roaming) {
                    this.controllerPane.setExplorer(true);
                }
            }
            if (pending != null) {
                this.controllerPane.setPendingScreenUID(pending);
            }
        }
        this.evaluateNavigator();
    }

    public void treeNodesChanged(TreeModelEvent e) {
        this.processDeferredGoTo();
    }

    public void evaluateScreenChange() {
        if (this.currentScreen instanceof ScreenRoot) {
            this.controllerPane.onGotoScreen(this.currentScreen.getObjectID());
        } else {
            this.evaluateNavigator();
        }
    }

    public void onWhiteboardChairChange(Short clientId, Short jinxAddress, boolean add) {
        if (this.context.getIDProcessor().isLocalClient(clientId)) {
            if (!this.context.getController().getScreen().isVisible()) {
                this.context.gotoScreen(this.context.getGroupManager().getGroupInfo().getScreenUID(), true);
            }
            if (this.titleCombo.isPopupVisible()) {
                this.setTitlePath(this.currentScreen);
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
        if (this.currentScreen instanceof ScreenRoot) {
            this.controllerPane.onGotoScreen(this.currentScreen.getObjectID());
        } else {
            this.evaluateNavigator();
        }
    }

    private ScreenModel getPrevScreen() {
        WBNode result = null;
        WBNode boardParent = this.currentScreen.getBoardParent();
        if (boardParent != null) {
            int index = this.currentScreen.getIndex();
            for (int leftIndex = index - 1; leftIndex >= 0; --leftIndex) {
                result = boardParent.getChildAt(leftIndex);
                if (!(result instanceof ScreenModel)) continue;
                return (ScreenModel)result;
            }
        }
        return null;
    }

    private ScreenModel getNextScreen() {
        WBNode result = null;
        WBNode boardParent = this.currentScreen.getBoardParent();
        if (boardParent != null) {
            int index = this.currentScreen.getIndex();
            for (int rightIndex = index + 1; rightIndex < boardParent.getChildCount(); ++rightIndex) {
                result = boardParent.getChildAt(rightIndex);
                if (!(result instanceof ScreenModel)) continue;
                return (ScreenModel)result;
            }
        }
        return null;
    }

    void firstButton_actionPerformed(ActionEvent e) {
        Long firstUID = null;
        Long chosenUID = null;
        if (this.currentScreen instanceof ScreenRoot) {
            return;
        }
        ScreenModel parent = (ScreenModel)this.currentScreen.getParent();
        if (parent != null) {
            Iterator iter = parent.iterateScreens();
            while (iter.hasNext()) {
                WBNode node = (WBNode)iter.next();
                if (firstUID == null) {
                    firstUID = node.getObjectID();
                }
                if (!(node instanceof ScreenModel)) continue;
                chosenUID = node.getObjectID();
                break;
            }
        }
        this.context.getController().gotoUIScreen(chosenUID, false);
        if (!firstUID.equals(chosenUID)) {
            this.context.getController().gotoUIScreen(firstUID, false);
        }
        this.controllerPane.requestFocus();
    }

    void prevButton_actionPerformed(ActionEvent e) {
        ScreenModel screen = this.previousScreen;
        if (screen instanceof ScreenModel) {
            this.context.getController().gotoUIScreen(screen.getObjectID(), false);
            return;
        }
        this.evaluateNavigator();
    }

    void nextButton_actionPerformed(ActionEvent e) {
        ScreenModel screen = this.nextScreen;
        if (screen instanceof ScreenModel) {
            this.context.getController().gotoUIScreen(screen.getObjectID(), false);
            return;
        }
        this.evaluateNavigator();
    }

    void lastButton_actionPerformed(ActionEvent e) {
        Long lastUID = null;
        Long chosenUID = null;
        ScreenModel parent = (ScreenModel)this.currentScreen.getParent();
        if (parent != null) {
            Iterator iter = parent.iterateScreens();
            while (iter.hasNext()) {
                WBNode node = (WBNode)iter.next();
                lastUID = node.getObjectID();
                if (!(node instanceof ScreenModel)) continue;
                chosenUID = node.getObjectID();
            }
        }
        this.context.getController().gotoUIScreen(lastUID, false);
        this.controllerPane.requestFocus();
    }

    public void setTitlePath(ScreenModel screen) {
        if (SwingUtilities.isEventDispatchThread()) {
            new SetNavTitle(screen).run();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new SetNavTitle(screen));
        }
    }

    private void addComboScreen(ScreenModel screen, LinkedList screenList) {
        screenList.add(screen);
        Iterator iter = screen.iterateScreens();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof ScreenModel)) continue;
            this.addComboScreen((ScreenModel)object, screenList);
        }
    }

    public boolean isNavigable() {
        return this.enabledClerk.isNavArrowsEnabled();
    }

    public ACLTerm getACLTerm(String name) {
        return null;
    }

    private class GoToScreenAction
    implements ActionListener {
        private ScreenModel model;

        public GoToScreenAction(ScreenModel model) {
            this.model = model;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorPane.this.context.getController().gotoUIScreen(this.model.getObjectID(), false);
        }
    }

    public class NavComboBox
    extends JComboBox {
        @Override
        public void addPopupMenuListener(PopupMenuListener l) {
            this.listenerList.add(PopupMenuListener.class, l);
        }

        @Override
        public void removePopupMenuListener(PopupMenuListener l) {
            this.listenerList.remove(PopupMenuListener.class, l);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            GuiUtils.removeKeyBinding((KeyStroke)KeyStroke.getKeyStroke(33, 0), (JComponent)this);
            GuiUtils.removeKeyBinding((KeyStroke)KeyStroke.getKeyStroke(34, 0), (JComponent)this);
        }
    }

    class SetNavTitle
    implements Runnable {
        ScreenModel screen;

        public SetNavTitle(ScreenModel screen) {
            this.screen = screen;
        }

        @Override
        public void run() {
            boolean popupVisible = NavigatorPane.this.titleCombo.isPopupVisible();
            LinkedList screens = new LinkedList();
            Iterator iter = NavigatorPane.this.context.getDataModel().getRoot().iterateScreens();
            while (iter.hasNext()) {
                screens.add(iter.next());
            }
            Collections.sort(screens);
            LinkedList newItems = new LinkedList();
            for (Object object : screens) {
                if (!(object instanceof ScreenModel) || !((ScreenModel)object).isVisible()) continue;
                NavigatorPane.this.addComboScreen((ScreenModel)object, newItems);
            }
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(newItems.toArray());
            NavigatorPane.this.titleCombo.setModel(model);
            if (Platform.getPlatform() != 2) {
                NavigatorPane.this.titleCombo.setPopupVisible(popupVisible);
            }
            if (this.screen != null && this.screen.getObjectID() != null) {
                NavigatorPane.this.titleCombo.setSelectedItem(this.screen);
            }
            NavigatorPane.this.titleCombo.repaint();
        }
    }

    class setTitle
    implements Runnable {
        ScreenModel screen;
        TopicElementListener listener;

        public setTitle(ScreenModel screen, TopicElementListener listener) {
            this.screen = screen;
            this.listener = listener;
        }

        @Override
        public void run() {
            TopicElement selector;
            GridBagConstraints constraint;
            Icon icon = null;
            ArrayList<ScreenModel> nodes = new ArrayList<ScreenModel>();
            if (this.screen == null) {
                return;
            }
            ScreenModel node = this.screen;
            while (node.getParent() != null) {
                nodes.add(node);
                node = node.getParent();
            }
            NavigatorPane.this.titlePanel.removeAll();
            JPanel leadPanel = new JPanel(new GridBagLayout());
            leadPanel.setOpaque(false);
            JPanel currentPanel = new JPanel(new GridBagLayout());
            leadPanel.setAlignmentX(0.0f);
            leadPanel.setAlignmentY(0.0f);
            currentPanel.setAlignmentX(0.0f);
            currentPanel.setAlignmentY(0.0f);
            currentPanel.setOpaque(false);
            NavigatorPane.this.titlePanel.add((Component)leadPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 17, 0, NavigatorPane.this.insets, 0, 0));
            NavigatorPane.this.titlePanel.add((Component)currentPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, NavigatorPane.this.insets, 0, 0));
            for (int i = nodes.size() - 1; i > 0; --i) {
                this.screen = node = (WBNode)nodes.get(i);
                constraint = new GridBagConstraints(nodes.size() - i - 1, 0, 1, 1, 1.0, 1.0, 17, 0, NavigatorPane.this.insets, 0, 0);
                selector = new TopicElement(node.getDisplayName(), icon, true, this.screen, false, constraint, this.listener);
                leadPanel.add((Component)selector, constraint);
            }
            if (nodes.size() > 0) {
                this.screen = (ScreenModel)nodes.get(0);
                constraint = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, NavigatorPane.this.insets, 0, 0);
                selector = new TopicElement(this.screen.getDisplayName(), icon, false, this.screen, true, constraint, this.listener);
                currentPanel.add((Component)selector, constraint);
            }
            NavigatorPane.this.titlePanel.validate();
            NavigatorPane.this.titlePanel.repaint();
        }
    }
}

