/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavigator;
import com.elluminate.groupware.whiteboard.module.ui.DisplayUtilities;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.groupware.whiteboard.module.ui.MainNavDndTree;
import com.elluminate.groupware.whiteboard.module.ui.MainNavMouseAdapter;
import com.elluminate.groupware.whiteboard.module.ui.MainNavScreenCellRenderer;
import com.elluminate.groupware.whiteboard.module.ui.ScreenCellEditor;
import com.elluminate.groupware.whiteboard.module.ui.ScreenCellRenderer;
import com.elluminate.groupware.whiteboard.module.ui.menu.NavCopyAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.NavCutAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.NavEmptyScreenClipboardAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.NavPasteMenu;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainTreeNavigator
extends AbstractNavigator
implements TreeModelListener {
    MainNavMouseAdapter mouseAdapter = null;
    ScreenCellRenderer screenCellRenderer = null;

    public MainTreeNavigator(WhiteboardContext context) {
        super(context);
        if (context.getDataModel().getDisplayModel() == null) {
            context.getDataModel().setDisplayModel(DisplayUtilities.createScreenTreeModel(context.getDataModel().getRoot(), context));
        }
        this.setModel(context.getDataModel().getDisplayModel());
        context.getDataModel().getDisplayModel().addViewer((JTree)((Object)this.navigatorTree));
        this.navigatorTree.setEditable(true);
        this.navigatorTree.setRootVisible(false);
        this.navigatorTree.setShowsRootHandles(true);
        this.navigatorTree.setRowHeight(0);
        this.navigatorTree.setOpaque(false);
        this.navigatorScroller.getViewport().setBackground(MainNavDndTree.DefaultBackgroundColor);
        this.screenCellRenderer = new MainNavScreenCellRenderer(context);
        this.navigatorTree.setCellRenderer(this.screenCellRenderer);
        ScreenCellEditor editor = new ScreenCellEditor((JTree)((Object)this.navigatorTree), (DefaultTreeCellRenderer)this.screenCellRenderer, context);
        this.navigatorTree.setCellEditor(editor);
        this.mouseAdapter = new MainNavMouseAdapter(context, this);
        this.setMotionAdapter(this.mouseAdapter);
        this.navigatorTree.addKeyListener(this);
        ActionMap actionMap = this.navigatorTree.getActionMap();
        actionMap.put("selectAll", new SelectAllAction());
        ((WhiteboardBean)context.getBean()).addShowThumbnailsListener(new WhiteboardBean.ShowThumbnailsListener(){

            @Override
            public void showThumbnailsChanged(WhiteboardBean.ShowThumbnailsEvent e) {
                MainTreeNavigator.this.navigatorTree.setRowHeight(0);
                MainTreeNavigator.this.navigatorTree.setShowThumbnails(e.isShowingThumbnails());
            }
        });
    }

    public void setScreen(ScreenModel screen) {
        SetScreenRunnable run = new SetScreenRunnable(screen, this);
        SwingRunnerSupport.invokeLater((Runnable)run);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        MainTreeNavigator.processAcceleratorKey(e, this.navigatorTree, this.context);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        MainTreeNavigator.processAcceleratorKey(e, this.navigatorTree, this.context);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        MainTreeNavigator.processAcceleratorKey(e, this.navigatorTree, this.context);
    }

    @Override
    void frameClosing(WindowEvent e) {
        this.canClose();
    }

    boolean canClose() {
        JDialog dlog = (JDialog)this.getClientProperty("com.bb.collaborate.navigatorDialog");
        if (dlog != null) {
            dlog.setVisible(false);
        }
        return false;
    }

    @Override
    protected DndTree newDndTreeInstance(WhiteboardContext context) {
        return new MainNavDndTree(context);
    }

    public static void processAcceleratorKey(KeyEvent event, DndTree navigatorTree, WhiteboardContext context) {
        int accelMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean controlDown = (accelMask & event.getModifiers()) != 0;
        int otherMods = event.getModifiers() & ~accelMask;
        if (event.getID() == 402) {
            TreePath[] paths = navigatorTree.getSelectionPaths();
            if (event.getModifiers() == 0) {
                if ((event.getKeyCode() == 127 || event.getKeyCode() == 8) && paths != null && paths.length > 0) {
                    DisplayUtilities.deleteScreens(paths, context);
                }
            } else if (controlDown) {
                if (otherMods == 1) {
                    switch (event.getKeyCode()) {
                        case 84: {
                            context.getController().postNavigator(true);
                        }
                    }
                } else if (otherMods == 0) {
                    switch (event.getKeyCode()) {
                        case 88: {
                            NavCutAction.cutScreens(paths, context, false);
                            break;
                        }
                        case 67: {
                            NavCopyAction.copyScreens(paths, context);
                            break;
                        }
                        case 86: {
                            NavPasteMenu.pasteScreens(paths, context, 1);
                            break;
                        }
                        case 84: {
                            NavPasteMenu.pasteScreens(paths, context, ActionUtilities.SUBTOPIC);
                            break;
                        }
                        case 69: {
                            NavEmptyScreenClipboardAction.emptyScreenClipboard(context);
                            break;
                        }
                        case 65: {
                            DisplayUtilities.selectPeerScreens(paths, context, (JTree)((Object)navigatorTree));
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.processNodeChange();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.processNodeChange();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.processNodeChange();
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class SetScreenRunnable
    implements Runnable {
        Component comp;
        ScreenModel screen;

        public SetScreenRunnable(ScreenModel screen, Component comp) {
            this.screen = screen;
            this.comp = comp;
        }

        @Override
        public void run() {
            if (!(this.screen == null || MainTreeNavigator.this.context == null && this.comp.isVisible() || this.screen.getDisplayPeer() == null)) {
                TreePath path = new TreePath(MainTreeNavigator.this.context.getDataModel().getDisplayModel().getPathToRoot((TreeNode)this.screen.getDisplayPeer()));
                MainTreeNavigator.this.navigatorTree.expandPath(path);
                if (MainTreeNavigator.this.navigatorTree instanceof MainNavDndTree) {
                    MainNavDndTree mainNavDndTree = (MainNavDndTree)MainTreeNavigator.this.navigatorTree;
                    mainNavDndTree.setCurrentScreenPath(path);
                } else {
                    MainTreeNavigator.this.navigatorTree.setSelectionPath(path);
                }
                MainTreeNavigator.this.navigatorTree.scrollPathToVisible(path);
            }
        }
    }
}

