/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.MainNavDndTree;
import com.elluminate.groupware.whiteboard.module.ui.ScreenCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;

public class MainNavScreenCellRenderer
extends ScreenCellRenderer {
    private Color currBackgroundColor = null;

    public MainNavScreenCellRenderer(WhiteboardContext context) {
        super(context);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        hasFocus = false;
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        boolean hovered = false;
        boolean isTopLevel = false;
        boolean isCurrScreen = false;
        if (row >= 0) {
            MainNavDndTree dndTree = (MainNavDndTree)((Object)tree);
            isTopLevel = dndTree.isTopLevelPath(tree.getPathForRow(row));
            hovered = dndTree.getHoveredRow() == row;
            DisplayNode dNode = (DisplayNode)value;
            ScreenModel screen = (ScreenModel)dNode.whiteboardPeer();
            this.icon = isTopLevel || screen == null ? null : screen.getIcon();
            boolean bl = isCurrScreen = dndTree.getCurrentScreenRow() == row;
        }
        this.currBackgroundColor = selected ? UIManager.getColor("Tree.selectionBackground") : (isCurrScreen ? MainNavDndTree.CurrentScreenRowBackgroundColor : (hovered ? MainNavDndTree.HoveredRowBackgroundColor : MainNavDndTree.DefaultBackgroundColor));
        return label;
    }

    @Override
    public Color getBackgroundNonSelectionColor() {
        return this.currBackgroundColor;
    }

    @Override
    public Color getBackgroundSelectionColor() {
        return this.currBackgroundColor;
    }

    @Override
    public Color getTextSelectionColor() {
        return Color.WHITE;
    }
}

