/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavMouseAdapter;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavigator;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.groupware.whiteboard.module.ui.MainNavDndTree;
import com.elluminate.groupware.whiteboard.module.ui.MainNavPopup;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class MainNavMouseAdapter
extends AbstractNavMouseAdapter {
    TreePath selPath = null;
    boolean enabled = true;
    MainNavPopup popup = null;

    public MainNavMouseAdapter(WhiteboardContext context, AbstractNavigator navigator) {
        super(context, navigator);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handlePopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handlePopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        MainNavDndTree navTree = (MainNavDndTree)((Object)e.getSource());
        int selRow = navTree.getRowForYPos(e.getY());
        this.selPath = navTree.getPathForRow(selRow);
        if (selRow != -1) {
            if (e.getClickCount() == 2 && !navTree.isTopLevelPath(this.selPath)) {
                this.selectScreen(this.selPath);
            }
        } else if (!e.isConsumed()) {
            navTree.clearSelection();
        }
        navTree.requestFocus();
        this.handlePopup(e);
    }

    private void handlePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int eventRow;
            MainNavDndTree navTree;
            if (this.context.getController().isRightButton(false, e)) {
                this.context.getController().consumeRightButton();
            }
            if (!(navTree = (MainNavDndTree)((Object)e.getSource())).isRowSelected(eventRow = navTree.getRowForYPos(e.getY()))) {
                navTree.setSelectionRow(eventRow);
            }
            this.managePopup(e);
            e.consume();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.popup != null && !enabled) {
            this.popup.setVisible(false);
            this.popup = null;
        }
    }

    private void managePopup(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        DndTree navTree = (DndTree)((Object)e.getSource());
        TreePath[] paths = navTree.getSelectionPaths();
        this.popup = new MainNavPopup(navTree, this.context, "Navigation", paths);
        this.popup.show((Component)((Object)navTree), e.getX(), e.getY());
        this.navigator.registerPopup((JPopupMenu)((Object)this.popup));
    }

    public void selectScreen(TreePath path) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof DisplayNode) {
            DisplayNode node = (DisplayNode)obj;
            this.context.getController().gotoUIScreen(((ScreenModel)node.whiteboardPeer()).getObjectID(), false);
        }
    }

    public void enableItems() {
        if (this.popup != null) {
            this.popup.setPaths();
        }
    }
}

