/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavMouseAdapter;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavigator;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.groupware.whiteboard.module.ui.JDOMNavPopup;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class JDOMNavMouseAdapter
extends AbstractNavMouseAdapter {
    public JDOMNavMouseAdapter(WhiteboardContext context, AbstractNavigator navigator) {
        super(context, navigator);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handlePopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        DndTree navTree = (DndTree)((Object)e.getSource());
        int selRow = navTree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = navTree.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            if (e.getClickCount() != 1 && e.getClickCount() == 2) {
                this.selectScreen(selRow, selPath);
            }
        } else {
            navTree.clearSelection();
        }
        this.handlePopup(e);
    }

    private void handlePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.context.getController().isRightButton(false, e)) {
                this.context.getController().consumeRightButton();
            }
            this.managePopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void managePopup(MouseEvent e) {
        DndTree navTree = (DndTree)((Object)e.getSource());
        TreePath[] paths = navTree.getSelectionPaths();
        JDOMNavPopup popup = new JDOMNavPopup(navTree, this.context, "Explore", paths);
        popup.show((Component)((Object)navTree), e.getX(), e.getY());
        this.navigator.registerPopup((JPopupMenu)((Object)popup));
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        DndTree navTree = (DndTree)((Object)e.getSource());
        int selRow = navTree.getRowForLocation(e.getX(), e.getY());
        if (selRow < 0) {
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void selectScreen(int selRow, TreePath path) {
    }
}

