/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.EllipseToolModel;
import com.elluminate.groupware.whiteboard.tools.EllipseUIInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;

public class EllipseUI
extends AbstractUI
implements EllipseUIInterface {
    public void draw(Graphics g, AbstractToolModel tool) {
        Ellipse2D ellipse = (Ellipse2D)tool.getUIData();
        if (ellipse == null) {
            ellipse = new Ellipse2D.Double();
            tool.setUIData((Object)ellipse);
        }
        EllipseToolModel ellipseTool = (EllipseToolModel)tool;
        if (tool.isUIInvalid()) {
            Rectangle rect = tool.getBounds();
            int x = rect.width < 0 ? rect.x + rect.width : rect.x;
            int y = rect.height < 0 ? rect.y + rect.height : rect.y;
            int w = rect.width < 0 ? -rect.width : rect.width;
            int h = rect.height < 0 ? -rect.height : rect.height;
            ellipse.setFrame(x, y, w, h);
            tool.setUIInvalid(false);
        }
        Graphics2D g2 = (Graphics2D)g;
        ToolColor fillColor = ellipseTool.getFillColor() != null ? ellipseTool.getFillColor() : ellipseTool.getColor();
        try {
            if (fillColor != null && fillColor.getAlpha() > 0) {
                g2.setColor((Color)fillColor.getColor());
                g2.fill(ellipse);
            }
            g2.setColor((Color)tool.getColor().getColor());
            g2.setStroke((BasicStroke)tool.getStroke().getStroke());
            g2.draw(ellipse);
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }
}

