/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.flavors.InternalNodeListFlavor;
import com.elluminate.groupware.whiteboard.module.ui.DnDragGestureListener;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.groupware.whiteboard.module.ui.MainNavDndTree;
import com.elluminate.groupware.whiteboard.module.ui.TransferableTreePath;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DnDropTargetListener
implements DropTargetListener {
    private static final Point OUT_OF_COMPONENT = new Point(-1, -1);
    private Rectangle2D cueLineRectBelow = new Rectangle2D.Float();
    private Rectangle2D cueLineRectAbove = new Rectangle2D.Float();
    private Rectangle2D cueRectangle = null;
    private Color cueLineColor;
    private DnDragGestureListener dragListener;
    private boolean dropBetween = false;
    private Timer hoverTimer;
    private int iconHeight = 0;
    private int insertIndex = -1;
    private WBNode insertToNode = null;
    private Point lastMousePoint = new Point();
    private long lastScrollTime = 0L;
    private TreePath lastTreePath = null;
    private DndTree tree = null;
    private Point dragListenerLocation = null;
    private WhiteboardContext context;

    public DnDropTargetListener(WhiteboardContext context, final DndTree tree, DnDragGestureListener dragListener) {
        this.context = context;
        this.tree = tree;
        this.dragListener = dragListener;
        this.cueLineColor = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
        this.hoverTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DnDropTargetListener.this.isRootPath(DnDropTargetListener.this.lastTreePath)) {
                    return;
                }
                if (!tree.isExpanded(DnDropTargetListener.this.lastTreePath)) {
                    tree.expandPath(DnDropTargetListener.this.lastTreePath);
                }
            }
        });
        this.hoverTimer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addElements(TreePath parentPath, WBNode parent, long[] uids, int index, int dropType) {
        boolean addTo = index < 0;
        boolean copy = (dropType & 1) != 0;
        boolean move = (dropType & 2) != 0;
        try {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                this.context.getDataExporter().blockCodecs();
                for (int i = 0; i < uids.length; ++i) {
                    AbstractToolModel tool;
                    Long uid = new Long(uids[i]);
                    WBNode node = (WBNode)this.context.getObjectManager().getObjectFromMap(uid);
                    if (node == null || node.isDeleted()) continue;
                    if (copy && !move) {
                        node = (WBNode)node.clone();
                    }
                    if (parent == node) {
                        throw new RuntimeException("Adding parent to itself");
                    }
                    if (node instanceof AbstractToolModel) {
                        tool = (AbstractToolModel)node;
                        if (tool.getParent() != null && tool.getParent() == parent.getParent() && tool.getZOrder() < index) {
                            tool.setZOrder(index - 1);
                        } else {
                            tool.setZOrder(index);
                        }
                    } else {
                        tool = null;
                    }
                    node.setOriginator();
                    if (addTo) {
                        parent.add(node);
                    } else {
                        parent.insert(node, index);
                    }
                    this.tree.expandPath(parentPath);
                    ++index;
                }
            }
        }
        catch (Exception ex) {
        }
        finally {
            this.context.getDataExporter().unblockCodecs();
        }
        this.tree.repaint();
        return true;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragListenerLocation = dtde.getLocation();
        this.cueRectangle = null;
        this.dragListener.repaintDraggedImage((JTree)((Object)this.tree));
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.dragListenerLocation = null;
        this.cueRectangle = null;
        this.dragListener.repaintDraggedImage((JTree)((Object)this.tree));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        DropTarget tgt;
        boolean hasScreens = false;
        boolean hasTools = false;
        if (dtde.getLocation().equals(this.lastMousePoint)) {
            return;
        }
        this.lastMousePoint = dtde.getLocation();
        this.repaintCueZone();
        if (dtde.getSource() instanceof DropTarget && (tgt = (DropTarget)dtde.getSource()).getComponent() instanceof DndTree) {
            Object obj;
            this.tree = (DndTree)((Object)tgt.getComponent());
            Point dropPoint = dtde.getLocation();
            TreePath closestDropPath = this.tree.getClosestPathForLocation(dropPoint.x, dropPoint.y);
            if (closestDropPath != null && System.currentTimeMillis() > this.lastScrollTime + 100L) {
                Rectangle closestRect = this.tree.getPathBounds(closestDropPath);
                closestRect.y -= 12;
                closestRect.height += 24;
                this.tree.scrollRectToVisible(closestRect);
                this.lastScrollTime = System.currentTimeMillis();
            }
            if (closestDropPath != this.lastTreePath) {
                this.lastTreePath = closestDropPath;
                this.hoverTimer.restart();
            }
            boolean acceptDrop = false;
            int dropType = dtde.getDropAction();
            boolean copy = (dropType & 1) != 0;
            boolean move = (dropType & 2) != 0;
            WBNode nodeToDropTo = null;
            Object lastComponent = closestDropPath.getLastPathComponent();
            if (lastComponent != null && lastComponent instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)lastComponent).getUserObject()) instanceof WBNode) {
                nodeToDropTo = (WBNode)obj;
                acceptDrop = true;
            }
            if (acceptDrop) {
                acceptDrop = this.validParenting(dtde.getLocation(), dtde.getTransferable(), (JTree)((Object)this.tree), nodeToDropTo, copy & !move);
            }
            Rectangle raPath = this.tree.getPathBounds(closestDropPath);
            JLabel lbl = (JLabel)this.tree.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)this.tree), lastComponent, false, this.tree.isExpanded(closestDropPath), this.tree.getModel().isLeaf(lastComponent), this.tree.getClosestRowForLocation(dropPoint.x, dropPoint.y), false);
            lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
            Icon icon = lbl.getIcon();
            this.insertToNode = null;
            this.iconHeight = icon != null ? icon.getIconHeight() : 10;
            Rectangle pathRect = this.tree.getPathBounds(closestDropPath);
            int cueHeight = pathRect.height - this.iconHeight;
            int yOffset = this.iconHeight + cueHeight / 2;
            this.cueLineRectBelow.setRect(0.0, pathRect.y, this.tree.getWidth(), cueHeight);
            this.cueLineRectAbove.setRect(0.0, pathRect.y + yOffset - cueHeight / 2, this.tree.getWidth(), cueHeight);
            if (acceptDrop) {
                try {
                    Transferable tr = dtde.getTransferable();
                    if (tr.isDataFlavorSupported(TransferableTreePath.NODELIST_FLAVOR)) {
                        dtde.acceptDrag(3);
                        long[] encodedData = (long[])tr.getTransferData(TransferableTreePath.NODELIST_FLAVOR);
                        if (encodedData[1] != this.context.getConferenceUID()) {
                            acceptDrop = false;
                        } else if (this.context.getConferenceUID() == 0L && encodedData[2] != (long)this.context.hashCode()) {
                            acceptDrop = false;
                        }
                        long[] newUids = InternalNodeListFlavor.translateUids((long[])encodedData, (WhiteboardContext)this.context);
                        for (int i = 0; i < newUids.length; ++i) {
                            ScreenModel sm;
                            Object object = this.context.getObjectManager().getObjectFromMap(new Long(newUids[i]));
                            if (object == nodeToDropTo && !copy) {
                                acceptDrop = false;
                            }
                            hasTools |= object instanceof AbstractToolModel;
                            hasScreens |= object instanceof ScreenModel;
                            if (!(object instanceof ScreenModel) || this.context.isAccessible(sm = (ScreenModel)object) && (sm.canDelete() || copy) && (!(nodeToDropTo instanceof ScreenModel) || ((ScreenModel)nodeToDropTo).getRoot().canCreate())) continue;
                            acceptDrop = false;
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.insertIndex = -1;
            boolean bl = this.dropBetween = this.cueLineRectBelow.contains(dropPoint) || this.cueLineRectAbove.contains(dropPoint);
            if (this.dropBetween && nodeToDropTo instanceof ScreenModel && hasTools) {
                acceptDrop = false;
            } else if (this.dropBetween && nodeToDropTo instanceof AbstractToolModel && hasScreens) {
                acceptDrop = false;
            } else if (nodeToDropTo != null && nodeToDropTo.getDisplayPeer() == lastComponent && this.dropBetween) {
                this.insertToNode = nodeToDropTo;
                this.insertIndex = this.insertToNode.getIndex();
                if (this.cueLineRectAbove.contains(dropPoint) && this.insertToNode.getParentUID() != null) {
                    ++this.insertIndex;
                }
            }
            if (nodeToDropTo instanceof ScreenRoot && this.dropBetween) {
                this.cueLineRectBelow.setRect(0.0, 0.0, 0.0, 0.0);
            } else if (!this.dropBetween && (nodeToDropTo != null && !nodeToDropTo.isContainer() || nodeToDropTo.getDisplayPeer() != lastComponent || nodeToDropTo instanceof AbstractToolModel && hasScreens || nodeToDropTo instanceof ScreenRoot && hasTools)) {
                acceptDrop = false;
            }
            if (this.insertIndex != -1) {
                acceptDrop = true;
                if (this.cueLineRectAbove.contains(dtde.getLocation().getX(), dtde.getLocation().getY())) {
                    this.cueRectangle = this.cueLineRectAbove;
                } else if (this.cueLineRectBelow.contains(dtde.getLocation().getX(), dtde.getLocation().getY())) {
                    this.cueRectangle = this.cueLineRectBelow;
                }
            } else {
                this.cueRectangle = null;
            }
            if (!acceptDrop) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(dtde.getDropAction());
            }
        }
        this.dragListenerLocation = dtde.getLocation();
        this.dragListener.repaintDraggedImage((JTree)((Object)this.tree));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean success;
        block9: {
            Object node;
            this.cueRectangle = null;
            this.dragListenerLocation = null;
            this.hoverTimer.stop();
            success = false;
            Point location = dtde.getLocation();
            TreePath path = this.tree.getClosestPathForLocation(location.x, location.y);
            Object object = node = path == null ? null : path.getLastPathComponent();
            if (node != null && node instanceof DefaultMutableTreeNode) {
                Object obj = ((DefaultMutableTreeNode)node).getUserObject();
                if (!(obj instanceof WBNode)) break block9;
                WBNode wbNode = (WBNode)obj;
                if (this.dropBetween) {
                    MainNavDndTree dndTree;
                    wbNode = this.tree instanceof MainNavDndTree ? ((dndTree = (MainNavDndTree)this.tree).isTopLevelPath(path) ? wbNode : wbNode.getParent()) : wbNode.getParent();
                }
                try {
                    Transferable tr = dtde.getTransferable();
                    if (tr.isDataFlavorSupported(TransferableTreePath.NODELIST_FLAVOR)) {
                        dtde.acceptDrop(3);
                        long[] encodedData = (long[])tr.getTransferData(TransferableTreePath.NODELIST_FLAVOR);
                        long[] newUids = InternalNodeListFlavor.translateUids((long[])encodedData, (WhiteboardContext)this.context);
                        this.context.getDataExporter().blockCodecs();
                        success = this.addElements(path, wbNode, newUids, this.insertIndex, dtde.getDropAction());
                        this.context.getDataExporter().unblockCodecs();
                        if (success) {
                            // empty if block
                        }
                    }
                    break block9;
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
                catch (UnsupportedFlavorException ufe) {
                    ufe.printStackTrace();
                }
                break block9;
            }
            System.out.println("Can't accept drop");
        }
        dtde.dropComplete(success);
        this.endDropCleanup();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void endDropCleanup() {
        this.repaintCueZone();
        this.cueRectangle = null;
        this.dragListenerLocation = null;
        this.tree.repaint();
    }

    public Point getLocation() {
        return this.dragListenerLocation;
    }

    private boolean isRootPath(TreePath path) {
        Object obj;
        Object node = path.getLastPathComponent();
        if (node != null && node instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)node).getUserObject()) instanceof WBNode && ((WBNode)obj).getParentUID() == null) {
            return true;
        }
        return this.tree.isRootVisible() && this.tree.getRowForPath(path) == 0;
    }

    public void paintDropZone(Graphics g, Point pt) {
        if (this.cueRectangle != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.cueLineColor);
            g2.fill(this.cueRectangle);
        }
    }

    public void repaintCueZone() {
        if (this.cueRectangle != null) {
            this.tree.repaint(this.cueRectangle.getBounds());
        }
    }

    private boolean validParenting(Point location, Transferable tr, JTree tree, WBNode nodeToDropTo, boolean copy) {
        try {
            if (tr.isDataFlavorSupported(TransferableTreePath.NODELIST_FLAVOR)) {
                long[] encodedData = (long[])tr.getTransferData(TransferableTreePath.NODELIST_FLAVOR);
                if (encodedData[1] != this.context.getConferenceUID()) {
                    return false;
                }
                if (this.context.getConferenceUID() == 0L && encodedData[2] != (long)this.context.hashCode()) {
                    return false;
                }
                long[] newUids = InternalNodeListFlavor.translateUids((long[])encodedData, (WhiteboardContext)this.context);
                for (int i = 0; i < newUids.length; ++i) {
                    WBNode wbNodeToDrop = (WBNode)this.context.getObjectManager().getObjectFromMap(Long.valueOf(newUids[i]));
                    if (!(wbNodeToDrop instanceof WBNode)) {
                        return false;
                    }
                    if (nodeToDropTo instanceof ScreenModel && !(nodeToDropTo instanceof ScreenRoot)) {
                        return false;
                    }
                    if (nodeToDropTo instanceof AbstractToolModel && wbNodeToDrop instanceof ScreenModel) {
                        return false;
                    }
                    if (!copy && wbNodeToDrop.isParentOf((Object)nodeToDropTo)) {
                        return false;
                    }
                    if (!nodeToDropTo.isPartOfBackGround() || nodeToDropTo.findScreenParent().canEditBackground()) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

