/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.BoxUIInterface;
import com.elluminate.groupware.whiteboard.tools.RectangleToolModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class BoxUI
extends AbstractUI
implements BoxUIInterface {
    private static Color fillRectColor;
    private static Rectangle rectangle;

    public void draw(Graphics g, AbstractToolModel tool) {
        Rectangle2D rectangle = (Rectangle2D)tool.getUIData();
        if (rectangle == null) {
            rectangle = new Rectangle2D.Double();
            tool.setUIData((Object)rectangle);
        }
        RectangleToolModel rectangleTool = (RectangleToolModel)tool;
        if (tool.isUIInvalid()) {
            Rectangle rect = tool.getBounds();
            int x = rect.width < 0 ? rect.x + rect.width : rect.x;
            int y = rect.height < 0 ? rect.y + rect.height : rect.y;
            int w = rect.width < 0 ? -rect.width : rect.width;
            int h = rect.height < 0 ? -rect.height : rect.height;
            rectangle.setFrame(x, y, w, h);
            tool.setUIInvalid(false);
        }
        Graphics2D g2 = (Graphics2D)g;
        ToolColor fillColor = rectangleTool.getFillColor() != null ? rectangleTool.getFillColor() : rectangleTool.getColor();
        try {
            if (fillColor != null && fillColor.getAlpha() > 0) {
                g2.setColor((Color)fillColor.getColor());
                g2.fill(rectangle);
            }
            g2.setColor((Color)tool.getColor().getColor());
            g2.setStroke((BasicStroke)tool.getStroke().getStroke());
            g2.draw(rectangle);
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    public static void fillRect(Graphics g, int x, int y, int width, int height, Color color, int alpha) {
        Graphics2D g2 = (Graphics2D)g;
        if (alpha < 255) {
            fillRectColor = new Color(color.getRed(), color.getGreen(), color.getGreen(), alpha);
            g2.setColor(fillRectColor);
        } else {
            g2.setColor(color);
        }
        rectangle.setBounds(x, y, width, height);
        g2.fill(rectangle);
    }

    static {
        rectangle = new Rectangle();
    }
}

