/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavMouseAdapter;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.gui.swing.CTree;
import com.elluminate.util.I18n;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeModel;

public abstract class AbstractNavigator
extends JPanel
implements KeyListener {
    static final String NAV_DIALOG_PROP = "com.bb.collaborate.navigatorDialog";
    protected static final I18n i18n = I18n.create((Object)new Object(){});
    protected static final int NAV_HEIGHT = 300;
    protected static final int NAV_WIDTH = 250;
    private BorderLayout navigatorLayout = new BorderLayout();
    protected JScrollPane navigatorScroller = null;
    private HashMap modelTrees = new HashMap();
    protected DndTree navigatorTree = null;
    private AbstractNavMouseAdapter mouseAdapter = null;
    protected WhiteboardContext context = null;
    protected JPopupMenu popup = null;
    private Runnable resetCache = new ResetCacheRunnable();
    private Runnable nodeChangeRunnable = new NodeChangeRunnable();

    public static CDialog createDialog(final AbstractNavigator navigator, Frame parent, String title) {
        CDialog dialog = new CDialog(parent, title, false){
            private WhiteboardContext context;
            {
                super(x0, x1, x2);
                this.context = navigator.context;
                this.enableEvents(8L);
            }

            public void setVisible(boolean visible) {
                JPopupMenu popup;
                if (!visible && (popup = navigator.popup) != null) {
                    popup.setVisible(false);
                }
                if (visible && this.context != null) {
                    Rectangle parent = this.context.getDialogParentFrame().getBounds();
                    Point loc = new Point(Math.max(0, parent.x), Math.max(0, parent.y));
                    Point offset = SwingUtilities.convertPoint((ControllerPane)this.context.getController(), 0, 0, this.context.getDialogParentFrame());
                    loc.x += 10;
                    loc.y += offset.y;
                    this.setLocation(loc);
                }
                navigator.navigatorTree.setVisible(visible);
                super.setVisible(visible);
                navigator.nodeChangeRunnable.run();
            }
        };
        dialog.getRootPane().putClientProperty("Window.style", "small");
        navigator.putClientProperty(NAV_DIALOG_PROP, dialog);
        dialog.setDefaultCloseOperation(0);
        dialog.setContentPane((Container)navigator);
        dialog.setBounds(0, 0, 250, 300);
        dialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                navigator.frameClosing(e);
            }
        });
        return dialog;
    }

    protected AbstractNavigator(WhiteboardContext whiteboardContext) {
        this.context = whiteboardContext;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
        ((WhiteboardBean)this.context.getBean()).addShowThumbnailsListener(new WhiteboardBean.ShowThumbnailsListener(){

            @Override
            public void showThumbnailsChanged(WhiteboardBean.ShowThumbnailsEvent e) {
                AbstractNavigator.this.navigatorTree.setShowThumbnails(e.isShowingThumbnails());
                AbstractNavigator.this.processNodeChange();
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(this.navigatorLayout);
        this.navigatorScroller = new JScrollPane();
        this.navigatorScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.navigatorScroller, "Center");
    }

    void processNodeChange() {
        SwingRunnerSupport.invokeLater((Runnable)this.nodeChangeRunnable);
    }

    public void registerPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public String getLineStyle() {
        return (String)this.navigatorTree.getClientProperty("JTree.lineStyle");
    }

    public void setLineStyle(String style) {
        try {
            this.navigatorTree.putClientProperty("JTree.lineStyle", style);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"setLineStyle", (Throwable)e, (boolean)true);
        }
    }

    public boolean getLargeModel() {
        return this.navigatorTree.isLargeModel();
    }

    public void setLargeModel(boolean b) {
        this.navigatorTree.setLargeModel(b);
    }

    public void setMotionAdapter(AbstractNavMouseAdapter mouseAdapter) {
        this.mouseAdapter = mouseAdapter;
        this.navigatorTree.addMouseMotionListener(mouseAdapter);
        this.navigatorTree.addMouseListener(mouseAdapter);
    }

    public TreeModel getModel() {
        if (this.navigatorTree == null) {
            return null;
        }
        return this.navigatorTree.getModel();
    }

    public void setModel(DisplayModel model) {
        DndTree tree = (DndTree)((Object)this.modelTrees.get(model));
        if (tree == null) {
            MouseListener[] listeners;
            tree = this.newDndTreeInstance(this.context);
            tree.setModel((TreeModel)model);
            model.addViewer((JTree)((Object)tree));
            for (MouseListener listener : listeners = tree.getMouseListeners()) {
                if (!(listener instanceof CTree.ClearSelectionMouseAdapter)) continue;
                tree.removeMouseListener(listener);
            }
            if (this.mouseAdapter != null) {
                tree.addMouseListener(this.mouseAdapter);
                tree.addMouseMotionListener(this.mouseAdapter);
            }
            this.modelTrees.put(model, tree);
        }
        if (this.navigatorTree != null) {
            this.navigatorScroller.getViewport().remove((Component)((Object)this.navigatorTree));
        }
        this.navigatorScroller.getViewport().add((Component)((Object)tree), null);
        this.navigatorScroller.getViewport().setExtentSize(tree.getPreferredSize());
        this.navigatorTree = tree;
        this.navigatorScroller.invalidate();
        if (!tree.isVisible()) {
            tree.setVisible(true);
        }
        tree.repaint();
    }

    public boolean equal(TreeModel model) {
        return model != null && model instanceof TreeModel && model == this.navigatorTree.getModel();
    }

    public boolean getScrollsOnExpand() {
        return this.navigatorTree.getScrollsOnExpand();
    }

    public void setScrollsOnExpand(boolean b) {
        this.navigatorTree.setScrollsOnExpand(b);
    }

    protected DndTree newDndTreeInstance(WhiteboardContext context) {
        return new DndTree(context);
    }

    abstract void frameClosing(WindowEvent var1);

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mouseAdapter != null) {
            this.mouseAdapter.setEnabled(enabled);
        }
    }

    private class NodeChangeRunnable
    implements Runnable {
        private NodeChangeRunnable() {
        }

        @Override
        public void run() {
            if (!AbstractNavigator.this.navigatorTree.isExpanded(0)) {
                AbstractNavigator.this.navigatorTree.expandRow(0);
            }
            AbstractNavigator.this.navigatorTree.setRowHeight(16);
            SwingRunnerSupport.invokeLater((Runnable)AbstractNavigator.this.resetCache);
        }
    }

    private class ResetCacheRunnable
    implements Runnable {
        private ResetCacheRunnable() {
        }

        @Override
        public void run() {
            AbstractNavigator.this.navigatorTree.setRowHeight(0);
        }
    }
}

