/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations.windows;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointLoader;
import com.elluminate.platform.Platform;
import com.elluminate.platform.VersionSupport;
import com.elluminate.util.Debug;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.Resource;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WinPPTLoader
implements PowerPointLoader {
    private static final String[] TYPE_OF_SLIDE;
    private static final String[] JPEG_SUFFIXES;
    private static final String[] PNG_SUFFIXES;
    private static final String PKG_NAME = "com.elluminate.groupware.whiteboard.module.presentations.windows";
    private static String helper;
    static String relPathSrc;
    static Resource libRes;
    private static final boolean has2007Support;
    private static boolean isUsingVB6;

    private static boolean verifyInteropVersion(File f) {
        if (f == null) {
            return false;
        }
        if (!f.isDirectory()) {
            return false;
        }
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message(WinPPTLoader.class, (String)"verifyInteropVersion", (String)("Scanning " + f));
        }
        String REQUIRED_VERSION = "11+";
        for (String name : f.list()) {
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message(WinPPTLoader.class, (String)"verifyInteropVersion", (String)("Checking '" + name + "' vs. " + REQUIRED_VERSION + " -- " + VersionSupport.matchVersion((String)name, (String)REQUIRED_VERSION)));
            }
            if (!VersionSupport.matchVersion((String)name, (String)REQUIRED_VERSION)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return libRes != null;
    }

    @Override
    public boolean isXMLSupported() {
        return has2007Support && this.isAvailable();
    }

    @Override
    public void load(File exportPath, File pptFile, File metaData, int slideType, int wbWidth, int wbHeight) {
        this.callPPTAPP(exportPath.getAbsolutePath(), pptFile.getAbsolutePath(), TYPE_OF_SLIDE[slideType - 1], wbWidth, wbHeight);
    }

    private void callPPTAPP(String tempDir, String path, String arg, int width, int height) {
        int status;
        block49: {
            if (libRes == null) {
                return;
            }
            File tempRenamedFile = null;
            char[] pathNameChars = path.toCharArray();
            boolean doConvertName = false;
            if (pathNameChars != null) {
                for (int i = 0; i < pathNameChars.length; ++i) {
                    if (pathNameChars[i] >= ' ' && pathNameChars[i] <= '~') continue;
                    doConvertName = true;
                    break;
                }
            }
            if (doConvertName) {
                SimpleDateFormat sdf = new SimpleDateFormat("yy_MM_dd");
                int random = (int)(Math.random() * 10000.0);
                try {
                    File file = new File(path);
                    tempRenamedFile = File.createTempFile(sdf.format(new Date()) + "_" + random, ".ppt", new File(tempDir));
                    FileInputStream fis = new FileInputStream(file);
                    FileOutputStream fos = new FileOutputStream(tempRenamedFile);
                    byte[] buf = new byte[1024];
                    int i = 0;
                    while ((i = fis.read(buf)) != -1) {
                        fos.write(buf, 0, i);
                    }
                    fis.close();
                    fos.close();
                    path = tempRenamedFile.getPath();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!tempDir.endsWith(File.separator)) {
                tempDir = tempDir + File.separator;
            }
            String absPathDst = tempDir;
            absPathDst = absPathDst + helper;
            File helperExe = new File(absPathDst);
            if (!WhiteboardDebug.POWERPOINT.show()) {
                helperExe.deleteOnExit();
            }
            try {
                libRes.save(absPathDst);
            }
            catch (IOException iox) {
                LogSupport.exception((Object)this, (String)"callPPTAPP", (Throwable)iox, (boolean)true);
                throw new RuntimeException("Cannot store PowerPoint export helper: " + iox);
            }
            String[] command = new String[]{absPathDst, "\"" + tempDir + "\"", "\"" + path + "\"", "\"" + arg + "\"", "\"" + width + "\"", "\"" + height + "\""};
            StringBuffer outBuf = null;
            status = Short.MIN_VALUE;
            if (WhiteboardDebug.POWERPOINT.show()) {
                StringBuilder msg = new StringBuilder();
                outBuf = new StringBuffer();
                for (String s : command) {
                    if (msg.length() > 0) {
                        msg.append(' ');
                    }
                    msg.append(s);
                }
                LogSupport.message((Object)this, (String)"callPPTAPP", (String)("Executing: " + msg));
            }
            try {
                status = ProcessUtils.exec((String[])command, outBuf, outBuf, (long)-1L, (boolean)false);
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"callPPTAPP", (String)("Exit status: " + status + " 0x" + Integer.toHexString(status)));
                    if (outBuf != null && outBuf.length() > 0) {
                        LogSupport.message((Object)this, (String)"callPPTAPP", (String)("********** Process Output:\n" + outBuf + "\n********** END Process Output"));
                    }
                }
                if (tempRenamedFile == null) break block49;
                tempRenamedFile.delete();
            }
            catch (Throwable ex) {
                try {
                    LogSupport.exception((Object)this, (String)"callPPTAPP", (Throwable)ex, (boolean)true);
                    throw new RuntimeException("Error while exporting from PowerPoint: " + ex, ex);
                }
                catch (Throwable throwable) {
                    if (tempRenamedFile != null) {
                        tempRenamedFile.delete();
                    }
                    File fTemp = new File(tempDir);
                    FilenameFilter jpegFilter = new FilenameFilter(fTemp){
                        final /* synthetic */ File val$fTemp;
                        {
                            this.val$fTemp = file;
                        }

                        @Override
                        public boolean accept(File dir, String name) {
                            if (!dir.equals(this.val$fTemp)) {
                                return false;
                            }
                            String ext = FileSysUtils.getExtensionString((String)name);
                            if (ext != null) {
                                for (String suffix : JPEG_SUFFIXES) {
                                    if (!ext.equalsIgnoreCase(suffix)) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                    };
                    for (File jpegFile : fTemp.listFiles(jpegFilter)) {
                        try {
                            String name = jpegFile.getName();
                            boolean hasPNG = false;
                            for (String suffix : PNG_SUFFIXES) {
                                File pngFile = new File(fTemp, FileSysUtils.replaceExtension((String)name, (String)suffix));
                                if (!pngFile.exists()) continue;
                                hasPNG = true;
                                break;
                            }
                            if (!hasPNG) continue;
                            jpegFile.delete();
                            if (!WhiteboardDebug.POWERPOINT.show()) continue;
                            LogSupport.message((Object)this, (String)"callPPTAPP", (String)("deleted superfluous file " + name));
                        }
                        catch (Throwable t) {
                            LogSupport.message((Object)this, (String)"callPPTAPP", (String)("Exception postprocessing " + jpegFile + ": " + Debug.getStackTrace((Throwable)t)));
                        }
                    }
                    boolean wasCanceled = false;
                    File file = new File(tempDir + "\\canceled.tmp");
                    if (file.exists()) {
                        wasCanceled = true;
                        try {
                            file.delete();
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                    }
                    if ((file = new File(tempDir, "error.txt")).exists()) {
                        try {
                            WinPPTLoader.dumpFileToConsole(file);
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        try {
                            file.delete();
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                    }
                    if (wasCanceled) {
                        throw new PowerPointImport.CancelledException();
                    }
                    throw throwable;
                }
            }
        }
        File fTemp = new File(tempDir);
        FilenameFilter jpegFilter = new /* invalid duplicate definition of identical inner class */;
        for (File jpegFile : fTemp.listFiles(jpegFilter)) {
            try {
                String name = jpegFile.getName();
                boolean hasPNG = false;
                for (String suffix : PNG_SUFFIXES) {
                    File pngFile = new File(fTemp, FileSysUtils.replaceExtension((String)name, (String)suffix));
                    if (!pngFile.exists()) continue;
                    hasPNG = true;
                    break;
                }
                if (!hasPNG) continue;
                jpegFile.delete();
                if (!WhiteboardDebug.POWERPOINT.show()) continue;
                LogSupport.message((Object)this, (String)"callPPTAPP", (String)("deleted superfluous file " + name));
            }
            catch (Throwable t) {
                LogSupport.message((Object)this, (String)"callPPTAPP", (String)("Exception postprocessing " + jpegFile + ": " + Debug.getStackTrace((Throwable)t)));
            }
        }
        boolean wasCanceled = false;
        File file = new File(tempDir + "\\canceled.tmp");
        if (file.exists()) {
            wasCanceled = true;
            try {
                file.delete();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if ((file = new File(tempDir, "error.txt")).exists()) {
            try {
                WinPPTLoader.dumpFileToConsole(file);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            try {
                file.delete();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if (wasCanceled) {
            throw new PowerPointImport.CancelledException();
        }
        if (status == -2147483647) {
            throw new PowerPointImport.CancelledException();
        }
        if (status != 0) {
            throw new RuntimeException("Export from PowerPoint failed, status: " + status + " 0x" + Integer.toHexString(status));
        }
    }

    @Override
    public boolean isCancelDisabledDuringLoad() {
        return isUsingVB6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpFileToConsole(File f) {
        LogSupport.message((String)("******** Contents of " + f.getName()));
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(f);
            br = new BufferedReader(fr);
            while (true) {
                String text = null;
                try {
                    text = br.readLine();
                }
                catch (EOFException eofx) {
                    break;
                }
                if (text == null) {
                    break;
                }
                LogSupport.message((String)text);
            }
        }
        catch (Throwable t) {
            LogSupport.message((String)("Error processing output: " + Debug.getStackTrace((Throwable)t)));
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable t) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable t) {}
            }
        }
        LogSupport.message((String)("******** End of " + f.getName()));
    }

    static {
        String assemDir;
        TYPE_OF_SLIDE = new String[]{"PowerPoint | Smallest", "PowerPoint | Quality", "PowerPoint | Quality"};
        JPEG_SUFFIXES = new String[]{"jpg", "jpeg"};
        PNG_SUFFIXES = new String[]{"png", "PNG"};
        helper = null;
        libRes = null;
        isUsingVB6 = false;
        libRes = null;
        String winPath = System.getenv("SYSTEMROOT");
        if (winPath == null) {
            winPath = "C:" + File.separator + "windows";
        }
        String reason = null;
        File pptApp = Platform.findAppByExtension((String)"ppt");
        if (pptApp == null || !"POWERPNT.EXE".equals(pptApp.getName())) {
            reason = "POWERPNT.EXE not found";
        } else if (Platform.is64BitAddressable()) {
            String sysWow64Path = winPath + File.separator + "SysWOW64";
            assemDir = winPath + File.separator + "assembly" + File.separator;
            String pathSep = System.getProperty("path.separator");
            String assemPath = assemDir + "GAC" + pathSep + assemDir + "GAC_32" + pathSep + assemDir + "GAC_MSIL";
            File vb5lib = FileSysUtils.findFileInPath((String)"msvbvm50.dll", (String)sysWow64Path);
            File vb6lib = FileSysUtils.findFileInPath((String)"msvbvm60.dll", (String)sysWow64Path);
            File netlib = FileSysUtils.findFileInPath((String)"mscoree.dll", (String)sysWow64Path);
            File interop = FileSysUtils.findFileInPath((String)"Microsoft.Office.Interop.PowerPoint", (String)assemPath);
            if (WhiteboardDebug.POWERPOINT.show()) {
                StringBuffer buf = new StringBuffer();
                if (vb5lib == null) {
                    buf.append("VB5 lib not found " + sysWow64Path + " :" + "msvbvm50.dll\n");
                }
                if (vb6lib == null) {
                    buf.append("VB6 lib not found " + sysWow64Path + " :" + "msvbvm60.dll\n");
                }
                if (netlib == null) {
                    buf.append("Dot.net lib not found " + sysWow64Path + " :" + "mscoree.dll\n");
                }
                if (assemPath == null) {
                    buf.append("Powerpoint lib not found " + assemPath + " :" + "Microsoft.Office.Interop.PowerPoint\n");
                }
                LogSupport.message(WinPPTLoader.class, (String)"<clinit>", (String)buf.toString());
            }
            boolean interopOK = WinPPTLoader.verifyInteropVersion(interop);
            if (WhiteboardDebug.POWERPOINT_VB5.show()) {
                helper = "eLivePPTConverter5.exe";
            } else if (WhiteboardDebug.POWERPOINT_VB6.show()) {
                helper = "eLivePPTConverter6.exe";
            } else if (vb6lib != null && netlib != null && interopOK) {
                helper = "eLivePPTConverter6.exe";
                isUsingVB6 = true;
            } else if (vb5lib != null) {
                helper = "eLivePPTConverter5.exe";
                StringBuilder reasonBuf = new StringBuilder();
                if (interop == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("Office Interop Assembly");
                }
                if (netlib == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append(".Net runtime");
                }
                if (vb6lib == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("VB6 runtime");
                }
                if (reasonBuf.length() > 0) {
                    reasonBuf.append(" are missing");
                }
                if (interop != null && !interopOK) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("wrong version of " + interop.getName());
                }
                reason = reasonBuf.length() > 0 ? reasonBuf.toString() : "unknown reason";
            } else {
                StringBuilder reasonBuf = new StringBuilder();
                reasonBuf.append("VB5 runtime");
                if (interop == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("Office Interop Assembly");
                }
                if (netlib == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append(".Net runtime");
                }
                if (vb6lib == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("VB6 runtime");
                }
                if (reasonBuf.length() > 0) {
                    reasonBuf.append(" are missing");
                }
                if (interop != null && !interopOK) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("wrong version of " + interop.getName());
                }
                reason = reasonBuf.length() > 0 ? reasonBuf.toString() : "unknown reason";
            }
        } else {
            String system32Path = winPath + File.separator + "System32";
            assemDir = winPath + File.separator + "assembly" + File.separator;
            String pathSep = System.getProperty("path.separator");
            String assemPath = assemDir + "GAC" + pathSep + assemDir + "GAC_32" + pathSep + assemDir + "GAC_MSIL";
            File vb5lib = FileSysUtils.findFileInPath((String)"msvbvm50.dll", (String)system32Path);
            File vb6lib = FileSysUtils.findFileInPath((String)"msvbvm60.dll", (String)system32Path);
            File netlib = FileSysUtils.findFileInPath((String)"mscoree.dll", (String)system32Path);
            File interop = FileSysUtils.findFileInPath((String)"Microsoft.Office.Interop.PowerPoint", (String)assemPath);
            if (WhiteboardDebug.POWERPOINT.show()) {
                StringBuffer buf = new StringBuffer();
                if (vb5lib == null) {
                    buf.append("VB5 lib not found " + system32Path + " :" + "msvbvm50.dll\n");
                }
                if (vb6lib == null) {
                    buf.append("VB6 lib not found " + system32Path + " :" + "msvbvm60.dll\n");
                }
                if (netlib == null) {
                    buf.append("Dot.net lib not found " + system32Path + " :" + "mscoree.dll\n");
                }
                if (assemPath == null) {
                    buf.append("Powerpoint lib not found " + assemPath + " :" + "Microsoft.Office.Interop.PowerPoint\n");
                }
                LogSupport.message(WinPPTLoader.class, (String)"<clinit>", (String)buf.toString());
            }
            boolean interopOK = WinPPTLoader.verifyInteropVersion(interop);
            if (WhiteboardDebug.POWERPOINT_VB5.show()) {
                helper = "eLivePPTConverter5.exe";
                reason = "flag whiteboard.powerpoint.vb5";
            } else if (WhiteboardDebug.POWERPOINT_VB6.show()) {
                helper = "eLivePPTConverter6.exe";
                reason = "flag whiteboard.powerpoint.vb6";
            } else if (vb6lib != null && netlib != null && interopOK) {
                helper = "eLivePPTConverter6.exe";
                isUsingVB6 = true;
            } else if (vb5lib != null) {
                helper = "eLivePPTConverter5.exe";
                StringBuilder reasonBuf = new StringBuilder();
                if (interop == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("Office Interop Assembly");
                }
                if (netlib == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append(".Net runtime");
                }
                if (vb6lib == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("VB6 runtime");
                }
                if (reasonBuf.length() > 0) {
                    reasonBuf.append(" are missing");
                }
                if (interop != null && !interopOK) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("wrong version of " + interop.getName());
                }
                reason = reasonBuf.length() > 0 ? reasonBuf.toString() : "unknown reason";
            } else {
                StringBuilder reasonBuf = new StringBuilder();
                reasonBuf.append("VB5 runtime");
                if (interop == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("Office Interop Assembly");
                }
                if (netlib == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append(".Net runtime");
                }
                if (vb6lib == null) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("VB6 runtime");
                }
                if (reasonBuf.length() > 0) {
                    reasonBuf.append(" are missing");
                }
                if (interop != null && !interopOK) {
                    if (reasonBuf.length() > 0) {
                        reasonBuf.append(", ");
                    }
                    reasonBuf.append("wrong version of " + interop.getName());
                }
                reason = reasonBuf.length() > 0 ? reasonBuf.toString() : "unknown reason";
            }
        }
        if (helper != null) {
            try {
                relPathSrc = PKG_NAME.replace('.', '/') + "/" + helper;
                libRes = new Resource(relPathSrc);
                libRes.load();
                if (!isUsingVB6) {
                    LogSupport.message(WinPPTLoader.class, (String)"<clinit>", (String)("Falling back to VB5: " + reason));
                }
            }
            catch (Throwable t) {
                libRes = null;
            }
        } else {
            LogSupport.message(WinPPTLoader.class, (String)"<clinit>", (String)("No PPT helper configured: " + reason));
            libRes = null;
        }
        File ppt2007 = Platform.findAppByExtension((String)"pptx");
        has2007Support = ppt2007 != null && ppt2007.exists();
    }
}

