/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations.loader;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.StarOfficeInformation;
import com.elluminate.groupware.whiteboard.module.StarOfficeLoaderInterface;
import com.elluminate.groupware.whiteboard.module.imageloading.WBImageUtils;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationImage;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationSlide;
import com.elluminate.groupware.whiteboard.module.presentations.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.container.XNamed;
import com.sun.star.document.XExporter;
import com.sun.star.document.XFilter;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapeDescriptor;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.presentation.XPresentationPage;
import com.sun.star.text.XText;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JProgressBar;

public class StarOfficeLoader
implements StarOfficeLoaderInterface {
    private static final String PPT_SLIDE = "pptSlide.";
    private static final int MILLISECONDS_PER_WAIT = 1000;
    private static final int SECONDS_TO_WAIT = 240;
    private static final boolean MAC_LEOPARD;
    private static final boolean NO_X11_TCP;
    private static final int X11_START_TRY_LIMIT = 5;
    private static final long X11_START_SLEEP_TIME = 500L;
    private static final int X11_BASE_PORT = 6000;
    static final int JPEG = 0;
    static final int GIF = 1;
    static final int PNG = 2;
    static final int MODE = 0;
    static final int JPEG_QUALITY_PERCENT = 100;
    static final int DIFF_PERCENTAGE_THRESHOLD = 50;
    static final double PIXELS_PER_INCH = 96.0;
    static final double MM_PER_INCH = 2540.0;
    static final double PIXELS_PER_MM = 0.03779527559055118;
    private XMultiServiceFactory factory;
    private XComponent component = null;
    private boolean starOfficeStarted = false;
    private boolean starOfficeRunning = false;
    private String port;
    private String host;
    private int width;
    private int height;
    private String connectURLString;
    private boolean runConversion = true;
    private PresentationImage[][] images;
    private String[] titles;
    private Map<Integer, List<String>> notes = new HashMap<Integer, List<String>>();
    private Map<Integer, String> altText = new HashMap<Integer, String>();
    private String starOfficeProgramPath = null;
    Process starOfficeProcess = null;
    private XDesktop desktop = null;
    XUnoUrlResolver urlResolver;
    XMultiServiceFactory serviceManager;
    private I18n i18n = null;

    private StarOfficeLoader(String host, String port, String starOfficeProgramPath) {
        this.initialize(host, port, starOfficeProgramPath, I18n.create((Object)this));
    }

    public StarOfficeLoader() {
    }

    @Override
    public void initialize(String host, String port, String starOfficeProgramPath, I18n i18n) {
        this.host = host;
        this.port = port;
        this.starOfficeProgramPath = starOfficeProgramPath;
        this.i18n = i18n == null ? I18n.create((Object)this) : i18n;
        this.connectURLString = "uno:socket,host=" + host + ",port=" + port + ";urp;StarOffice.ServiceManager";
    }

    public static StarOfficeLoaderInterface loaderFactory(String host, String port, String starOfficeProgramPath) {
        return new StarOfficeLoader(host, port, starOfficeProgramPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(StarOfficeInformation starOfficeInformation, JProgressBar progress) {
        String[] command;
        String[] commandNoSh = new String[]{starOfficeInformation.getStarOfficeProgramPath(), "-accept=socket,port=" + this.port + ";urp;StarOffice.ServiceManager", "-headless", "-nolockcheck"};
        String[] commandMac = new String[]{starOfficeInformation.getStarOfficeProgramPath(), "-display", ":0", "-accept=socket,port=" + this.port + ";urp;StarOffice.ServiceManager", "-headless", "-nolockcheck"};
        if (WhiteboardDebug.STAROFFICE.show()) {
            LogSupport.message((Object)this, (String)"connect", (String)("" + StarOfficeInformation.instance()));
        }
        this.starOfficeRunning = false;
        if (this.i18n != null) {
            this.setProgressString(progress, this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_CONNECTING_TO));
        }
        try {
            this.factory = null;
            this.serviceManager = Bootstrap.createSimpleServiceManager();
            this.urlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)this.serviceManager.createInstance("com.sun.star.bridge.UnoUrlResolver"));
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            return false;
        }
        Runtime rt = Runtime.getRuntime();
        this.setProgressMaximum(progress, 240);
        this.setProgressStringPainted(progress, true);
        switch (Platform.getOS()) {
            case 202: {
                if (StarOfficeInformation.instance().needsX11()) {
                    command = commandMac;
                    command[0] = starOfficeInformation.getStarOfficeExecutable();
                    command[2] = this.startX11();
                    break;
                }
                command = commandNoSh;
                command[0] = starOfficeInformation.getStarOfficeExecutable();
                break;
            }
            default: {
                command = commandNoSh;
            }
        }
        if (WhiteboardDebug.STAROFFICE.show()) {
            LogSupport.message((Object)this, (String)"connect", (String)("Querying: " + this.connectURLString));
        }
        this.runConversion = true;
        for (int i = 0; i < 240 && this.runConversion && starOfficeInformation.isRunning(); ++i) {
            this.setProgressValue(progress, i);
            try {
                this.factory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.urlResolver.resolve(this.connectURLString));
                this.starOfficeRunning = true;
                break;
            }
            catch (NoConnectException ex1) {
                if (i == 0) {
                    this.starOfficeStarted = false;
                }
                try {
                    if (this.starOfficeStarted) continue;
                    if (WhiteboardDebug.STAROFFICE.show()) {
                        LogSupport.message((Object)this, (String)"connect", (String)("Starting StarOffice: " + command[0] + ", " + command[1] + "," + command[2]));
                    }
                    this.setProgressString(progress, this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_STARTING_STAROFFICE));
                    this.starOfficeProcess = rt.exec(command);
                    ProcessUtils.ignoreProcessOutput((Process)this.starOfficeProcess);
                    this.starOfficeStarted = true;
                }
                catch (IOException ex) {
                    this.starOfficeStarted = false;
                    this.starOfficeRunning = false;
                }
                continue;
            }
            catch (ConnectionSetupException ex1) {
                this.starOfficeStarted = false;
                this.starOfficeRunning = false;
                ex1.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException ex1) {
                this.starOfficeStarted = false;
                this.starOfficeRunning = false;
                ex1.printStackTrace();
                continue;
            }
            finally {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    this.starOfficeStarted = false;
                    this.starOfficeRunning = false;
                }
            }
        }
        this.setProgressString(progress, "");
        this.setProgressValue(progress, 0);
        if (!this.starOfficeRunning) {
            this.starOfficeStarted = false;
        }
        return this.starOfficeRunning;
    }

    private void setProgressString(final JProgressBar progress, final String string) {
        if (progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (progress != null) {
                        progress.setString(string);
                    }
                }
            });
        }
    }

    private void setProgressMaximum(final JProgressBar progress, final int maximum) {
        if (progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    progress.setMaximum(maximum);
                }
            });
        }
    }

    private void setProgressStringPainted(final JProgressBar progress, final boolean setting) {
        if (progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    progress.setStringPainted(setting);
                }
            });
        }
    }

    private void setProgressValue(final JProgressBar progress, final int value) {
        if (progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    progress.setValue(value);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findX11Display() {
        if (WhiteboardDebug.STAROFFICE.show()) {
            LogSupport.message((Object)this, (String)"startX11", (String)"checking if X11 is running");
        }
        if (NO_X11_TCP) {
            int pos;
            String shCommand = null;
            if (MAC_LEOPARD) {
                shCommand = "ps -x -O command | grep -i X11 | grep -i ' .auth ' | grep -v xinitrc";
            }
            if (shCommand == null) {
                return null;
            }
            String[] cmd = new String[]{"/bin/csh", "-c", shCommand};
            StringBuffer out = new StringBuffer();
            StringBuffer err = new StringBuffer();
            if (WhiteboardDebug.STAROFFICE.show()) {
                LogSupport.message((Object)this, (String)"findX11Display", (String)("checking X11: " + StringUtils.getStringValue((Object)cmd)));
            }
            int status = -1;
            try {
                status = ProcessUtils.exec((String[])cmd, (StringBuffer)out, (StringBuffer)err, (long)1000L, (boolean)false);
            }
            catch (IOException iox) {
                LogSupport.message((Object)this, (String)"findX11Display", (String)("Exception getting X11 DISPLAY stdout='" + out + "' stderr='" + err + "'"));
                LogSupport.exception((Object)this, (String)"findX11Display", (Throwable)iox, (boolean)true);
                return null;
            }
            if (status != 0) {
                if (WhiteboardDebug.STAROFFICE.show()) {
                    LogSupport.message((Object)this, (String)"findX11Display", (String)("Getting X11 DISPLAY, status=" + status + " stdout='" + out + "' stderr='" + err + "'"));
                }
                return null;
            }
            String text = out.toString();
            if (WhiteboardDebug.STAROFFICE.show()) {
                LogSupport.message((Object)this, (String)"findX11Display", (String)("  output='" + text + "'"));
            }
            if ((pos = text.lastIndexOf(58)) >= 0) {
                if ((pos = (text = text.substring(pos)).indexOf(32)) < 0) {
                    pos = text.length();
                }
                return text.substring(0, pos);
            }
        } else {
            for (int port = 0; port < 10; ++port) {
                if (WhiteboardDebug.STAROFFICE.show()) {
                    LogSupport.message((Object)this, (String)"findX11Display", (String)("checking port " + (6000 + port)));
                }
                Socket s = null;
                try {
                    s = new Socket("127.0.0.1", 6000 + port);
                    if (s == null || !s.isConnected() || !this.validateX11(s)) continue;
                    String out = ":" + port;
                    return out;
                }
                catch (ConnectException ce) {
                    continue;
                }
                catch (SocketException se) {
                    continue;
                }
                catch (SocketTimeoutException stx) {
                    continue;
                }
                catch (IOException iox) {
                    LogSupport.message((Object)this, (String)"startX11", (String)Debug.getStackTrace((Throwable)iox));
                    continue;
                }
                finally {
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return null;
    }

    private String startX11() {
        String[] startCommand = new String[]{"open", "-a", "X11"};
        for (int i = 0; i < 5; ++i) {
            String display = this.findX11Display();
            if (display != null) {
                if (WhiteboardDebug.STAROFFICE.show()) {
                    LogSupport.message((Object)this, (String)"startX11", (String)("found X11, DISPLAY=" + display));
                }
                return display;
            }
            if (WhiteboardDebug.STAROFFICE.show()) {
                LogSupport.message((Object)this, (String)"startX11", (String)("starting X11: " + StringUtils.getStringValue((Object)startCommand)));
            }
            StringBuffer buf = new StringBuffer();
            try {
                int status = ProcessUtils.exec((String[])startCommand, (StringBuffer)buf, (StringBuffer)buf, (long)8000L, (boolean)false);
                if (WhiteboardDebug.STAROFFICE.show()) {
                    LogSupport.message((Object)this, (String)"startX11", (String)("X11 status=" + status + " output='" + buf + "'"));
                }
                if (status != 0) {
                    throw new RuntimeException("X11 startup failed.");
                }
            }
            catch (Throwable t) {
                LogSupport.message((Object)this, (String)"startX11", (String)Debug.getStackTrace((Throwable)t));
                break;
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        throw new RuntimeException("Cannot determine X11 DISPLAY");
    }

    private boolean validateX11(Socket s) {
        return true;
    }

    public boolean isConnected() {
        return this.factory != null;
    }

    @Override
    public void stopStarOffice() {
        if (this.starOfficeStarted) {
            try {
                try {
                    this.desktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)this.factory.createInstance("com.sun.star.frame.Desktop"));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    if (this.component != null) {
                        this.component.dispose();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (this.desktop != null) {
                    this.desktop.terminate();
                }
                if (this.starOfficeProcess != null) {
                    int exitStatus = ProcessUtils.waitFor((Process)this.starOfficeProcess, (long)8000L, (boolean)false);
                    if (WhiteboardDebug.STAROFFICE.show()) {
                        LogSupport.message((Object)this, (String)"stopStarOffice", (String)("Process exit status: " + exitStatus));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void getTextFromPage(XDrawPage page, int pageNum) throws Exception {
        String totalText = "";
        for (int i = 0; i < page.getCount(); ++i) {
            XText xText;
            XShape shape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)page.getByIndex(i));
            if (shape == null || (xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)shape)) == null) continue;
            String text = xText.getString();
            if (totalText.length() > 0) {
                totalText = totalText + '\n';
            }
            totalText = totalText + text;
        }
        totalText = this.stripEmptyLines(totalText);
        this.altText.put(pageNum, totalText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String stripEmptyLines(String string) {
        StringBuilder result;
        block44: {
            BufferedReader bufRdr;
            InputStreamReader rdr;
            ByteArrayInputStream fis;
            block43: {
                String s;
                fis = null;
                rdr = null;
                bufRdr = null;
                result = null;
                fis = new ByteArrayInputStream(string.getBytes("UTF-8"));
                rdr = new InputStreamReader((InputStream)fis, "UTF-8");
                bufRdr = new BufferedReader(rdr);
                while ((s = bufRdr.readLine()) != null) {
                    if ((s = s.trim()).length() <= 0) continue;
                    if (result == null) {
                        result = new StringBuilder();
                    }
                    if (result.length() > 0) {
                        result.append('\n');
                    }
                    result.append(s);
                }
                if (bufRdr == null) break block43;
                try {
                    bufRdr.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable ignored) {}
            }
            break block44;
            catch (EOFException ignored) {
                if (bufRdr != null) {
                    try {
                        bufRdr.close();
                    }
                    catch (Throwable ignored2) {
                        // empty catch block
                    }
                }
                if (rdr != null) {
                    try {
                        rdr.close();
                    }
                    catch (Throwable ignored3) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable ignored4) {}
                }
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"stripEmptyLines", (Throwable)t, (boolean)true, (String)("Reading string " + string));
                String string2 = string;
                return string2;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (bufRdr != null) {
                        try {
                            bufRdr.close();
                        }
                        catch (Throwable ignored) {}
                    }
                    if (rdr != null) {
                        try {
                            rdr.close();
                        }
                        catch (Throwable ignored) {}
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable ignored) {}
                    }
                }
            }
        }
        if (result == null) {
            return string;
        }
        return result.toString();
    }

    public void getNotesFromPage(XDrawPage page, int pageNum) throws Exception {
        XPresentationPage presentationPage = (XPresentationPage)UnoRuntime.queryInterface(XPresentationPage.class, (Object)page);
        ArrayList<String> noteValue = new ArrayList<String>();
        if (presentationPage != null) {
            XDrawPage notesPage = presentationPage.getNotesPage();
            int count = notesPage.getCount();
            for (int i = 0; i < count; ++i) {
                XText xText;
                XShapeDescriptor shapeDescriptor;
                XShape shape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)notesPage.getByIndex(i));
                if (shape == null || (shapeDescriptor = (XShapeDescriptor)UnoRuntime.queryInterface(XShapeDescriptor.class, (Object)shape)) == null || !shapeDescriptor.getShapeType().contains("NotesShape") || (xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)shape)) == null) continue;
                String text = xText.getString();
                for (String note : text.split("\n")) {
                    noteValue.add(note.trim());
                }
            }
        }
        this.notes.put(pageNum, noteValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean convertFile(StarOfficeInformation starOfficeInformation, File source, File destinationFolder, JProgressBar progress, int screenWidth, int screenHeight, boolean forceWidth, boolean forceHeight, int fileIndex, int fileTotal, int slideType) {
        int pageWidth = 0;
        int pageHeight = 0;
        Rectangle area = new Rectangle(0, 0, 0, 0);
        this.runConversion = true;
        this.width = screenWidth;
        this.height = screenHeight;
        StringBuffer sourceURL = new StringBuffer("file:///");
        this.setProgressString(progress, this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_PROGRESS_STRING, new Object[]{source.getName()}));
        this.setProgressValue(progress, 0);
        try {
            PropertyValue[] filterData;
            sourceURL.append(source.getCanonicalPath().replace(File.separatorChar, '/'));
            XComponentLoader loader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.factory.createInstance("com.sun.star.frame.Desktop"));
            PropertyValue[] properties = new PropertyValue[]{new PropertyValue()};
            properties[0].Name = "Hidden";
            properties[0].Value = Boolean.TRUE;
            if (this.component == null) {
                this.component = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)loader.loadComponentFromURL(sourceURL.toString(), "_blank", 0, properties));
            }
            XDrawPagesSupplier pagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.component);
            Object graphicExportFilter = this.factory.createInstance("com.sun.star.drawing.GraphicExportFilter");
            XExporter exporter = (XExporter)UnoRuntime.queryInterface(XExporter.class, (Object)graphicExportFilter);
            XFilter filter = (XFilter)UnoRuntime.queryInterface(XFilter.class, (Object)exporter);
            PropertyValue[] convertProperties = new PropertyValue[3];
            convertProperties[0] = new PropertyValue();
            convertProperties[0].Name = "URL";
            convertProperties[1] = new PropertyValue();
            convertProperties[1].Name = "MediaType";
            convertProperties[1].Value = "image/png";
            convertProperties[2] = new PropertyValue();
            convertProperties[2].Name = "FilterData";
            convertProperties[2].Value = filterData = new PropertyValue[2];
            filterData[0] = new PropertyValue();
            filterData[0].Name = "PixelWidth";
            filterData[1] = new PropertyValue();
            filterData[1].Name = "PixelHeight";
            XDrawPages pages = pagesSupplier.getDrawPages();
            int pageCount = pages.getCount();
            this.setProgressMaximum(progress, pageCount);
            this.images = new PresentationImage[pageCount][];
            this.titles = new String[pageCount];
            int pageNumber = 1;
            while (pageNumber <= pageCount) {
                boolean ignoreDiff;
                boolean havePNGs;
                int count;
                FileInputStream inputStream;
                byte[] imageBuffer;
                File imageFile;
                XComponent pageComponent;
                String title;
                XNamed xNamed;
                String name;
                String fgTargetPath;
                String bgTargetPath;
                if (!this.runConversion) return true;
                if (!starOfficeInformation.isRunning()) return true;
                int slideIndex = pageNumber - 1;
                while (true) {
                    bgTargetPath = Platform.getTempDir() + "/" + PPT_SLIDE + slideIndex + ".0" + ".png";
                    File bgTargetFile = new File(bgTargetPath);
                    fgTargetPath = Platform.getTempDir() + "/" + PPT_SLIDE + slideIndex + ".1" + ".png";
                    File fgTargetFile = new File(fgTargetPath);
                    if (!bgTargetFile.exists()) break;
                    bgTargetFile.delete();
                    if (!fgTargetFile.exists()) break;
                    fgTargetFile.delete();
                }
                this.setProgressValue(progress, pageNumber);
                if (this.i18n != null) {
                    this.setProgressString(progress, this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_PROGRESS_STRING1, new Object[]{"" + pageNumber, "" + pageCount}));
                }
                XDrawPage page = (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, (Object)pages.getByIndex(pageNumber - 1));
                this.getNotesFromPage(page, pageNumber);
                this.getTextFromPage(page, pageNumber);
                XPropertySet pageProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)page);
                if (WhiteboardDebug.STAROFFICE_PROP.show()) {
                    for (Property p : pageProperties.getPropertySetInfo().getProperties()) {
                        LogSupport.message((Object)this, (String)"pageProperties", (String)(p.Name + " = " + pageProperties.getPropertyValue(p.Name)));
                    }
                }
                double mmHeight = ((Integer)pageProperties.getPropertyValue("Height")).doubleValue();
                double mmWidth = ((Integer)pageProperties.getPropertyValue("Width")).doubleValue();
                double ratio = mmWidth / mmHeight;
                pageWidth = (int)Math.ceil(mmWidth * 0.03779527559055118);
                pageHeight = (int)Math.ceil(mmHeight * 0.03779527559055118);
                if (forceWidth) {
                    if (screenWidth < pageWidth) {
                        pageHeight = (int)Math.ceil((double)screenWidth / ratio);
                    }
                    pageWidth = screenWidth;
                }
                if (forceHeight) {
                    if (screenHeight < pageHeight) {
                        pageWidth = (int)Math.ceil((double)screenHeight * ratio);
                    }
                    pageHeight = screenHeight;
                }
                if ((name = (xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)page)).getName().trim()).length() > 0) {
                    name = name.replace('\n', ' ');
                    name = name.replace('\r', ' ');
                    StringBuffer rawTitle = new StringBuffer(name);
                    int limit = rawTitle.length() - 1;
                    for (int i = 0; i < limit; ++i) {
                        if (!rawTitle.substring(i, i + 1).equals("  ")) continue;
                        rawTitle.deleteCharAt(i + 1);
                        --limit;
                    }
                    title = rawTitle.toString();
                } else {
                    title = this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_SCREEN, new Object[]{new Integer(pageNumber)});
                }
                if (WhiteboardDebug.STAROFFICE.show()) {
                    LogSupport.message((Object)this, (String)"convertFile", (String)("Processing " + pageNumber + ": " + pageWidth + "x" + pageHeight + " " + title));
                }
                double dRatio = (double)pageWidth / (double)pageHeight;
                double pixelWidth = pageWidth;
                double pixelHeight = pixelWidth / dRatio;
                if (MAC_LEOPARD) {
                    pixelHeight += 1.0;
                }
                filterData[0].Value = new Integer((int)pixelWidth);
                filterData[1].Value = new Integer((int)pixelHeight);
                area.width = pageWidth;
                area.height = pageHeight;
                this.titles[pageNumber - 1] = title;
                Boolean hasBackground = (Boolean)pageProperties.getPropertyValue("IsBackgroundVisible");
                if (hasBackground == null) {
                    hasBackground = false;
                }
                PresentationImage jpegBkgnd = null;
                PresentationImage jpegFg = null;
                PresentationImage pngBkgnd = null;
                PresentationImage pngFg = null;
                PresentationImage diff = null;
                long diffLen = 0L;
                if (hasBackground.booleanValue()) {
                    fgTargetPath = fgTargetPath.replace(File.separatorChar, '/');
                    convertProperties[0].Value = "file:///" + fgTargetPath;
                    pageComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)page);
                    exporter.setSourceDocument(pageComponent);
                    filter.filter(convertProperties);
                    imageFile = new File(fgTargetPath.replace('/', File.separatorChar));
                    imageFile.deleteOnExit();
                    imageBuffer = new byte[(int)imageFile.length()];
                    inputStream = new FileInputStream(imageFile);
                    try {
                        if (inputStream.read(imageBuffer) != imageBuffer.length) {
                            ModalDialog.showMessageDialog((Component)progress, (Object)(this.i18n.getStringLegacy("StarOfficeLoader.Incomplete_read_of_") + imageFile.getCanonicalPath()));
                            boolean bl = false;
                            return bl;
                        }
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {}
                    }
                    pngFg = new PresentationImage(imageFile.getName(), "image/png", imageBuffer, area);
                    imageFile.delete();
                    imageBuffer = null;
                    count = page.getCount();
                    ArrayList<XShape> removeXShapeList = new ArrayList<XShape>(count);
                    for (int i = 0; i < count; ++i) {
                        XShape shape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)page.getByIndex(i));
                        removeXShapeList.add(shape);
                    }
                    for (XShape shape : removeXShapeList) {
                        page.remove(shape);
                    }
                }
                bgTargetPath = bgTargetPath.replace(File.separatorChar, '/');
                convertProperties[0].Value = "file:///" + bgTargetPath;
                pageComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)page);
                exporter.setSourceDocument(pageComponent);
                filter.filter(convertProperties);
                imageFile = new File(bgTargetPath.replace('/', File.separatorChar));
                imageFile.deleteOnExit();
                imageBuffer = new byte[(int)imageFile.length()];
                inputStream = new FileInputStream(imageFile);
                try {
                    if (inputStream.read(imageBuffer) != imageBuffer.length) {
                        ModalDialog.showMessageDialog((Component)progress, (Object)(this.i18n.getStringLegacy("StarOfficeLoader.Incomplete_read_of_") + imageFile.getCanonicalPath()));
                        count = 0;
                        return count != 0;
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {}
                }
                pngBkgnd = new PresentationImage(imageFile.getName(), "image/png", imageBuffer, area);
                imageFile.delete();
                imageBuffer = null;
                jpegFg = this.createJPEGPresentationImage(pngFg);
                jpegBkgnd = this.createJPEGPresentationImage(pngBkgnd);
                boolean haveBackground = jpegBkgnd != null || pngBkgnd != null;
                boolean bl = havePNGs = pngFg != null && pngBkgnd != null;
                if (haveBackground && havePNGs) {
                    if (pngFg.getArea().width != pngBkgnd.getArea().width || pngFg.getArea().height != pngBkgnd.getArea().height) {
                        if (WhiteboardDebug.STAROFFICE.show()) {
                            LogSupport.message((Object)this, (String)"convertFile", (String)("Slide " + slideIndex + ": " + "background image size mismatch, using foreground only."));
                        }
                    } else {
                        diff = this.generateDifference(slideIndex, 1, pngFg, pngBkgnd);
                        if (diff != null) {
                            diffLen = diff.getImageData().length;
                        }
                    }
                }
                int reuseBkgndFactor = 2;
                long pngBkgndFileLength = pngBkgnd != null ? (long)pngBkgnd.getImageData().length : Long.MAX_VALUE;
                long pngFgFileLength = pngFg != null ? (long)pngFg.getImageData().length : Long.MAX_VALUE;
                long jpegBkgndFileLength = jpegBkgnd != null ? (long)jpegBkgnd.getImageData().length : Long.MAX_VALUE;
                long jpegFgFileLength = jpegFg != null ? (long)jpegFg.getImageData().length : Long.MAX_VALUE;
                long minBkgndLen = Math.min(jpegBkgndFileLength, pngBkgndFileLength);
                long minFgLen = Math.min(jpegFgFileLength, pngFgFileLength);
                long combinedAdjLen = minBkgndLen / (long)reuseBkgndFactor + diffLen;
                double lenDenom = Math.max(24576L, minFgLen);
                int lenRatio = (int)Math.round(100.0 * (double)combinedAdjLen / lenDenom);
                if (WhiteboardDebug.STAROFFICE.show()) {
                    Rectangle diffDim = diff != null ? diff.getArea() : new Rectangle();
                    LogSupport.message((Object)this, (String)"convertFile", (String)("Slide " + slideIndex + ": " + pageWidth + "x" + pageHeight + " JPG: " + PresentationSlide.toKB(jpegFgFileLength) + "K," + PresentationSlide.toKB(jpegBkgndFileLength) + "K PNG: " + PresentationSlide.toKB(pngFgFileLength) + "K," + PresentationSlide.toKB(pngBkgndFileLength) + "K Diff: " + diffDim.width + "x" + diffDim.height + " " + PresentationSlide.toKB(diffLen) + "K" + " reuse=" + reuseBkgndFactor + " lenRatio=" + lenRatio + "%"));
                }
                boolean bl2 = ignoreDiff = diff == null;
                if (!ignoreDiff && diffLen > 65536L && lenRatio > 350 && combinedAdjLen - minFgLen > 24576L) {
                    ignoreDiff = true;
                    if (WhiteboardDebug.STAROFFICE.show()) {
                        LogSupport.message((Object)this, (String)"convertFile", (String)("Slide " + slideIndex + " diff exceeds maximums"));
                    }
                }
                if (ignoreDiff) {
                    this.images[pageNumber - 1] = new PresentationImage[1];
                    if (pngFg != null && pngFgFileLength <= jpegFgFileLength) {
                        if (WhiteboardDebug.STAROFFICE.show()) {
                            LogSupport.message((Object)this, (String)"convertFile", (String)("Slide " + slideIndex + ": PNG " + pageWidth + "x" + pageHeight + " " + PresentationSlide.toKB(pngFgFileLength) + "K"));
                        }
                        this.images[pageNumber - 1][0] = pngFg;
                    } else {
                        if (WhiteboardDebug.STAROFFICE.show()) {
                            LogSupport.message((Object)this, (String)"convertFile", (String)("Slide " + slideIndex + ": JPG " + pageWidth + "x" + pageHeight + " " + PresentationSlide.toKB(jpegFgFileLength) + "K"));
                        }
                        this.images[pageNumber - 1][0] = jpegFg;
                    }
                } else {
                    int pngFactor = (int)Math.round(100.0 * (double)pngBkgndFileLength / (double)jpegBkgndFileLength / (double)reuseBkgndFactor);
                    this.images[pageNumber - 1] = new PresentationImage[2];
                    if (jpegBkgnd != null && jpegBkgndFileLength < pngBkgndFileLength && pngBkgndFileLength / (long)reuseBkgndFactor > 24576L && pngFactor > 250) {
                        if (WhiteboardDebug.STAROFFICE.show()) {
                            LogSupport.message((Object)this, (String)"convertFile", (String)("Slide " + slideIndex + ": JPG+diff " + pageWidth + "x" + pageHeight + " Bkg PNG/JPEG: " + pngFactor + "% " + PresentationSlide.toKB(jpegBkgndFileLength) + "K + " + PresentationSlide.toKB(diffLen) + "K"));
                        }
                        this.images[pageNumber - 1][0] = jpegBkgnd;
                    } else {
                        if (WhiteboardDebug.STAROFFICE.show()) {
                            LogSupport.message((Object)this, (String)"convertFile", (String)("Slide " + slideIndex + ": PNG+diff " + pageWidth + "x" + pageHeight + " Bkg PNG/JPEG: " + pngFactor + "% " + PresentationSlide.toKB(pngBkgndFileLength) + "K + " + PresentationSlide.toKB(diffLen) + "K"));
                        }
                        this.images[pageNumber - 1][0] = pngBkgnd;
                    }
                    this.images[pageNumber - 1][1] = diff;
                }
                ++pageNumber;
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (OutOfMemoryError e) {
            ModalDialog.showMessageDialog((Component)progress, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_MEMORYERROR), (String)this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_MEMORYERRORTITLE), (int)0);
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                boolean bl3;
                block87: {
                    ex.printStackTrace();
                    bl3 = false;
                    if (this.component == null || this.i18n == null) break block87;
                    this.setProgressString(progress, this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_PROGRESS_STRING2));
                }
                try {
                    if (this.component == null) return bl3;
                    this.component.dispose();
                    this.component = null;
                    return bl3;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return bl3;
            }
        }
        finally {
            if (this.component != null && this.i18n != null) {
                this.setProgressString(progress, this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICELOADER_PROGRESS_STRING2));
            }
            try {
                if (this.component != null) {
                    this.component.dispose();
                    this.component = null;
                }
            }
            catch (Throwable t) {}
        }
    }

    private PresentationImage createJPEGPresentationImage(PresentationImage pngImage) throws IOException {
        if (pngImage != null) {
            Image image = this.createImage(pngImage.getMimeType(), pngImage.getImageData());
            byte[] jpegImageData = ImageSupport.encodeAsJPEG((Image)image, (int)85);
            String filename = FileSysUtils.replaceExtension((String)pngImage.getImageName(), (String)"jpg");
            return new PresentationImage(filename, "image/jpeg", jpegImageData, pngImage.getArea());
        }
        return null;
    }

    @Override
    public PresentationImage[] getImages(int index) {
        return this.images[index];
    }

    @Override
    public String getTitle(int index) {
        return this.titles[index];
    }

    @Override
    public List<String> getSlideNotes(int index) {
        return this.notes.get(index);
    }

    @Override
    public String getSlideAltText(int index) {
        return this.altText.get(index);
    }

    @Override
    public int getImageCount() {
        if (this.images != null) {
            return this.images.length;
        }
        return 0;
    }

    @Override
    public void endConversion() {
        this.runConversion = false;
    }

    PresentationImage generateDifference(int slideIndex, int index, PresentationImage fg, PresentationImage bg) throws IOException {
        Image clippedImage;
        String imageName = PPT_SLIDE + slideIndex + "." + index + ".png";
        if (fg.getArea().width != bg.getArea().width || fg.getArea().height != bg.getArea().height) {
            throw new java.lang.IllegalArgumentException("Foreground and background areas do not match for slide: " + imageName);
        }
        int[] fgImage = fg.getImageArray();
        int[] bgImage = bg.getImageArray();
        boolean[] opaque = new boolean[1];
        Rectangle area = new Rectangle(0, 0, bg.getArea().width, bg.getArea().height);
        Rectangle origArea = new Rectangle(area);
        int nExpected = Math.max(0, area.width) * Math.max(0, area.height);
        if (WhiteboardDebug.STAROFFICE.show()) {
            LogSupport.message((Object)this, (String)"generateDifference", (String)("Slide #" + slideIndex + " " + area.width + "x" + area.height + " fgLen=" + fgImage.length + " bgLen=" + bgImage.length + " expected=" + nExpected));
        }
        Image outputImage = clippedImage = WBImageUtils.clipImage(fgImage, bgImage, area, opaque);
        if (opaque[0] && area.equals(origArea)) {
            return null;
        }
        if (area.width <= 0 || area.height <= 0) {
            return null;
        }
        byte[] imageBytes = ImageSupport.encodeAsPNG((Image)outputImage, (int)9);
        outputImage.flush();
        if (clippedImage != null && clippedImage != outputImage) {
            clippedImage.flush();
        }
        return new PresentationImage(imageName, "image/png", imageBytes, area);
    }

    private Image createImage(String mimeType, byte[] imageBytes) throws IOException {
        return ImageSupport.loadImage((String)mimeType, (byte[])imageBytes);
    }

    static {
        NO_X11_TCP = MAC_LEOPARD = Platform.checkOSVersion((int)202, (String)"10.5+");
    }

    class ImageEntry {
        byte[] buffer;
        String fileName;
        String title;
        int width;
        int height;

        public ImageEntry(byte[] buffer, String fileName, String title, int width, int height) {
            this.buffer = buffer;
            this.fileName = fileName;
            this.title = title;
            this.width = (int)((double)width * 0.03779527559055118);
            this.height = (int)((double)height * 0.03779527559055118);
        }
    }
}

