/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.module.StarOfficeFilter;
import com.elluminate.groupware.whiteboard.module.StarOfficeInformation;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class StartOfficeAppInstallPanel
extends JPanel {
    private I18n i18n;
    private JCheckBox useDefaultCheckBox;
    private JTextField pathField;
    private JLabel validInstallationField = new JLabel();
    private String oldExplicitPath = "";

    public StartOfficeAppInstallPanel(final ActionListener listener, I18n i18n) {
        this.i18n = i18n;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(i18n.getString((PropertiesEnum)StringsProperties.STAROFFICE_PATHBOX)), BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.useDefaultCheckBox = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.STAROFFICE_USEDEFAULTBOX));
        this.useDefaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartOfficeAppInstallPanel.this.doUseDefaultCheckBox();
                listener.actionPerformed(e);
            }
        });
        this.add((Component)this.useDefaultCheckBox, gbc);
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets.top = 6;
        this.pathField = new JTextField();
        this.pathField.setEditable(false);
        this.add((Component)this.pathField, gbc);
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets.top = 6;
        this.add((Component)this.validInstallationField, gbc);
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets.top = 6;
        JButton b = new JButton(i18n.getString((PropertiesEnum)StringsProperties.STAROFFICE_BROWSEBUTTON));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartOfficeAppInstallPanel.this.doBrowseButton();
                listener.actionPerformed(e);
            }
        });
        this.add((Component)b, gbc);
    }

    private void doUseDefaultCheckBox() {
        if (this.useDefaultCheckBox.isSelected()) {
            this.pathField.setText(this.getDefaultPath());
        } else {
            this.pathField.setText(this.oldExplicitPath);
        }
    }

    private void doBrowseButton() {
        CFileChooser ch = new CFileChooser();
        ch.addChoosableFileFilter((FileFilter)new StarOfficeFilter());
        if (!this.oldExplicitPath.equals("")) {
            ch.setCurrentDirectory(new File(this.oldExplicitPath));
        }
        if (ch.showOpenDialog((Component)this) != 0) {
            return;
        }
        File f = ch.getSelectedFile();
        String path = f.getPath();
        if (!StarOfficeInformation.isValidApp(path)) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICE_NOTAPPLICATION, new Object[]{path}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICE_NOTAPPLICATIONTITLE), (int)0);
            return;
        }
        this.pathField.setText(path);
        boolean usingDefault = this.getDefaultPath().equals(path);
        this.useDefaultCheckBox.setSelected(usingDefault);
        if (!usingDefault) {
            this.oldExplicitPath = path;
        }
    }

    public String getDefaultPath() {
        File exe = StarOfficeInformation.getAppByExtensions();
        if (exe == null || !exe.exists()) {
            return "";
        }
        return exe.getPath();
    }

    public void installInstallation(String appPath) {
        StarOfficeInformation sinfo = StarOfficeInformation.instance();
        sinfo.setStarOfficeApplicationPath(appPath);
        this.validInstallationField.setText(StarOfficeInformation.getInvalidReason());
    }

    public boolean isUseDefaultSelected() {
        return this.useDefaultCheckBox.isSelected();
    }

    public void setUseDefaultSelected(boolean value) {
        this.useDefaultCheckBox.setSelected(value);
    }

    public String getPath() {
        return this.pathField.getText();
    }

    public void setPath(String path) {
        this.pathField.setText(path);
    }
}

