/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.navigation;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.framework.feature.whiteboard.ScreenInfo;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.whiteboard.WhiteboardChairListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DataModelListener;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ACLList;
import com.elluminate.groupware.whiteboard.module.navigation.ExplorerEnabledClerk;
import com.elluminate.groupware.whiteboard.module.navigation.NavigationEnabledClerk;
import com.elluminate.groupware.whiteboard.module.navigation.PostionOfCurrentScreenClerk;
import com.elluminate.groupware.whiteboard.module.navigation.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ScreenNavigator {
    private WhiteboardContext context;
    private ControllerPane controllerPane;
    private ScreenModel currentScreen;
    private ScreenModel nextScreen;
    private ScreenModel previousScreen;
    private PostionOfCurrentScreenClerk positionClerk;
    private NavigationEnabledClerk enabledClerk;
    private ActionFeature firstScreenAction;
    private ActionFeature lastScreenAction;
    private ActionFeature previousScreenAction;
    private ActionFeature nextScreenAction;
    private ListFeature<ScreenInfo> screenListFeature;
    private ActionFeature gotoScreenFeature;
    private ValueFeature<ScreenInfo> selectedScreenFeature;
    private I18n i18n = I18n.create((Object)this);
    private BooleanFeature explorerFeature;
    private BooleanFeature followFeature;
    private ExplorerEnabledClerk explorerClerk;
    private FeatureBroker fb;
    private boolean wasChair;
    private Long returnScreenUID;
    private boolean wasExploring = false;
    private boolean wasFollowing = true;
    private boolean wasBreakoutRoom;
    private MetaDataListener followCheckboxListener;
    private Object followLock = new Object();
    private boolean followIsBeingModified = false;
    private boolean settingFollowExternally = false;

    public ScreenNavigator(WhiteboardContext whiteboardContext, FeatureBroker fb, ExplorerEnabledClerk explorerEnabledClerk) {
        this.context = whiteboardContext;
        this.controllerPane = (ControllerPane)this.context.getController();
        this.enabledClerk = new NavigationEnabledClerk(this.context);
        this.explorerClerk = explorerEnabledClerk;
        this.positionClerk = new PostionOfCurrentScreenClerk(fb);
        this.fb = fb;
        String name = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_PREVSCREENNAME);
        String desc = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_PREVSCREENDESC);
        this.previousScreenAction = fb.createActionFeature((Object)this, "/whiteboard/ui/menu/prevScreen", name, desc);
        this.previousScreenAction.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_PREVICON_DEFAULT));
        this.previousScreenAction.setDisabledIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_PREVICON_DISABLED));
        this.previousScreenAction.setRolloverIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_PREVICON_ROLLOVER));
        this.previousScreenAction.setPressedIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_PREVICON_PRESS));
        this.previousScreenAction.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ScreenNavigator.this.goToPreviousScreen();
            }
        });
        name = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_FIRSTSCREENNAME);
        desc = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_FIRSTSCREENDESC);
        this.firstScreenAction = fb.createActionFeature((Object)this, "/whiteboard/ui/menu/firstScreen", name, desc);
        this.firstScreenAction.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ScreenNavigator.this.goToFirstScreen();
            }
        });
        name = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_LASTSCREENNAME);
        desc = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_LASTSCREENDESC);
        this.lastScreenAction = fb.createActionFeature((Object)this, "/whiteboard/ui/menu/lastScreen", name, desc);
        this.lastScreenAction.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ScreenNavigator.this.goToLastScreen();
            }
        });
        name = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_NEXTSCREENNAME);
        desc = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_NEXTSCREENDESC);
        this.nextScreenAction = fb.createActionFeature((Object)this, "/whiteboard/ui/menu/nextScreen", name, desc);
        this.nextScreenAction.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_NEXTICON_DEFAULT));
        this.nextScreenAction.setDisabledIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_NEXTICON_DISABLED));
        this.nextScreenAction.setRolloverIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_NEXTICON_ROLLOVER));
        this.nextScreenAction.setPressedIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_NEXTICON_PRESS));
        this.nextScreenAction.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ScreenNavigator.this.goToNextScreen();
            }
        });
        this.screenListFeature = fb.createListFeature((Object)this, "/whiteboard/navigation/screenlist", ScreenInfo.class, new LinkedList(), "ScreenList", null);
        fb.setFeaturePublished(this.screenListFeature, this.context.isChair());
        this.gotoScreenFeature = fb.createActionFeature((Object)this, "/whiteboard/navigation/gotoScreen", "gotoScreenAction", "used by the screen list combo box");
        this.gotoScreenFeature.addActionFeatureListener(this.createGotoListener());
        fb.setFeaturePublished((Feature)this.gotoScreenFeature, this.context.isChair());
        this.selectedScreenFeature = fb.createValueFeature((Object)this, "/whiteboard/navigation/selectedScreen", false, (Object)new ScreenInfo(Long.valueOf(0L), ""), "selectedScreenFeature", "used by screen list combo box");
        fb.addFeature(this.selectedScreenFeature);
        name = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_EXPLORERNAME);
        desc = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_EXPLORERDESC);
        this.explorerFeature = fb.createBooleanFeature((Object)this, "/whiteboard/ui/menu/explorer", true, this.explorerClerk.isExplorerSelected(), name, desc);
        this.explorerFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean newValue = Boolean.parseBoolean(ev.getNewValue().toString());
                ScreenNavigator.this.explorerClerk.setExplorerSelected(newValue);
                ScreenNavigator.this.manageExploring();
            }
        });
        this.explorerFeature.setPressedIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_EXPLORER_PRESS));
        this.explorerFeature.setRolloverFalseIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_EXPLORER_ROLLOVER));
        this.explorerFeature.setRolloverTrueIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_EXPLORER_PRESS));
        this.explorerFeature.setFalseIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_EXPLORER_DEFAULT));
        this.explorerFeature.setTrueIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_EXPLORER_PRESS));
        this.explorerFeature.setDisabledTrueIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_EXPLORER_DISABLED));
        this.followCheckboxListener = new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean newValue = Boolean.parseBoolean(ev.getNewValue().toString());
                ScreenNavigator.this.manageFollowing(newValue);
            }
        };
        name = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_FOLLOWMODERATORNAME, new Object[]{LabelProps.get((PropertyAccessAPI)this.context.getClientList(), (String)"Label.moderator")});
        desc = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_FOLLOWMODERATORDESC, new Object[]{LabelProps.get((PropertyAccessAPI)this.context.getClientList(), (String)"Label.participants"), LabelProps.get((PropertyAccessAPI)this.context.getClientList(), (String)"Label.moderator")});
        this.followFeature = fb.createBooleanFeature((Object)this, "/whiteboard/ui/menu/follow", true, this.isFollowing(), name, desc);
        this.followFeature.addValueChangeListener(this.followCheckboxListener);
        this.followFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_FOLLOWMODERATORLABEL));
        this.followFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.SCREENNAVIGATOR_FOLLOWMODERATORLABEL));
        this.context.getClientList().addGroupPropertyChangeListener(this.createGroupListener());
        this.context.getDataModel().addDataModelListener(this.createDataModelListener());
        this.context.getChairManager().addChairListener(this.createChairListener());
    }

    private ActionFeatureListener createGotoListener() {
        return new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ScreenNavigator.this.gotoScreen((ScreenInfo)event.getUserData());
            }
        };
    }

    public void gotoScreen(ScreenInfo si) {
        this.context.getController().gotoUIScreen(Long.valueOf(si.getObjectId()), false);
        if (this.currentScreen != null) {
            this.selectedScreenFeature.setValue((Object)this.createScreenInfo(this.currentScreen, ""));
        }
    }

    public void setCurrentScreen(ScreenModel screen) {
        this.currentScreen = screen;
        this.nextScreen = null;
        this.previousScreen = null;
        this.enableFeatures();
    }

    public void goToFirstScreen() {
        Long firstUID = null;
        Long chosenUID = null;
        if (this.currentScreen instanceof ScreenRoot) {
            return;
        }
        ScreenModel parent = (ScreenModel)this.currentScreen.getParent();
        if (parent != null) {
            Iterator iter = parent.iterateScreens();
            while (iter.hasNext()) {
                WBNode node = (WBNode)iter.next();
                if (firstUID == null) {
                    firstUID = node.getObjectID();
                }
                if (!(node instanceof ScreenModel)) continue;
                chosenUID = node.getObjectID();
                break;
            }
        }
        this.context.getController().gotoUIScreen(chosenUID, false);
        if (!firstUID.equals(chosenUID)) {
            this.context.getController().gotoUIScreen(firstUID, false);
        }
    }

    public void goToPreviousScreen() {
        this.context.getController().gotoUIScreen(this.getPreviousScreen().getObjectID(), false);
    }

    public void goToNextScreen() {
        this.context.getController().gotoUIScreen(this.getNextScreen().getObjectID(), false);
    }

    public ScreenModel getCurrentScreen() {
        return this.currentScreen;
    }

    public void goToLastScreen() {
        Long lastUID = null;
        Long chosenUID = null;
        ScreenModel parent = (ScreenModel)this.currentScreen.getParent();
        if (parent != null) {
            Iterator iter = parent.iterateScreens();
            while (iter.hasNext()) {
                WBNode node = (WBNode)iter.next();
                lastUID = node.getObjectID();
                if (!(node instanceof ScreenModel)) continue;
                chosenUID = node.getObjectID();
            }
        }
        this.context.getController().gotoUIScreen(lastUID, false);
    }

    public ScreenModel getPreviousScreen() {
        WBNode result = null;
        WBNode boardParent = this.currentScreen.getBoardParent();
        if (boardParent != null) {
            int index = this.currentScreen.getIndex();
            for (int leftIndex = index - 1; leftIndex >= 0; --leftIndex) {
                result = boardParent.getChildAt(leftIndex);
                if (!(result instanceof ScreenModel)) continue;
                this.previousScreen = (ScreenModel)result;
                return this.previousScreen;
            }
        }
        return null;
    }

    public ScreenModel getNextScreen() {
        WBNode result = null;
        WBNode boardParent = this.currentScreen.getBoardParent();
        if (boardParent != null) {
            int index = this.currentScreen.getIndex();
            for (int rightIndex = index + 1; rightIndex < boardParent.getChildCount(); ++rightIndex) {
                result = boardParent.getChildAt(rightIndex);
                if (!(result instanceof ScreenModel)) continue;
                this.nextScreen = (ScreenModel)result;
                return this.nextScreen;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableFeatures() {
        short groupId = this.context.getClientList().getMyGroupID();
        boolean isBreakoutRoom = groupId != 0;
        this.enableNavigation(this.isChair() || !this.isFollowing());
        Object object = this.followLock;
        synchronized (object) {
            this.settingFollowExternally = true;
            this.setFollowFeatureValue(this.isFollowing());
            this.settingFollowExternally = false;
        }
        if (this.wasChair && !this.isChair() || this.wasBreakoutRoom && !isBreakoutRoom) {
            this.explorerFeature.setValue((Object)false);
        }
        this.fb.setFeaturePublished((Feature)this.explorerFeature, this.isChair());
        this.fb.setFeaturePublished((Feature)this.followFeature, this.isChair());
        this.enabledClerk.setBreakoutRoom(isBreakoutRoom);
        this.wasChair = this.isChair();
        this.wasBreakoutRoom = isBreakoutRoom;
    }

    private WhiteboardChairListener createChairListener() {
        return new WhiteboardChairListener(){

            public void onWhiteboardChairChange(Short clientId, Short jinxAddress, boolean add) {
                if (ScreenNavigator.this.context.getIDProcessor().isLocalClient(clientId)) {
                    if (!ScreenNavigator.this.context.getController().getScreen().isVisible()) {
                        ScreenNavigator.this.context.gotoScreen(ScreenNavigator.this.context.getGroupManager().getGroupInfo().getScreenUID(), true);
                    }
                    ScreenNavigator.this.publishScreenList();
                }
                ScreenNavigator.this.enableFeatures();
            }
        };
    }

    private PropertyChangeListener createGroupListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ScreenNavigator.this.enableFeatures();
            }
        };
    }

    public void evaluateVisible(ACLList aclList) {
        if (aclList instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)aclList;
            if (this.isScreenInScreenList(screen)) {
                if (!screen.isVisible()) {
                    this.publishScreenList();
                }
            } else if (screen.isVisible()) {
                this.publishScreenList();
            }
        }
    }

    private boolean isScreenInScreenList(ScreenModel screen) {
        return false;
    }

    private DataModelListener createDataModelListener() {
        return new DataModelListener(){

            public void nodeAdded(WBNode addedNode, WBNode parentNode) {
                if (!addedNode.isConferenceNode()) {
                    return;
                }
                if (addedNode instanceof ScreenModel) {
                    ScreenNavigator.this.publishScreenList();
                }
                ScreenNavigator.this.processDeferredGoTo();
                ScreenNavigator.this.enableFeatures();
            }

            public void nodeRemoved(WBNode removedNode, int removedIndex, WBNode parentNode) {
                ScreenModel gotoTarget = null;
                Long pending = null;
                if (!(removedNode instanceof ScreenModel)) {
                    return;
                }
                ScreenNavigator.this.publishScreenList();
                if (!ActionUtilities.isUIDInScreen((Long)ScreenNavigator.this.currentScreen.getObjectID(), (WBNode)removedNode)) {
                    ScreenNavigator.this.enableFeatures();
                    return;
                }
                if (parentNode.getRoot() != null && parentNode.getParent() != null || parentNode instanceof ScreenGroups) {
                    pending = ScreenNavigator.this.context.getController().getPendingScreenUID();
                    gotoTarget = ActionUtilities.getGotoTarget((WBNode[])new WBNode[]{removedNode}, (int)removedIndex, (WBNode)parentNode, (Long)ScreenNavigator.this.currentScreen.getObjectID());
                    if (gotoTarget != ScreenNavigator.this.currentScreen && (parentNode.getRoot() != null && parentNode.getParent() != null || parentNode instanceof ScreenGroups) && gotoTarget != null) {
                        boolean roaming = ScreenNavigator.this.controllerPane.isExplorerSelected();
                        ScreenNavigator.this.controllerPane.setExplorer(false);
                        ScreenNavigator.this.controllerPane.gotoConferenceScreen(gotoTarget.getObjectID());
                        ScreenNavigator.this.publishScreenList();
                        if (roaming) {
                            ScreenNavigator.this.controllerPane.setExplorer(true);
                        }
                    }
                    if (pending != null) {
                        ScreenNavigator.this.controllerPane.setPendingScreenUID(pending);
                    }
                }
                ScreenNavigator.this.enableFeatures();
            }
        };
    }

    private void processDeferredGoTo() {
        Long pendingGoToNodeID = this.context.getController().getPendingScreenUID();
        if (pendingGoToNodeID != null) {
            try {
                RegisteredTemplate template = (RegisteredTemplate)this.context.getObjectManager().getObjectFromMap(pendingGoToNodeID);
                if (template instanceof ScreenModel) {
                    this.controllerPane.onGotoScreen(((ScreenModel)template).getObjectID());
                    this.publishScreenList();
                    this.enableFeatures();
                }
            }
            catch (Exception exception) {}
        } else if (this.currentScreen instanceof ScreenRoot && this.currentScreen.getScreenDelegate() instanceof ScreenModel) {
            this.controllerPane.onGotoScreen(this.currentScreen.getScreenDelegate().getObjectID());
            this.publishScreenList();
            this.enableFeatures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishScreenList() {
        LinkedList screens = new LinkedList();
        Iterator iter = this.context.getDataModel().getRoot().iterateScreens();
        while (iter.hasNext()) {
            screens.add(iter.next());
        }
        Collections.sort(screens);
        LinkedList<ScreenInfo> newScreenList = new LinkedList<ScreenInfo>();
        for (Object object : screens) {
            ScreenModel sm;
            if (!(object instanceof ScreenModel) || !(sm = (ScreenModel)object).isVisible()) continue;
            newScreenList.add(this.createScreenInfo(object, ""));
            this.addChildren(newScreenList, sm);
        }
        this.screenListFeature.assign(newScreenList);
        this.selectedScreenFeature.setValue((Object)this.createScreenInfo(this.currentScreen, ""));
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.positionClerk.updatePositionOf(this.currentScreen);
        }
    }

    private void addChildren(List<ScreenInfo> newScreenList, ScreenModel sm) {
        int size = sm.getScreenCount();
        for (int i = 0; i < size; ++i) {
            Object object = sm.getScreenAt(i);
            if (!(object instanceof ScreenModel)) continue;
            newScreenList.add(this.createScreenInfo(sm.getScreenAt(i), "    "));
        }
    }

    private ScreenInfo createScreenInfo(Object object, String prefix) {
        ScreenModel screen = (ScreenModel)object;
        return new ScreenInfo(screen.getObjectID(), prefix + screen.getDisplayName());
    }

    public void enablePositionOfText(boolean showPositionOfText) {
        this.positionClerk.setEnabled(showPositionOfText);
    }

    public void setEnabled(boolean enabled) {
        this.enabledClerk.setEnabled(enabled);
    }

    public void setWhiteboardAccessible(boolean whiteboardAccessible) {
        this.enabledClerk.setWhiteboardAcessible(whiteboardAccessible);
    }

    public void evaluateScreenChange() {
        if (this.currentScreen instanceof ScreenRoot) {
            this.controllerPane.onGotoScreen(this.currentScreen.getObjectID());
        } else {
            this.enableFeatures();
        }
    }

    public void enableNavigation(boolean navEnabled) {
        this.enabledClerk.enableNavigation(navEnabled);
        this.previousScreenAction.setEnabled(this.hasPreviousScreen() && navEnabled);
        this.nextScreenAction.setEnabled(this.hasNextScreen() && navEnabled);
        this.screenListFeature.setEnabled(navEnabled);
        this.gotoScreenFeature.setEnabled(navEnabled);
        if (navEnabled && this.nextScreenAction != null && !this.nextScreenAction.isPublished()) {
            this.fb.setFeaturePublished((Feature)this.nextScreenAction, true);
        }
        if (navEnabled && this.previousScreenAction != null && !this.previousScreenAction.isPublished()) {
            this.fb.setFeaturePublished((Feature)this.previousScreenAction, true);
        }
        if (navEnabled && this.screenListFeature != null && !this.screenListFeature.isPublished()) {
            this.fb.setFeaturePublished(this.screenListFeature, true);
        }
        if (navEnabled && this.gotoScreenFeature != null && !this.gotoScreenFeature.isPublished()) {
            this.fb.setFeaturePublished((Feature)this.gotoScreenFeature, true);
        }
        if (!navEnabled) {
            this.fb.setFeaturePublished((Feature)this.nextScreenAction, false);
            this.fb.setFeaturePublished((Feature)this.previousScreenAction, false);
            this.fb.setFeaturePublished(this.screenListFeature, false);
            this.fb.setFeaturePublished((Feature)this.gotoScreenFeature, false);
        }
        if (navEnabled) {
            this.publishScreenList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNextScreen() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.positionClerk.updatePositionOf(this.currentScreen);
            if (this.currentScreen != null) {
                this.nextScreen = this.getNextScreen();
                return this.nextScreen != null;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPreviousScreen() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.positionClerk.updatePositionOf(this.currentScreen);
            if (this.currentScreen != null) {
                this.previousScreen = this.getPreviousScreen();
                return this.previousScreen != null;
            }
            return false;
        }
    }

    private void manageExploring() {
        if (!this.explorerClerk.isExplorerSelected()) {
            if (this.wasExploring && this.returnScreenUID != null) {
                this.controllerPane.onGotoScreen(this.returnScreenUID);
            }
        } else if (!this.wasExploring && !this.controllerPane.getScreen().isPrivate()) {
            this.returnScreenUID = this.controllerPane.getScreen().getObjectID();
        }
        this.wasExploring = this.explorerClerk.isExplorerSelected();
        this.controllerPane.setAnnunciateState();
    }

    private void manageFollowing(boolean newValue) {
        Short groupId = this.context.getIDProcessor().getMyGroupId();
        if (newValue != this.wasFollowing && !this.settingFollowExternally) {
            if (newValue) {
                this.returnScreenUID = this.controllerPane.getScreen().getObjectID();
                this.context.getGroupManager().setFollowInstructor(groupId, this.controllerPane.getScreen().getObjectID());
                if (!this.wasFollowing && this.returnScreenUID != null) {
                    this.controllerPane.onGotoScreen(this.returnScreenUID);
                }
            } else {
                this.context.getGroupManager().clearFollowInstructor(groupId);
                if (this.wasFollowing && !this.controllerPane.getScreen().isPrivate()) {
                    this.returnScreenUID = this.controllerPane.getScreen().getObjectID();
                }
            }
            this.controllerPane.sendFollowInstructor(groupId, newValue, this.controllerPane.getScreen().getObjectID());
        }
        this.wasFollowing = newValue;
        this.controllerPane.setAnnunciateState();
    }

    private boolean isChair() {
        return this.context.isChair();
    }

    public boolean isBreakoutRoom() {
        return this.enabledClerk.isBreakoutRoom();
    }

    private boolean isFollowing() {
        return this.controllerPane.isFollowInstructorSelected() && this.controllerPane.getScreen().getRoot() != null && this.controllerPane.getScreen().getRoot().getGroupID() == this.context.getIDProcessor().getMyGroupId().shortValue() && !this.controllerPane.getScreen().isPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFollowFeatureExternally(boolean on) {
        Object object = this.followLock;
        synchronized (object) {
            this.settingFollowExternally = true;
            this.setFollowFeatureValue(on);
            this.settingFollowExternally = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFollowFeatureValue(boolean on) {
        Object object = this.followLock;
        synchronized (object) {
            if (this.followFeature != null && (Boolean)this.followFeature.getValue() != on && !this.followIsBeingModified) {
                this.followIsBeingModified = true;
                this.followFeature.setValue((Object)on);
                this.followIsBeingModified = false;
            }
        }
    }

    public void setReturnScreenUID(Long uid) {
        this.returnScreenUID = uid;
    }
}

