/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.navigation;

import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.module.navigation.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;

public class PostionOfCurrentScreenClerk {
    private I18n i18n = I18n.create((Object)this);
    private FeatureBroker broker;
    private StringFeature positionFeature;

    public PostionOfCurrentScreenClerk(FeatureBroker fb) {
        this.broker = fb;
        String name = this.i18n.getString((PropertiesEnum)StringsProperties.POSITIONOFSCREENCLERK_POSITIONNAME);
        String tip = this.i18n.getString((PropertiesEnum)StringsProperties.POSITIONOFSCREENCLERK_POSITIONTIP);
        this.positionFeature = fb.createStringFeature((Object)this, "/whiteboard/navigation/positionOf", false, "", name, tip);
    }

    public void setEnabled(boolean b) {
        this.broker.setFeaturePublished((Feature)this.positionFeature, b);
    }

    public void updatePositionOf(ScreenModel currentScreen) {
        if (this.positionDoesNotApply(currentScreen)) {
            this.positionFeature.setValue((Object)"");
            return;
        }
        this.positionFeature.setValue((Object)(currentScreen.getParent().getPositionInRealScreenCount(currentScreen) + "/" + currentScreen.getParent().getRealScreenCount()));
    }

    private boolean positionDoesNotApply(ScreenModel currentScreen) {
        return currentScreen == null || currentScreen.getParent() == null || currentScreen instanceof ScreenRoot;
    }
}

