/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.PropertyTableEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

class PropertyTableModel
extends AbstractTableModel {
    static final int KEY_COLUMN = 0;
    static final int TEXT_COLUMN = 1;
    static final int NUMBER_OF_COLUMNS = 2;
    private I18n i18n = I18n.create((Object)this);
    private ArrayList propertyList = new ArrayList();
    private String title = "title";
    private WBImage.PaletteType paletteType = WBImage.PaletteType.CLIPART;
    private long memoryUsed = 0L;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public WBImage.PaletteType getPaletteType() {
        return this.paletteType;
    }

    public void setPaletteType(WBImage.PaletteType paletteType) {
        this.paletteType = paletteType;
    }

    @Override
    public int getRowCount() {
        return this.propertyList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        PropertyTableEntry entry = (PropertyTableEntry)this.propertyList.get(row);
        switch (column) {
            case 0: {
                return entry.getKey().replace('/', ' ');
            }
            case 1: {
                return entry.getText();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYTABLEMODEL_FILE);
            }
            case 1: {
                return this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYTABLEMODEL_TEXT);
            }
        }
        return this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYTABLEMODEL_UNKNOWN);
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (column != 1 || row < 0 || row >= this.getRowCount()) {
            return;
        }
        PropertyTableEntry entry = (PropertyTableEntry)this.propertyList.get(row);
        if (aValue instanceof String) {
            String value = (String)aValue;
            entry.setText(value);
        }
    }

    public Properties createProperties() {
        StringBuffer order = new StringBuffer();
        Properties properties = new Properties();
        properties.put("paletteTitle", this.getTitle());
        properties.put("paletteType", this.getPaletteType().toString());
        Iterator iter = this.propertyList.iterator();
        while (iter.hasNext()) {
            PropertyTableEntry entry = (PropertyTableEntry)iter.next();
            properties.put(entry.getKey().replace(' ', '/'), entry.getText());
            order.append(entry.getData().getSuffixedFileName());
            if (!iter.hasNext()) continue;
            order.append(",");
        }
        properties.put("paletteOrder", order.toString());
        return properties;
    }

    public boolean contains(String key) {
        return this.getEntry(key) != null;
    }

    public PropertyTableEntry getEntry(int row) {
        if (row < 0 || row >= this.propertyList.size()) {
            return null;
        }
        return (PropertyTableEntry)this.propertyList.get(row);
    }

    public PropertyTableEntry getEntry(String key) {
        for (int i = 0; i < this.propertyList.size(); ++i) {
            PropertyTableEntry entry = (PropertyTableEntry)this.propertyList.get(i);
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    public boolean addEntry(ImageData data, Component hostComponent) throws Exception {
        return this.addEntry(data, this.propertyList.size(), hostComponent);
    }

    public boolean addEntry(ImageData data, int index, Component hostComponent) throws Exception {
        if (data.getImageBytes() != null) {
            if (this.memoryUsed + (long)data.getImageBytes().length > 0x100000L && hostComponent != null) {
                if (ModalDialog.showConfirmDialog((Component)hostComponent, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_ADDIMAGEEXCEEDS, new Object[]{data.getPathname(), new Long(data.getImageBytes().length), new Long(0x100000L)}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_ADDIMAGEEXCEEDSTITLE), (int)2) == 2) {
                    throw new Exception("addEntry canceled by user");
                }
                return false;
            }
            this.memoryUsed += (long)data.getImageBytes().length;
        }
        if (this.contains(data.getName())) {
            throw new RuntimeException(this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYTABLEMODEL_DUPLICATE, new Object[]{data.getName()}));
        }
        this.propertyList.add(index, new PropertyTableEntry(data));
        this.fireTableChanged(new TableModelEvent(this));
        return true;
    }

    public ImageData deleteEntry(String key) {
        Iterator iter = this.propertyList.iterator();
        while (iter.hasNext()) {
            PropertyTableEntry entry = (PropertyTableEntry)iter.next();
            if (!entry.getKey().equals(key)) continue;
            if (entry.getData().getImageBytes() != null) {
                this.memoryUsed -= (long)entry.getData().getImageBytes().length;
            }
            iter.remove();
            this.fireTableChanged(new TableModelEvent(this));
            return entry.getData();
        }
        throw new RuntimeException(this.i18n.getString((PropertiesEnum)StringsProperties.PROPERTYTABLEMODEL_NOENTRY, new Object[]{key}));
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    public void loadPaletteEntry(PaletteEntry palette, Component hostComponent) {
        this.setTitle(palette.getLocalizedPaletteTitle());
        this.setPaletteType(palette.getLocalizedType());
        Iterator iter = palette.imageDataIterator();
        boolean running = true;
        while (running && iter.hasNext()) {
            ImageData imageData = (ImageData)iter.next();
            try {
                if (this.addEntry(imageData, hostComponent)) continue;
                imageData = null;
            }
            catch (Exception e) {
                running = false;
            }
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public Iterator iterator() {
        return this.propertyList.iterator();
    }
}

