/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.module.imageloading.AddResult;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;

public class PaletteEntry
implements Cloneable {
    private static I18n i18n = I18n.create(PaletteEntry.class);
    public static final String PALETTE_ORDER_KEY = "paletteOrder";
    public static final String PALETTE_TITLE_KEY = "paletteTitle";
    public static final String PALETTE_TYPE_KEY = "paletteType";
    public static final String PALETTE_SORT_PRIORITY_KEY = "standardPaletteSortPriority";
    private static Locale BASE_LOCALE = Locale.ENGLISH;
    private String packageName = null;
    private Map<String, Properties> localeProperties = new HashMap<String, Properties>();
    private boolean editable = false;
    private boolean visible = true;
    private HashMap<String, ImageData> imageMap = new HashMap();
    private List<String> fileList = new LinkedList<String>();
    private long memoryUsed = 0L;
    private JComponent hostPane;

    public PaletteEntry(String packageName) {
        this.packageName = packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(Locale locale, Properties properties) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        List<String> localeEntries = this.getLocaleIdentifiers(locale);
        Map<String, Properties> map = this.localeProperties;
        synchronized (map) {
            if (properties == null) {
                this.localeProperties.remove(localeEntries.get(0));
            } else {
                this.localeProperties.put(localeEntries.get(0), properties);
            }
            if (locale.getLanguage().equals(BASE_LOCALE.getLanguage())) {
                this.localeProperties.put(locale.getLanguage(), properties);
                this.populateFileList();
            }
        }
    }

    public void addProperties(Properties properties) {
        this.addProperties(Locale.getDefault(), properties);
    }

    public void addBaseProperties(Properties properties) {
        this.addProperties(Locale.ENGLISH, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFileList() {
        List<String> list = this.fileList;
        synchronized (list) {
            Properties props = this.getLocalizedProperties(BASE_LOCALE);
            if (props != null) {
                String[] imageEntries;
                String imageOrder = props.getProperty(PALETTE_ORDER_KEY, "");
                for (String image : imageEntries = imageOrder.split(",")) {
                    this.fileList.add(image);
                }
            }
        }
    }

    public List<String> getLocaleIdentifiers(Locale locale) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (!locale.getCountry().equals("")) {
            identifiers.add(locale.getLanguage() + "_" + locale.getCountry());
        }
        identifiers.add(locale.getLanguage());
        return identifiers;
    }

    public AddResult addImage(ImageData data) {
        String name;
        boolean added = false;
        boolean stop = false;
        if (data == null) {
            return new AddResult(false, false);
        }
        if (data.getImageBytes() != null && this.memoryUsed + (long)data.getImageBytes().length > 0x100000L) {
            return new AddResult(added, true, true);
        }
        String translatedName = name = data.getSuffixedFileName();
        try {
            Properties props = this.getLocalizedProperties(Locale.getDefault());
            if (props != null) {
                translatedName = props.getProperty(name, "");
            }
            if (translatedName.equals("")) {
                translatedName = props.getProperty(data.getName(), data.getName());
            }
        }
        catch (Exception e) {
            LogSupport.error((String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_CANNOTTRANSLATE, new Object[]{name, this.packageName}));
        }
        if (this.imageMap.containsKey(data.getSuffixedFileName())) {
            return new AddResult(added, true);
        }
        data.setToolTipString(translatedName);
        this.imageMap.put(data.getSuffixedFileName(), data);
        if (!this.fileList.contains(data.getSuffixedFileName())) {
            this.fileList.add(data.getSuffixedFileName());
        }
        if (data.getImageBytes() != null) {
            this.memoryUsed += (long)data.getImageBytes().length;
        }
        added = true;
        data.setPaletteType(this.getLocalizedType());
        return new AddResult(added, stop);
    }

    public String getLocalizedPaletteTitle() {
        return this.getLocalizedPaletteTitle(null);
    }

    public String getLocalizedPaletteTitle(String defaultValue) {
        Properties props = this.getLocalizedProperties(Locale.getDefault());
        if (props != null) {
            return props.getProperty(PALETTE_TITLE_KEY, defaultValue);
        }
        return defaultValue;
    }

    public String getLocalizedPaletteSortPriority(String defaultValue) {
        Properties props = this.getLocalizedProperties(Locale.getDefault());
        if (props != null) {
            return props.getProperty(PALETTE_SORT_PRIORITY_KEY, defaultValue);
        }
        return defaultValue;
    }

    protected WBImage.PaletteType getLocalizedType() {
        String type;
        Properties props = this.getLocalizedProperties(Locale.getDefault());
        if (props != null && (type = props.getProperty(PALETTE_TYPE_KEY)) != null) {
            for (WBImage.PaletteType hint : WBImage.PaletteType.values()) {
                if (!String.valueOf(hint).equalsIgnoreCase(type)) continue;
                return hint;
            }
        }
        return WBImage.PaletteType.CLIPART;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getLocalizedProperties(Locale locale) {
        Map<String, Properties> map = this.localeProperties;
        synchronized (map) {
            if (this.localeProperties.containsKey(locale.getLanguage() + "_" + locale.getCountry())) {
                return this.localeProperties.get(locale.getLanguage() + "_" + locale.getCountry());
            }
            if (this.localeProperties.containsKey(locale.getLanguage())) {
                return this.localeProperties.get(locale.getLanguage());
            }
            return this.localeProperties.get(BASE_LOCALE.getLanguage());
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    public Iterator imageDataIterator() {
        return new ImageIterator();
    }

    public boolean isEmpty() {
        return this.imageMap.isEmpty();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PaletteEntry: packageTitle: " + this.getLocalizedPaletteTitle());
        buf.append(", packageName: " + this.packageName + " visible=" + this.visible + ",editable=" + this.editable);
        Iterator<Map.Entry<String, ImageData>> iter = this.imageMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ImageData> entry = iter.next();
            buf.append("\n    key: " + entry.getKey() + ", " + entry.getValue());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        PaletteEntry newPaletteEntry = (PaletteEntry)super.clone();
        newPaletteEntry.localeProperties = new HashMap<String, Properties>();
        newPaletteEntry.imageMap = new HashMap();
        newPaletteEntry.fileList = new LinkedList<String>();
        for (String key : this.localeProperties.keySet()) {
            newPaletteEntry.localeProperties.put(key, this.localeProperties.get(key));
        }
        Iterator<String> iter = this.imageDataIterator();
        boolean running = true;
        while (running && iter.hasNext()) {
            ImageData imageData = (ImageData)((Object)iter.next());
            AddResult addResult = newPaletteEntry.addImage((ImageData)imageData.clone());
            running = !addResult.isStop();
        }
        iter = this.fileList.iterator();
        while (iter.hasNext()) {
            newPaletteEntry.fileList.add(iter.next());
        }
        newPaletteEntry.packageName = this.packageName;
        return newPaletteEntry;
    }

    class ImageIterator
    implements Iterator {
        private Iterator realIterator = null;
        private String realKey = null;
        private String iteratorKey = null;

        public ImageIterator() {
            this.realIterator = PaletteEntry.this.fileList.iterator();
        }

        public Object next() {
            if (this.hasNext()) {
                Object result = PaletteEntry.this.imageMap.get(this.realKey);
                this.iteratorKey = this.realKey;
                this.realKey = null;
                return result;
            }
            this.iteratorKey = (String)this.realIterator.next();
            return this.iteratorKey;
        }

        @Override
        public boolean hasNext() {
            if (this.realKey != null) {
                return true;
            }
            while (this.realIterator.hasNext()) {
                this.realKey = (String)this.realIterator.next();
                if (!PaletteEntry.this.imageMap.containsKey(this.realKey)) continue;
                return true;
            }
            this.realKey = null;
            return false;
        }

        @Override
        public void remove() {
            this.realIterator.remove();
            PaletteEntry.this.imageMap.remove(this.iteratorKey);
            this.realKey = null;
        }
    }
}

