/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageFileFilter;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteBuilderDialog;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteTypeItem;
import com.elluminate.groupware.whiteboard.module.imageloading.PropertyTableEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.PropertyTableModel;
import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.groupware.whiteboard.module.imageloading.WBImageUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.RollOverButton;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CTable;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class PaletteBuilderPane
extends JPanel
implements DocumentListener,
ListSelectionListener {
    private static final int MAX_COMPRESSION = 9;
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static File defaultDirectory = null;
    private static final int PREVIEW_WIDTH = 200;
    private static final int PREVIEW_HEIGHT = 180;
    private static final String PROMPT_STRING = i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_BLANKTITLE);
    private static final String CLIPART_TYPE = i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_CLIPARTTYPE);
    private static final String BACKGROUND_TYPE = i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_BACKGROUNDTYPE);
    private static final PaletteTypeItem[] PALETTE_TYPES = new PaletteTypeItem[]{new PaletteTypeItem(WBImage.PaletteType.CLIPART, CLIPART_TYPE), new PaletteTypeItem(WBImage.PaletteType.BACKGROUND, BACKGROUND_TYPE)};
    private JLabel paletteTypeLabel = new JLabel();
    private JComboBox paletteTypesList = new JComboBox<PaletteTypeItem>(PALETTE_TYPES);
    private JPanel titlePanel = new JPanel();
    private JLabel titleLabel = new JLabel();
    private JPanel contentPanel = new JPanel();
    private JPanel propertiesPanel = new JPanel();
    private JTextField paletteTitle = null;
    private Document doc = new PlainDocument();
    private JTable propertiesTable = null;
    private JTextField cellEditor = null;
    private PropertyTableModel propertyTableModel = null;
    private PaletteBuilderDialog titleListener = null;
    private JLabel preview;
    private JButton addButton = new RollOverButton();
    private JButton removeButton = new RollOverButton();
    private JButton upButton = new RollOverButton();
    private JButton downButton = new RollOverButton();
    private boolean promptForTitle = false;
    private String titleText = "";
    private boolean suppressUpdate = false;
    private boolean loading = false;
    private WorkerThread iconScalingThread = null;
    FocusAdapter paletteTitleFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PaletteBuilderPane.this.paletteTitle_focusLost(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (PaletteBuilderPane.this.promptForTitle) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PaletteBuilderPane.this.doc.removeDocumentListener(PaletteBuilderPane.this);
                        PaletteBuilderPane.this.titleText = "";
                        PaletteBuilderPane.this.paletteTitle.setText("");
                        PaletteBuilderPane.this.paletteTitle.setBackground(Color.white);
                        PaletteBuilderPane.this.promptForTitle = false;
                        PaletteBuilderPane.this.doc.addDocumentListener(PaletteBuilderPane.this);
                    }
                });
            }
        }
    };
    FocusAdapter cellEditorFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            PaletteBuilderPane.this.cellEditor_focusLost(e);
        }
    };

    public PaletteBuilderPane(PaletteEntry palette, PaletteBuilderDialog titleListener) {
        this.titleListener = titleListener;
        try {
            this.jbInit();
            this.doc.addDocumentListener(this);
            this.loadPalettePane(palette);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"PaletteBuilderPane", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.paletteTitle = new JTextField(this.doc, "", 0);
        this.titlePanel.setLayout(new GridBagLayout());
        this.setLayout(new BorderLayout(0, 6));
        this.titleLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_TITLE));
        this.contentPanel.setLayout(new GridBagLayout());
        this.propertiesPanel.setLayout(new BorderLayout(6, 0));
        this.preview = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.PALLETEBUILDERPANE_NOSELECTION));
        this.preview.setHorizontalAlignment(0);
        this.preview.setVerticalAlignment(0);
        this.preview.setPreferredSize(new Dimension(200, 180));
        this.preview.setBackground(Color.white);
        this.preview.setOpaque(true);
        this.preview.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
        this.propertyTableModel = new PropertyTableModel();
        this.propertiesTable = new CTable((TableModel)this.propertyTableModel);
        this.propertiesTable.setIntercellSpacing(new Dimension(0, 1));
        this.propertiesTable.setShowHorizontalLines(false);
        this.propertiesTable.setShowVerticalLines(false);
        JTableHeader header = this.propertiesTable.getTableHeader();
        TableColumnModel columnModel = this.propertiesTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        header.setResizingAllowed(true);
        header.setReorderingAllowed(false);
        JScrollPane propertiesTableScroller = new JScrollPane(this.propertiesTable, 22, 31);
        propertiesTableScroller.getViewport().setBackground(this.propertiesTable.getBackground());
        propertiesTableScroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PaletteBuilderPane.this.propertiesTable.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PaletteBuilderPane.this.propertiesTable.clearSelection();
            }
        });
        this.propertiesPanel.add((Component)propertiesTableScroller, "Center");
        this.propertiesPanel.add((Component)this.preview, "East");
        this.add((Component)this.propertiesPanel, "Center");
        this.add((Component)this.titlePanel, "North");
        int idx = 0;
        this.titlePanel.add((Component)this.titleLabel, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.titlePanel.add((Component)this.paletteTitle, new GridBagConstraints(idx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 314, 0));
        this.titlePanel.add((Component)this.paletteTypeLabel, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.titlePanel.add((Component)this.paletteTypesList, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.titlePanel.add((Component)this.upButton, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.titlePanel.add((Component)this.downButton, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.titlePanel.add((Component)this.addButton, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.titlePanel.add((Component)this.removeButton, new GridBagConstraints(idx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.add((Component)this.contentPanel, "South");
        this.paletteTypeLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_PALETTETYPE));
        this.paletteTypesList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PaletteTypeItem paletteType = (PaletteTypeItem)cb.getSelectedItem();
                PropertyTableModel model = PaletteBuilderPane.this.getPropertyTableModel();
                model.setPaletteType(paletteType.getType());
            }
        });
        this.upButton.setIcon(i18n.getIcon("PaletteBuilderPane.upButton"));
        this.upButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_UPTIP));
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.setPreferredSize(new Dimension(28, 28));
        this.upButton.setMinimumSize(new Dimension(28, 28));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderPane.this.upButton_actionPerformed(e);
            }
        });
        this.downButton.setIcon(i18n.getIcon("PaletteBuilderPane.downButton"));
        this.downButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_DOWNTIP));
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        this.downButton.setPreferredSize(new Dimension(28, 28));
        this.downButton.setMinimumSize(new Dimension(28, 28));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderPane.this.downButton_actionPerformed(e);
            }
        });
        this.addButton.setIcon(i18n.getIcon("PaletteBuilderPane.addButton"));
        this.addButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_ADDTIP));
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setPreferredSize(new Dimension(28, 28));
        this.addButton.setMinimumSize(new Dimension(28, 28));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderPane.this.browseFile_actionPerformed(e);
            }
        });
        this.removeButton.setIcon(i18n.getIcon("PaletteBuilderPane.removeButton"));
        this.removeButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_REMOVETIP));
        this.removeButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeButton.setPreferredSize(new Dimension(28, 28));
        this.removeButton.setMinimumSize(new Dimension(28, 28));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderPane.this.removeFile_actionPerformed(e);
            }
        });
        this.propertiesTable.getSelectionModel().addListSelectionListener(this);
        DefaultCellEditor editor = (DefaultCellEditor)this.propertiesTable.getDefaultEditor(String.class);
        this.cellEditor = (JTextField)editor.getComponent();
        this.cellEditor.addFocusListener(this.cellEditorFocusListener);
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                int row = PaletteBuilderPane.this.propertiesTable.getSelectedRow();
                PropertyTableEntry entry = PaletteBuilderPane.this.propertyTableModel.getEntry(row);
                ImageData imageData = entry.getData();
                PaletteBuilderPane.this.preview.setToolTipText(imageData.getToolTipString());
                PaletteBuilderPane.this.titleListener.paletteChanged();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.titleListener.enableButtons();
        this.titlePanel.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_TITLETIP));
        this.paletteTitle.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_TITLETIP));
        this.propertiesTable.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_PALETTESTIP));
        this.propertiesPanel.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_PALETTESTIP));
        this.paletteTitle.addFocusListener(this.paletteTitleFocusListener);
        this.setTitle("", false);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.propertiesTable.getSelectionModel().addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.propertiesTable.getSelectionModel().removeListSelectionListener(l);
    }

    public String getTitle() {
        return this.titleText == PROMPT_STRING ? "" : this.titleText;
    }

    public void loadPalettePane(PaletteEntry palette) {
        if (palette != null) {
            this.setTitle(palette.getLocalizedPaletteTitle(), false);
            this.propertyTableModel.loadPaletteEntry(palette, this);
            this.paletteTypesList.setSelectedItem(new PaletteTypeItem(this.propertyTableModel.getPaletteType(), ""));
        }
        this.titleListener.enableButtons();
    }

    private void setTitle(String title, boolean modelChange) {
        SwingRunnerSupport.invokeLater((Runnable)new UpdateTitleRunnable(title, this.suppressUpdate));
    }

    private void fireTitleChanged(String title) {
        if (this.titleListener != null) {
            if (this.promptForTitle) {
                title = "";
            }
            this.titleListener.titleChanged(title, this);
        }
    }

    private void paletteTitle_focusLost(FocusEvent e) {
        this.paletteTitle.removeFocusListener(this.paletteTitleFocusListener);
        if (!this.titleListener.validateDups(true)) {
            this.setTitle("", false);
            this.fireTitleChanged(this.titleText);
            this.titleListener.validateDups(false);
        } else {
            this.setTitle(this.paletteTitle.getText(), false);
        }
        this.paletteTitle.addFocusListener(this.paletteTitleFocusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browseFile_actionPerformed(ActionEvent e) {
        if (defaultDirectory == null) {
            defaultDirectory = Platform.getDefaultDir();
        }
        CFileChooser chooser = new CFileChooser(defaultDirectory);
        chooser.setDialogTitle(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_BROWSETITLE));
        chooser.resetChoosableFileFilters();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        ImageFileFilter filter = new ImageFileFilter();
        filter.addChoosableFileFilter((JFileChooser)chooser, 200, 180);
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(this) == 0) {
            ImportTask task;
            File f;
            File[] files = filter.getFiles();
            if (files.length == 0 && (f = chooser.getSelectedFile()) != null) {
                files = new File[]{f};
            }
            filter.dispose();
            if (files.length == 0) {
                return;
            }
            ImportTask importTask = task = new ImportTask(files);
            synchronized (importTask) {
                boolean startOK = false;
                try {
                    this.titleListener.setEnabled(false);
                    WorkerThread t = new WorkerThread((Runnable)task, "PaletteBuilderImageLoadingThread");
                    t.setDaemon(true);
                    t.start();
                    try {
                        task.wait(5000L);
                    }
                    catch (InterruptedException ix) {
                        // empty catch block
                    }
                }
                finally {
                    if (!task.startedOK()) {
                        this.titleListener.setEnabled(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage2(File file, String url) {
        block21: {
            Image image = null;
            byte[] newBuffer = null;
            try {
                int bytesRead;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                in.close();
                out.close();
                buffer = out.toByteArray();
                image = ImageSupport.loadImage((byte[])buffer, (File)file);
                if (image != null && (long)(image.getHeight(this) * image.getWidth(this)) <= ImageSupport.getMaxPixels()) {
                    String outFileString = file.getName();
                    if (!(Platform.getMimeType((File)file).equals("image/gif") || Platform.getMimeType((File)file).equals("image/jpeg") || Platform.getMimeType((File)file).equals("image/png"))) {
                        Rectangle trimmedArea = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
                        int[] imageArray = ImageSupport.getImageArray((Image)image);
                        newBuffer = ImageSupport.encodeAsPNG((Image)(image = WBImageUtils.clipImage(imageArray, trimmedArea)), (int)9);
                        if (newBuffer.length <= buffer.length) {
                            outFileString = outFileString.substring(0, outFileString.lastIndexOf(".")) + ".png";
                            buffer = newBuffer;
                        }
                    }
                    ImageData data = new ImageData(buffer, outFileString, file.getPath(), url, image);
                    image = null;
                    try {
                        if (this.propertyTableModel.contains(data.getSuffixedFileName())) {
                            data.flushImageData();
                            ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_DUPLICATEENTRY, new Object[]{data.getPathname()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_DUPLICATEENTRYTITLE), (int)0);
                            break block21;
                        }
                        try {
                            if (this.propertyTableModel.addEntry(data, this)) {
                                this.titleListener.paletteChanged();
                                break block21;
                            }
                            data.flushImageData();
                        }
                        catch (Exception e) {
                            this.loading = false;
                            data.flushImageData();
                        }
                        break block21;
                    }
                    catch (RuntimeException re) {
                        if (data != null) {
                            data.flushImageData();
                        }
                        ModalDialog.showMessageDialog((Component)this, (Object)re.getMessage());
                        break block21;
                    }
                    finally {
                        data = null;
                        buffer = null;
                        newBuffer = null;
                        System.gc();
                    }
                }
                if (ModalDialog.showConfirmDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_TOOBIGMESSAGE, new Object[]{file.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALLETTEBUILDERPANE_TOOBIGTITLE), (int)2) == 2) {
                    this.loading = false;
                }
            }
            catch (Exception e) {
                LogSupport.exception((Object)this, (String)"loadImage", (Throwable)e, (boolean)true);
            }
            finally {
                if (image != null) {
                    image.flush();
                }
            }
        }
    }

    private void loadImage(File file, String url) {
        Frame frm = this.titleListener.getParent() instanceof Frame ? (Frame)this.titleListener.getParent() : null;
        LoadDialog loadingDialog = new LoadDialog(frm, i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_IMAGELOADER), file, url);
        loadingDialog.show();
        loadingDialog.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ImageData imageData = null;
        int selectedCount = this.propertiesTable.getSelectedRowCount();
        this.removeButton.setEnabled(selectedCount > 0);
        this.upButton.setEnabled(selectedCount > 0 && this.propertiesTable.getRowCount() != selectedCount);
        this.downButton.setEnabled(selectedCount > 0 && this.propertiesTable.getRowCount() != selectedCount);
        this.titleListener.stateChanged(new ChangeEvent(this));
        if (selectedCount == 1) {
            int row = this.propertiesTable.getSelectedRow();
            PropertyTableEntry entry = this.propertyTableModel.getEntry(row);
            imageData = entry.getData();
        }
        if (imageData == null) {
            this.preview.setIcon(null);
            String text = selectedCount > 1 ? i18n.getString((PropertiesEnum)StringsProperties.PALLETEBUILDERPANE_MANYSELECTION) : i18n.getString((PropertiesEnum)StringsProperties.PALLETEBUILDERPANE_NOSELECTION);
            this.preview.setToolTipText(text);
            this.preview.setText(text);
        } else {
            this.preview.setText("");
            if (imageData.isImageIconSet()) {
                this.preview.setIcon(imageData.getImageIcon(this.preview.getSize().width, this.preview.getSize().height));
            } else {
                this.preview.setIcon(null);
                WorkerThread tmp = this.iconScalingThread;
                if (tmp != null && tmp.isAlive()) {
                    tmp.interrupt();
                }
                final ImageData scaleData = imageData;
                this.iconScalingThread = new WorkerThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            final ImageIcon icon = scaleData.getImageIcon(((PaletteBuilderPane)PaletteBuilderPane.this).preview.getSize().width, ((PaletteBuilderPane)PaletteBuilderPane.this).preview.getSize().height);
                            if (icon == null) {
                                return;
                            }
                            if (Thread.interrupted()) {
                                return;
                            }
                            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    PaletteBuilderPane.this.preview.setText("");
                                    PaletteBuilderPane.this.preview.setIcon(icon);
                                }
                            });
                        }
                        catch (Throwable t) {
                            return;
                        }
                        finally {
                            PaletteBuilderPane.this.iconScalingThread = null;
                        }
                    }
                });
                this.iconScalingThread.setDaemon(true);
                this.iconScalingThread.start();
            }
            this.preview.setToolTipText(imageData.getToolTipString());
        }
    }

    private void downButton_actionPerformed(ActionEvent e) {
        int lastRow = this.propertiesTable.getRowCount() - 1;
        PropertyTableModel model = (PropertyTableModel)this.propertiesTable.getModel();
        int[] selectedRows = this.propertiesTable.getSelectedRows();
        int[] selections = new int[selectedRows.length];
        this.propertiesTable.clearSelection();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            int rowIndex;
            selections[i] = rowIndex = selectedRows[i];
            if (rowIndex < lastRow) {
                if (rowIndex >= lastRow) continue;
                PropertyTableEntry tableEntry = model.getEntry(rowIndex);
                model.deleteEntry(tableEntry.getKey());
                try {
                    model.addEntry(tableEntry.getData(), rowIndex + 1, this);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                selections[i] = rowIndex + 1;
                this.titleListener.paletteChanged();
                continue;
            }
            --lastRow;
        }
        for (int j = 0; j < selections.length; ++j) {
            this.propertiesTable.addRowSelectionInterval(selections[j], selections[j]);
        }
    }

    private void upButton_actionPerformed(ActionEvent e) {
        PropertyTableModel model = (PropertyTableModel)this.propertiesTable.getModel();
        int[] selectedRows = this.propertiesTable.getSelectedRows();
        int[] selections = new int[selectedRows.length];
        int firstRow = 0;
        this.propertiesTable.clearSelection();
        for (int i = 0; i < selectedRows.length; ++i) {
            int rowIndex;
            selections[i] = rowIndex = selectedRows[i];
            if (rowIndex > firstRow) {
                if (rowIndex <= 0) continue;
                PropertyTableEntry tableEntry = model.getEntry(rowIndex);
                model.deleteEntry(tableEntry.getKey());
                try {
                    model.addEntry(tableEntry.getData(), rowIndex - 1, this);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                selections[i] = rowIndex - 1;
                this.titleListener.paletteChanged();
                continue;
            }
            ++firstRow;
        }
        for (int j = 0; j < selections.length; ++j) {
            this.propertiesTable.addRowSelectionInterval(selections[j], selections[j]);
        }
    }

    public boolean isEntrySelected() {
        return this.propertiesTable.getSelectedRowCount() > 0;
    }

    protected void removeFile_actionPerformed(ActionEvent e) {
        StringBuffer files = new StringBuffer();
        int lineLen = 0;
        int[] selectedIndicies = this.propertiesTable.getSelectedRows();
        if (selectedIndicies.length > 0) {
            String[] keys = new String[selectedIndicies.length];
            if (selectedIndicies.length > 1) {
                files.append("\n  ");
                lineLen = 2;
            }
            for (int i = 0; i < selectedIndicies.length; ++i) {
                keys[i] = (String)this.propertyTableModel.getValueAt(selectedIndicies[i], 0);
                if (i > 0) {
                    if (lineLen + keys[i].length() > 128) {
                        files.append("\n  ");
                        lineLen = 2;
                    } else {
                        files.append(", ");
                        lineLen += 2;
                    }
                }
                files.append(keys[i]);
                lineLen += keys[i].length();
            }
            int which = ModalDialog.showConfirmDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_CONFIRM, new Object[]{files.toString()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_CONFIRMTITLE), (int)2);
            if (which == 0) {
                PropertyTableEntry tableEntry = null;
                for (int i = 0; i < keys.length; ++i) {
                    tableEntry = this.propertyTableModel.getEntry(keys[i]);
                    tableEntry.getData().flushImageData();
                    this.propertyTableModel.deleteEntry(keys[i]);
                }
                this.valueChanged(null);
            }
            this.titleListener.paletteChanged();
            System.gc();
        }
    }

    private void updateTitle(DocumentEvent e) {
        final DocumentEvent.EventType type = e.getType();
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PaletteBuilderPane.this.suppressUpdate = true;
                try {
                    try {
                        String text = PaletteBuilderPane.this.doc.getText(0, PaletteBuilderPane.this.doc.getLength());
                        PaletteBuilderPane.this.propertyTableModel.setTitle(text);
                        if (type == DocumentEvent.EventType.REMOVE && text.length() == 0) {
                            PaletteBuilderPane.this.paletteTitle.setText("");
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                    PaletteBuilderPane.this.fireTitleChanged(PaletteBuilderPane.this.propertyTableModel.getTitle());
                    PaletteBuilderPane.this.titleListener.paletteChanged();
                }
                finally {
                    PaletteBuilderPane.this.suppressUpdate = false;
                }
            }
        });
    }

    public PropertyTableModel getPropertyTableModel() {
        return this.propertyTableModel;
    }

    public ImageData getSelectedImageData() {
        int[] indicies = this.propertiesTable.getSelectedRows();
        if (indicies == null || indicies.length != 1) {
            return null;
        }
        if (this.propertyTableModel.getEntry(indicies[0]) == null) {
            return null;
        }
        return this.propertyTableModel.getEntry(indicies[0]).getData();
    }

    private void cellEditor_focusLost(FocusEvent e) {
        this.cellEditor.removeFocusListener(this.cellEditorFocusListener);
        if (this.propertiesTable.isEditing()) {
            int row = this.propertiesTable.getSelectedRow();
            int column = this.propertiesTable.getSelectedColumn();
            this.propertiesTable.getCellEditor(row, column).stopCellEditing();
        }
        this.titleListener.validateDups(true);
        this.cellEditor.addFocusListener(this.cellEditorFocusListener);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTitle(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTitle(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTitle(e);
    }

    class ImportTask
    implements Runnable {
        private boolean started = false;
        private File[] filesToLoad = null;

        ImportTask(File[] files) {
            this.filesToLoad = files;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean startedOK() {
            ImportTask importTask = this;
            synchronized (importTask) {
                return this.started;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String msg = null;
            Cursor oldCursor = null;
            PaletteBuilderPane.this.loading = true;
            try {
                int i;
                ImportTask importTask = this;
                synchronized (importTask) {
                    this.started = true;
                    this.notify();
                }
                int siz = 0;
                for (i = 0; i < this.filesToLoad.length && PaletteBuilderPane.this.loading; ++i) {
                    if (!this.filesToLoad[i].isFile()) continue;
                    siz += (int)this.filesToLoad[i].length();
                }
                PaletteBuilderPane.this.titleListener.progressShow(0, siz);
                oldCursor = PaletteBuilderPane.this.titleListener.getCursor();
                PaletteBuilderPane.this.titleListener.setCursor(Cursor.getPredefinedCursor(3));
                siz = 0;
                for (i = 0; i < this.filesToLoad.length && PaletteBuilderPane.this.loading; ++i) {
                    if (!this.filesToLoad[i].isFile()) continue;
                    msg = i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_LOADINGDIALOG, new Object[]{this.filesToLoad[i].getName(), new Long(this.filesToLoad[i].length())});
                    PaletteBuilderPane.this.titleListener.progressAdvance(siz, msg);
                    defaultDirectory = new File(this.filesToLoad[i].getParent());
                    PaletteBuilderPane.this.loadImage2(this.filesToLoad[i], this.filesToLoad[i].getAbsolutePath());
                    siz += (int)this.filesToLoad[i].length();
                }
                PaletteBuilderPane.this.titleListener.progressHide();
            }
            catch (Throwable throwable) {
                PaletteBuilderPane.this.titleListener.progressHide();
                PaletteBuilderPane.this.titleListener.setEnabled(true);
                if (oldCursor != null) {
                    PaletteBuilderPane.this.titleListener.setCursor(oldCursor);
                }
                PaletteBuilderPane.this.loading = false;
                throw throwable;
            }
            PaletteBuilderPane.this.titleListener.setEnabled(true);
            if (oldCursor != null) {
                PaletteBuilderPane.this.titleListener.setCursor(oldCursor);
            }
            PaletteBuilderPane.this.loading = false;
        }
    }

    class LoadDialog
    extends CDialog {
        File file;
        String url;
        JLabel label;
        boolean hasRun;

        public LoadDialog(Frame owner, String title, File file, String url) {
            super(owner, title, true);
            this.label = new JLabel();
            this.hasRun = false;
            this.file = file;
            this.url = url;
            this.getRootPane().putClientProperty("Window.style", "small");
            JPanel dialogPanel = new JPanel(new GridBagLayout());
            this.getContentPane().add(dialogPanel);
            dialogPanel.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
            this.label.setText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_LOADINGDIALOG, new Object[]{file.getName(), new Long(file.length())}));
            this.pack();
            if (owner != null) {
                int x = owner.getLocation().x + owner.getSize().width / 2 - this.getSize().width / 2;
                int y = owner.getLocation().y + owner.getSize().height / 2 - this.getSize().height / 2;
                this.setLocation(x, y);
            }
        }

        public void show() {
            WorkerThread thread = new WorkerThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block18: {
                        Image image = null;
                        try {
                            byte[] buffer = new byte[(int)LoadDialog.this.file.length()];
                            FileInputStream in = new FileInputStream(LoadDialog.this.file);
                            int bytesRead = in.read(buffer);
                            in.close();
                            image = ImageSupport.loadImage((byte[])buffer, (File)LoadDialog.this.file);
                            if (image != null && (long)(image.getWidth((ImageObserver)((Object)LoadDialog.this)) * image.getHeight((ImageObserver)((Object)LoadDialog.this))) <= ImageSupport.getMaxPixels()) {
                                Rectangle trimmedArea = new Rectangle(0, 0, image.getWidth((ImageObserver)((Object)LoadDialog.this)), image.getHeight((ImageObserver)((Object)LoadDialog.this)));
                                int[] imageArray = ImageSupport.getImageArray((Image)image);
                                image = WBImageUtils.clipImage(imageArray, trimmedArea);
                                byte[] newBuffer = ImageSupport.encodeAsPNG((Image)image, (int)9);
                                String outFileString = LoadDialog.this.file.getName();
                                if (newBuffer.length <= buffer.length) {
                                    outFileString = outFileString.substring(0, outFileString.lastIndexOf(".")) + ".png";
                                    buffer = newBuffer;
                                }
                                ImageData data = new ImageData(buffer, outFileString, LoadDialog.this.file.getPath(), LoadDialog.this.url, image);
                                image = null;
                                try {
                                    if (PaletteBuilderPane.this.propertyTableModel.contains(data.getSuffixedFileName())) {
                                        data.flushImageData();
                                        ModalDialog.showMessageDialog((Component)((Object)LoadDialog.this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_DUPLICATEENTRY, new Object[]{data.getPathname()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_DUPLICATEENTRYTITLE), (int)0);
                                    } else if (PaletteBuilderPane.this.propertyTableModel.addEntry(data, (Component)((Object)LoadDialog.this))) {
                                        PaletteBuilderPane.this.titleListener.paletteChanged();
                                    } else {
                                        data.flushImageData();
                                    }
                                    break block18;
                                }
                                catch (RuntimeException re) {
                                    if (data != null) {
                                        data.flushImageData();
                                    }
                                    ModalDialog.showMessageDialog((Component)((Object)LoadDialog.this), (Object)re.getMessage());
                                    break block18;
                                }
                                finally {
                                    data = null;
                                    buffer = null;
                                    newBuffer = null;
                                    System.gc();
                                }
                            }
                            ModalDialog.showMessageDialog((Component)PaletteBuilderPane.this, (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERPANE_TOOBIGMESSAGE, new Object[]{LoadDialog.this.file.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALLETTEBUILDERPANE_TOOBIGTITLE), (int)0);
                        }
                        catch (Exception e) {
                            LogSupport.exception((Object)this, (String)"loadImage", (Throwable)e, (boolean)true);
                        }
                        finally {
                            if (image != null) {
                                image.flush();
                            }
                            LoadDialog.this.hide();
                            LoadDialog.this.hasRun = true;
                        }
                    }
                }
            }, "PaletteBuilderImageLoadThread");
            this.hasRun = false;
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.start();
            if (!this.hasRun) {
                super.show();
            }
        }
    }

    class UpdateTitleRunnable
    implements Runnable {
        String title;
        boolean suppress;

        public UpdateTitleRunnable(String title, boolean suppress) {
            this.title = title;
            this.suppress = suppress;
            PaletteBuilderPane.this.titleText = title;
            PaletteBuilderPane.this.promptForTitle = title == PROMPT_STRING || title.equals("");
        }

        @Override
        public void run() {
            Color color = Color.white;
            if ("".equals(this.title)) {
                color = Color.pink;
                this.setPaletteTitle(PROMPT_STRING, this.suppress);
            } else {
                this.setPaletteTitle(this.title, this.suppress);
            }
            if (PaletteBuilderPane.this.paletteTitle.getBackground().getRGB() != color.getRGB()) {
                PaletteBuilderPane.this.paletteTitle.setBackground(color);
            }
        }

        private void setPaletteTitle(String title, boolean suppress) {
            if (!PaletteBuilderPane.this.paletteTitle.getText().equals(title)) {
                try {
                    String text = PaletteBuilderPane.this.doc.getText(0, PaletteBuilderPane.this.doc.getLength());
                    if (!text.equals(title)) {
                        PaletteBuilderPane.this.doc.removeDocumentListener(PaletteBuilderPane.this);
                        PaletteBuilderPane.this.paletteTitle.setText(title);
                        PaletteBuilderPane.this.doc.addDocumentListener(PaletteBuilderPane.this);
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
            if (PaletteBuilderPane.this.promptForTitle) {
                PaletteBuilderPane.this.paletteTitle.select(0, PaletteBuilderPane.this.titleText.length());
            } else {
                PaletteBuilderPane.this.paletteTitle.select(0, 0);
            }
        }
    }
}

