/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.tools.MarkableImage;
import com.elluminate.platform.Platform;
import com.elluminate.util.TimedExecution;
import com.elluminate.util.image.gif.AnimationFrame;
import com.elluminate.util.image.gif.AnimationInstance;
import com.elluminate.util.image.gif.GifFile;
import com.elluminate.util.image.gif.ImageObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class ImageSelectionButton
extends JToggleButton
implements MarkableImage {
    private static final boolean IS_MAC = Platform.getOS() == 202;
    private static final boolean MARGINS_OK = !IS_MAC || Platform.checkJavaVersion((String)"1.6+");
    private static final TimedExecution timer = new TimedExecution();
    private ImageData data = null;
    private ImageObject imageObject = null;
    private int width;
    private int height;
    private int x;
    private int y;
    private int frameIndex;
    private boolean animate;
    private AnimationInstance animationInstance = null;
    private Object marker = null;
    private ImageIcon buttonIcon = null;

    ImageSelectionButton() {
        this.imageObject = null;
        this.y = 0;
        this.x = 0;
        this.height = 0;
        this.width = 0;
        this.frameIndex = -1;
        this.animate = false;
    }

    public ImageSelectionButton(ImageData data, int width, int height, String name) {
        this.setIcon(null);
        this.setPreferredSize(new Dimension(width, height));
        this.setToolTipText(data.getToolTipString());
        this.data = data;
        this.frameIndex = 0;
        boolean scaled = false;
        Insets marge = this.getCorrectedMargin();
        int insetW = width - (marge.left + marge.right);
        int insetH = height - (marge.top + marge.bottom);
        int maxWidth = Math.min(insetW - 6, data.getWidth());
        int maxHeight = Math.min(insetH - 6, data.getHeight());
        int w = data.getWidth();
        int h = data.getHeight();
        if (w > maxWidth || h > maxHeight) {
            double scalingFactor = Math.min((double)maxWidth / (double)w, (double)maxHeight / (double)h);
            w = (int)((double)w * scalingFactor + 0.1);
            h = (int)((double)h * scalingFactor + 0.1);
            scaled = true;
        }
        this.x = marge.left + (insetW - w) / 2;
        this.y = marge.top + (insetH - h) / 2;
        this.width = w;
        this.height = h;
        try {
            if (data.getMimeType().equals("image/gif")) {
                this.imageObject = new ImageObject(new GifFile(data.getImageBytes(), name), name);
                this.animate = this.imageObject.getFrameCount() > 1;
                this.animationInstance = new Animation(this.imageObject);
                this.buttonIcon = null;
            } else {
                this.buttonIcon = data.getImageIcon(width, height);
                this.animate = false;
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "ImageSelectionButton#" + this.hashCode() + ": " + this.width + "x" + this.height + " @ " + this.x + "," + this.y + (this.animate ? " animated" : "") + " data=" + this.data;
    }

    public Insets getCorrectedMargin() {
        Insets margin = this.getMargin();
        if (margin != null && margin.left >= 0 && margin.right >= 0 && margin.top >= 0 && margin.bottom >= 0 && margin.left <= 12 && margin.right <= 12 && margin.top <= 12 && margin.bottom <= 12 && (margin.left > 0 || margin.right > 0 || margin.top > 0 || margin.bottom > 0)) {
            return margin;
        }
        margin = IS_MAC ? new Insets(8, 5, 5, 5) : new Insets(5, 5, 5, 5);
        return margin;
    }

    public ImageData getData() {
        return this.data;
    }

    public void flush() {
        if (this.imageObject != null) {
            this.imageObject.flush();
        }
        if (this.data != null) {
            this.data.flushImageData();
        }
    }

    public void mark(String text) {
        String markerText = text;
        this.marker = markerText;
    }

    public void mark(Image marker) {
        this.marker = marker;
    }

    public void clearMark() {
        this.marker = null;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.animationInstance != null || this.buttonIcon != null) {
            if (this.animationInstance != null && this.imageObject != null) {
                if (this.animationInstance.getAnimationFrame(this.imageObject) == null) {
                    return;
                }
                Image img = this.animationInstance.getAnimationFrame(this.imageObject).getImage();
                g.drawImage(img, this.x, this.y, this.width, this.height, this);
                this.animationInstance.imageRendered(this.imageObject);
            } else if (this.buttonIcon != null) {
                g.drawImage(this.buttonIcon.getImage(), this.x, this.y, this.width, this.height, this);
            }
        }
        if (this.marker != null) {
            if (this.marker instanceof String) {
                g.setColor(new Color(16, 128, 16));
                g.fillOval(3, 3, 12, 12);
                g.setColor(Color.WHITE);
                g.drawString((String)this.marker, 4, 13);
            } else {
                g.drawImage((Image)this.marker, 0, 0, null);
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int flgs, int x, int y, int w, int h) {
        long dT = -1L;
        long remaining = this.animationInstance != null ? Math.max(0L, this.animationInstance.getTimeRemaining()) : 100L;
        if ((flgs & 0x30) != 0) {
            dT = 0L;
        } else if ((flgs & 8) != 0) {
            dT = Math.min(100L, remaining);
        }
        if (dT >= 0L) {
            this.repaint(dT, 0, 0, this.getWidth(), this.getHeight());
        }
        boolean needsMoreUpdates = (flgs & 0xA0) == 0;
        return needsMoreUpdates;
    }

    class Animation
    extends AnimationInstance {
        Animation(ImageObject imageObject) {
            super(imageObject);
        }

        protected boolean canAnimate() {
            return ImageSelectionButton.this.animate;
        }

        protected void animate(int xOffset, int yOffset, int width, int height) {
            ImageSelectionButton.this.repaint();
        }

        protected AnimationFrame getFrame() {
            return ImageSelectionButton.this.animationInstance.getAnimationFrame(ImageSelectionButton.this.imageObject);
        }
    }
}

