/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.tools.PaletteImage;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.image.ImageInfo;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import javax.swing.ImageIcon;

public class ImageData
implements PaletteImage,
Cloneable {
    private SoftReference<byte[]> imageBytesSoftRef = null;
    private byte[] imageBytes = null;
    private File imageBytesFile = null;
    private int imageByteCount = 0;
    private String pathname = "";
    private String suffixedFileName = "";
    private String name = "";
    private String sourceFile = "";
    private String url = "";
    private String mimeType = "";
    private ImageIcon imageIcon = null;
    private SoftReference<Image> imageSoftRef = null;
    private Image imageHardRef = null;
    private String toolTipString = null;
    private int width = 0;
    private int height = 0;
    private int animationIndex = 0;
    private long animationTime = 0L;
    private WBImage.PaletteType paletteType;

    public ImageData(byte[] imageData, String pathname, String sourceFile, String url, Image suppliedImage) {
        Image image;
        this.imageBytes = imageData;
        this.pathname = pathname;
        this.sourceFile = sourceFile;
        this.url = url;
        int startName = pathname.lastIndexOf(File.separatorChar);
        startName = startName < 0 ? 0 : ++startName;
        this.suffixedFileName = pathname.substring(startName);
        this.toolTipString = this.name = this.suffixedFileName.substring(0, this.suffixedFileName.lastIndexOf("."));
        this.mimeType = Platform.getMimeType((String)pathname);
        if (!ImageMimeUtilities.isValidImageMimeType((String)this.mimeType)) {
            if (this.mimeType != null && this.mimeType.endsWith(".properties")) {
                LogSupport.message((Object)this, (String)"<init>", (String)("Failed to load because file is not valid image MIME type: " + this.suffixedFileName));
            }
            Object image2 = null;
            this.imageBytes = null;
            this.imageSoftRef = new SoftReference<Object>(null);
            return;
        }
        this.imageIcon = null;
        if (suppliedImage == null) {
            image = this.makeImage(imageData);
        } else {
            image = suppliedImage;
            this.imageHardRef = suppliedImage;
            this.imageSoftRef = new SoftReference<Image>(image);
        }
        if (image == null) {
            this.imageBytes = null;
            return;
        }
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        try {
            this.imageBytesFile = File.createTempFile("Palette.", ".tmp");
            this.imageBytesFile.deleteOnExit();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.imageByteCount = 0;
            this.imageBytes = null;
            return;
        }
        try {
            FileOutputStream fostr = new FileOutputStream(this.imageBytesFile);
            fostr.write(this.imageBytes);
            fostr.close();
            this.imageByteCount = this.imageBytes.length;
            this.imageBytesSoftRef = new SoftReference<byte[]>(this.imageBytes);
        }
        catch (FileNotFoundException e) {
            this.imageBytesFile = null;
            e.printStackTrace();
        }
        catch (Exception e) {
            this.imageBytesFile = null;
            e.printStackTrace();
        }
        this.imageBytes = null;
    }

    protected void finalize() throws Throwable {
        this.flushImageData();
        super.finalize();
    }

    public void flushImageData() {
        Image image;
        if (this.imageSoftRef != null && (image = this.imageSoftRef.get()) != null) {
            image.flush();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getURL() {
        return this.url;
    }

    public String getPathname() {
        return this.pathname;
    }

    public String getSuffixedFileName() {
        return this.suffixedFileName;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getImageBytes() {
        byte[] imageBytes = this.imageBytesSoftRef.get();
        if (imageBytes == null) {
            try {
                imageBytes = new byte[this.imageByteCount];
                DataInputStream fistr = new DataInputStream(new FileInputStream(this.imageBytesFile));
                fistr.readFully(imageBytes);
                fistr.close();
                this.imageBytesSoftRef = new SoftReference<byte[]>(imageBytes);
                return imageBytes;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new byte[0];
        }
        return imageBytes;
    }

    public String getToolTipString() {
        return this.toolTipString;
    }

    public void setToolTipString(String toolTipString) {
        this.toolTipString = toolTipString;
    }

    public ImageIcon getImageIcon(int width, int height) {
        Image image = this.imageSoftRef.get();
        if (image == null && this.imageIcon == null && this.imageByteCount == 0) {
            return null;
        }
        if (this.imageIcon == null) {
            image = this.getImage();
            Image img = image.getScaledInstance(width, height, 16);
            BufferedImage icon = new BufferedImage(width, height, 2);
            Graphics2D g2 = icon.createGraphics();
            g2.drawImage(img, 0, 0, null);
            g2.dispose();
            this.imageIcon = new ImageIcon(icon);
        }
        return this.imageIcon;
    }

    public boolean isImageIconSet() {
        return this.imageIcon != null;
    }

    public Image getImage() {
        Image image = this.imageSoftRef.get();
        if (image == null) {
            image = this.makeImage(this.getImageBytes());
            this.imageBytes = null;
        }
        return image;
    }

    public boolean hasImage() {
        Image image = this.imageSoftRef.get();
        return image != null || this.imageIcon != null;
    }

    public WBImage.PaletteType getPaletteType() {
        return this.paletteType;
    }

    private Image makeImage(byte[] imageData) {
        Image image;
        try {
            if (this.mimeType.equals("image/gif")) {
                image = Toolkit.getDefaultToolkit().createImage(imageData);
            } else {
                ImageInfo imgInfo = ImageSupport.loadImage((String)this.mimeType, (byte[])imageData, (boolean)true);
                image = imgInfo.getImage();
                if (imgInfo.isScaled()) {
                    this.imageBytes = ImageSupport.encodeImage((Image)image, (String)this.mimeType, (int)90);
                }
            }
            if (!ImageSupport.waitForImage((Image)image)) {
                LogSupport.message((Object)this, (String)"<init>", (String)("image failed to load: " + this.suffixedFileName));
                image = null;
                return null;
            }
        }
        catch (Exception ex) {
            LogSupport.message((Object)this, (String)"<init>", (String)("Failed to load " + this.mimeType + " image data from " + this.suffixedFileName + ": " + Debug.getStackTrace((Throwable)ex)));
            image = null;
        }
        this.imageSoftRef = new SoftReference<Image>(image);
        return image;
    }

    public void setPaletteType(WBImage.PaletteType paletteType) {
        this.paletteType = paletteType;
    }

    public Object clone() throws CloneNotSupportedException {
        ImageData data = (ImageData)super.clone();
        data.animationIndex = 0;
        data.animationTime = 0L;
        return data;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ImageData: bytes: " + this.imageByteCount + ", size: " + this.width + "x" + this.height + ", path: " + this.pathname + ", name: " + this.name + ", source: " + this.sourceFile + ", mime: " + this.mimeType + ", toolTip: " + this.toolTipString);
        return buf.toString();
    }

    public String getImageName() {
        return this.getName();
    }

    public String getImageDescription() {
        return this.getToolTipString();
    }
}

