/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.classroom.client.messaging.ExtraInfo;
import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class WhiteboardPublisher {
    private final String UNIQUE_NAME = "WhiteboardPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String WHITEBOARD_SLIDE_TRANSITION = "whiteboard-slide-transition";
    public static final String WHITEBOARD_SLIDE_TEXT = "whiteboard-slide-text";
    public static final String WHITEBOARD_ENABLED = "whiteboard-enabled";
    public static final String WHITEBOARD_DISABLED = "whiteboard-disabled";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public WhiteboardPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendWhiteboardSlideTransitionMessage(String slideName, List<String> AdditionalInfo, boolean isMe) {
        String textMessage = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_SLIDE_TRANSITION_MESSAGE, new Object[]{slideName});
        ExtraInfo xtra = new ExtraInfo();
        xtra.setDetails(AdditionalInfo);
        this.publisher.sendMessageWithExtraInfo(textMessage, xtra, this.msgTypes.get(WHITEBOARD_SLIDE_TRANSITION), isMe);
    }

    public void sendWhiteboardSlideText(String slideName, String slideText, boolean isMe) {
        ExtraInfo xtra = new ExtraInfo();
        xtra.setHeader(this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_SLIDE_TEXT_HEADER, new Object[]{slideName}));
        this.publisher.sendMessageWithExtraInfo(slideText, xtra, this.msgTypes.get(WHITEBOARD_SLIDE_TEXT), isMe);
    }

    public void sendWhiteboardPrivilegeEnabledMessage() {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_ENABLED_MESSAGE);
        this.publisher.sendTextMessage(message, this.msgTypes.get(WHITEBOARD_ENABLED));
    }

    public void sendWhiteboardPrivilegeDisabledMessage() {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_DISABLED_MESSAGE);
        this.publisher.sendTextMessage(message, this.msgTypes.get(WHITEBOARD_DISABLED));
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("WhiteboardPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(WHITEBOARD_SLIDE_TRANSITION, new MessageType(WHITEBOARD_SLIDE_TRANSITION, this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_TYPE_SLIDE_TRANSITION), 5));
        this.msgTypes.put(WHITEBOARD_SLIDE_TEXT, new MessageType(WHITEBOARD_SLIDE_TEXT, this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_TYPE_SLIDE_TEXT), 5));
        this.msgTypes.put(WHITEBOARD_ENABLED, new MessageType(WHITEBOARD_ENABLED, this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_TYPE_ENABLED), 4));
        this.msgTypes.put(WHITEBOARD_DISABLED, new MessageType(WHITEBOARD_DISABLED, this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDPUBLISHER_TYPE_DISABLED), 4));
    }
}

