/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.util.I18n;
import com.elluminate.util.io.FileSysUtils;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class WBFileFilter
extends FileFilter {
    private String ext = "*";
    private String description = null;

    public WBFileFilter(String extension) {
        this.ext = extension;
        String className = this.getClass().getName();
        int lastPeriodIndex = className.lastIndexOf(".");
        I18n i18n = I18n.create((Object)this);
        String desc = className.substring(lastPeriodIndex + 1);
        this.description = i18n.getStringLegacy(desc + ".description");
    }

    public WBFileFilter(I18n i18n, String extension) {
        this.description = i18n.getStringLegacy(this.getClass().getName() + ".description");
        this.ext = extension;
    }

    public WBFileFilter(String description, String extension) {
        this.description = description;
        this.ext = extension;
    }

    @Override
    public boolean accept(File f) {
        return f == null ? false : FileSysUtils.isTraversableDirectory((File)f) || this.ext.equals("*") || this.ext.equalsIgnoreCase(FileSysUtils.getExtension((File)f));
    }

    public String getSuffix() {
        return this.ext;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

