/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.interfaces.WBClipboardInterface;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class WBClipboard
implements WBClipboardInterface,
ClipboardOwner {
    private Clipboard clipboard;
    private boolean textOnClipboard = false;
    private WhiteboardContext context;

    public WBClipboard(WhiteboardContext context) {
        this.context = context;
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public void pasteTextToClipboard(String text) {
        StringSelection contexts = new StringSelection(text);
        this.clipboard.setContents(contexts, this);
        this.textOnClipboard = true;
    }

    public String getTextFromClipboard() {
        Transferable contents = this.clipboard.getContents(this);
        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)contents.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public boolean clipboardHasText() {
        Transferable contents = this.clipboard.getContents(this);
        return contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public boolean clipboardHasMultiLineText() {
        Transferable contents = this.clipboard.getContents(this);
        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)contents.getTransferData(DataFlavor.stringFlavor);
                if (string.indexOf("\n") >= 0) {
                    return true;
                }
            }
            catch (IOException ex) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

