/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.util.image.ChainableImageFilter;
import com.elluminate.util.log.LogSupport;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class StatusImageFilter
extends ChainableImageFilter {
    Rectangle status;
    int tag;
    static ColorModel dftModel = ColorModel.getRGBdefault();

    public StatusImageFilter(int tagColor, int x, int y, int w, int h) {
        this.status = new Rectangle(x, y, w, h);
        this.tag = tagColor;
    }

    public void setColorModel(ColorModel cm) {
        this.consumer.setColorModel(dftModel);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        Rectangle rect = new Rectangle(x, y, w, h);
        if (!model.equals(dftModel)) {
            int lim = off + w * h;
            for (int i = off; i < lim; ++i) {
                try {
                    pixels[i] = model.getRGB(pixels[i]);
                    continue;
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)((Object)this), (String)"setPixels", (Throwable)t, (boolean)true, (String)("Error decoding pixel value " + pixels[i]));
                    pixels[i] = 0;
                }
            }
        }
        if (rect.intersects(this.status)) {
            Rectangle region = rect.intersection(this.status);
            int xlim = region.x + region.width;
            int ylim = region.y + region.height;
            for (int x1 = region.x; x1 < xlim; ++x1) {
                for (int y1 = region.y; y1 < ylim; ++y1) {
                    int loc = off + (y1 - y) * scansize + x1 - x;
                    if (loc < 0 || loc >= pixels.length) {
                        LogSupport.error((Object)((Object)this), (String)"setPixels", (String)("Index out of range: " + loc + " length=" + pixels.length));
                    }
                    pixels[loc] = this.tag;
                }
            }
        }
        this.consumer.setPixels(x, y, w, h, dftModel, pixels, off, scansize);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int[] rgb = new int[pixels.length];
        for (int i = off; i < rgb.length; ++i) {
            int pix = pixels[i] & 0xFF;
            try {
                rgb[i] = model.getRGB(pix);
                continue;
            }
            catch (Throwable t) {
                LogSupport.exception((Object)((Object)this), (String)"setPixels", (Throwable)t, (boolean)true, (String)("Error decoding pixel value " + pix));
                rgb[i] = 0;
            }
        }
        this.setPixels(x, y, w, h, dftModel, rgb, off, scansize);
    }
}

