/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class StarOfficeFilter
extends FileFilter {
    private static final I18n i18n = I18n.create((Object)new Object(){});
    private boolean macAppFilter = Platform.getOS() == 202;

    @Override
    public boolean accept(File file) {
        String fileName = file.getName().toLowerCase(Locale.ENGLISH);
        if (this.macAppFilter) {
            if (this.macAppFilter && fileName.endsWith(".app")) {
                File prog = new File(file, "Contents/MacOS/program/soffice");
                if (prog.isFile()) {
                    return true;
                }
                prog = new File(file, "Contents/MacOS/program/soffice.bin");
                if (prog.isFile()) {
                    return true;
                }
                prog = new File(file, "Contents/MacOS/soffice");
                if (prog.isFile()) {
                    return true;
                }
                prog = new File(file, "Contents/MacOS/soffice.bin");
                return prog.isFile();
            }
            return file.isDirectory();
        }
        return file.isDirectory() || file.exists() && fileName.startsWith("soffice") && !fileName.equalsIgnoreCase("soffice.ini");
    }

    @Override
    public String getDescription() {
        return i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEFILTER_DESCRIPTION);
    }
}

