/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.LoadWhiteboardCommand;
import com.elluminate.groupware.whiteboard.LoadRemoteMessageObject;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.module.AbstractWhiteboardCommand;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;

public class LoadWhiteboardCmd
extends AbstractWhiteboardCommand
implements LoadWhiteboardCommand {
    protected String screenKey = null;
    protected boolean rootSearch = false;
    protected boolean searchChildren = false;
    private String action = null;
    private String fileURL = null;
    private HashMap actionMap = new HashMap();
    @Inject
    private I18n i18n;

    public LoadWhiteboardCmd() {
        this.actionMap.put("before", new Integer(4));
        this.actionMap.put("after", new Integer(1));
        this.actionMap.put("replace", new Integer(16));
        this.actionMap.put("subtopic", new Integer(ActionUtilities.SUBTOPIC));
        this.actionMap.put("replaceall", null);
        this.actionMap.put("beginning", null);
        this.actionMap.put("end", null);
    }

    public void setFile(String fileURL) {
        this.fileURL = fileURL;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setScreen(String screenKey) {
        this.screenKey = screenKey;
    }

    public void setSearchFromScreenGroup(boolean rootSearch) {
        this.rootSearch = rootSearch;
    }

    public void setSearchSubTopics(boolean searchChildren) {
        this.searchChildren = searchChildren;
    }

    public String[] getAvailableActions() {
        return this.actionMap.keySet().toArray(new String[0]);
    }

    public void doexecute() throws CommandExecutionException {
        int act;
        WhiteboardBean bean = this.getWhiteboardBean();
        WhiteboardContext context = bean.getContext();
        ScreenModel currentScreen = context.getController().getScreen();
        this.validateIsChair();
        if (this.fileURL == null || this.fileURL.length() < 1) {
            throw new CommandParameterException("File parameter must be set", this.i18n.getString((PropertiesEnum)StringsProperties.LOADWHITEBOARDCMD_BADPARAMFILENOTSET));
        }
        URL url = null;
        try {
            URL u = new URL(this.fileURL);
            String proto = u.getProtocol().toLowerCase(Locale.ENGLISH);
            if (!(proto.equals("agenda") || proto.equals("http") || proto.equals("ftp") || proto.equals("https"))) {
                throw new CommandParameterException("Disallowed URL: " + this.fileURL, this.i18n.getString((PropertiesEnum)StringsProperties.LOADWHITEBOARDCMD_BADPARAMURLNOTSUPPORTED, new Object[]{this.fileURL}));
            }
            url = u;
        }
        catch (MalformedURLException ex) {
            throw new CommandParameterException("Invalid URL: " + this.fileURL, this.i18n.getString((PropertiesEnum)StringsProperties.LOADWHITEBOARDCMD_BADPARAMINVALIDURL, new Object[]{this.fileURL}));
        }
        String laction = this.action.toLowerCase(Locale.ENGLISH);
        if (!this.actionMap.containsKey(laction)) {
            throw new CommandParameterException("Invalid action parameter", this.i18n.getString((PropertiesEnum)StringsProperties.LOADWHITEBOARDCMD_BADPARAMINVALIDACTION, new Object[]{this.action}));
        }
        ScreenRoot scr = null;
        if (laction.equals("replaceall") || laction.equals("beginning") || laction.equals("end") || currentScreen.isPrivate() && context.getDataModel().getPublicScreens() == null) {
            ScreenRoot grp = null;
            if (!currentScreen.isPrivate()) {
                grp = currentScreen instanceof ScreenRoot ? (ScreenRoot)currentScreen : (ScreenRoot)currentScreen.getRoot();
            }
            if (laction.equals("replaceall")) {
                act = 16;
                scr = grp;
            } else if (laction.equals("beginning")) {
                act = 4;
                if (grp != null) {
                    scr = grp.getScreenDelegate();
                }
            } else {
                act = 2;
                scr = grp;
            }
        } else {
            act = (Integer)this.actionMap.get(laction);
            scr = currentScreen.isPrivate() ? this.findScreenInMainGroup(this.screenKey, this.rootSearch, this.searchChildren) : this.findScreenInCurrentGroup(this.screenKey, this.rootSearch, this.searchChildren);
            if (scr == null) {
                if (this.screenKey != null) {
                    throw new CommandParameterException("Unable to find the target screen", this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDCMD_BADRESULTSCREENNOTFOUND, new Object[]{this.screenKey}));
                }
                throw new CommandParameterException("Unable to find the current screen", this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDCMD_BADRESULTCURRENTSCREENNOTFOUND));
            }
        }
        int sequence = -1;
        short clientId = -1;
        if (scr != null) {
            Long oid = scr.getObjectID();
            sequence = ObjectUID.decodeSequence((Long)oid);
            clientId = ObjectUID.decodeClientId((Long)oid);
        }
        short conferenceClientId = context.getIDProcessor().localToConference(clientId);
        LoadRemoteMessageObject msg = new LoadRemoteMessageObject();
        msg.setFileURL(url);
        msg.setAction(act);
        msg.setSequenceNumber(sequence);
        msg.setClientId(conferenceClientId);
        try {
            ChannelDataEvent e = ChannelDataEvent.getInstance((Object)bean, (short)0, (byte)-95);
            ObjectOutputStream out = new ObjectOutputStream(e.write());
            out.writeObject(msg);
            out.close();
            bean.fireChannelData(e);
        }
        catch (IOException e) {
            throw new CommandExecutionException("Error while writing to ChannelDataEvent: " + e.toString(), this.i18n.getString((PropertiesEnum)StringsProperties.LOADWHITEBOARDCMD_BADRESULTERROROCCURRED, new Object[]{e.getMessage()}));
        }
    }
}

