/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.CopyWhiteboardsToMainRoomCommand;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.util.ArrayList;

public class CopyWhiteboardsToMainRoomCmd
extends AbstractCommand
implements CopyWhiteboardsToMainRoomCommand {
    private ArrayList breakoutRooms = new ArrayList();
    @Inject
    private I18n i18n;
    @Inject
    private WhiteboardModule whiteboardModule;

    protected WhiteboardBean getWhiteboardBean() {
        return this.whiteboardModule != null ? this.whiteboardModule.getWhiteboardBean() : null;
    }

    public String[] getAvailableBreakoutRooms() {
        WhiteboardBean bean = this.getWhiteboardBean();
        DataModel model = bean.getContext().getDataModel();
        ScreenGroups roots = (ScreenGroups)model.getRoot();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < roots.getChildCount(); ++i) {
            ScreenRoot root = (ScreenRoot)roots.getChildAt(i);
            if (root.getGroupID() == 0) continue;
            list.add(root.getDisplayName());
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public void addBreakoutRoom(String breakoutRoom) {
        this.breakoutRooms.add(breakoutRoom);
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        WhiteboardBean bean = this.getWhiteboardBean();
        DataModel model = bean.getContext().getDataModel();
        ScreenGroups roots = (ScreenGroups)model.getRoot();
        if (model.getPublicScreens() == null) {
            throw new CommandContextException("Room not found", this.i18n.getString((PropertiesEnum)StringsProperties.COPYWHITEBOARDCMD_BADCONTEXTNOMAINROOM));
        }
        for (int i = 0; i < this.breakoutRooms.size(); ++i) {
            String room = (String)this.breakoutRooms.get(i);
            if (this.breakoutRoomExists(room, roots)) continue;
            throw new CommandParameterException("Room not found", this.i18n.getString((PropertiesEnum)StringsProperties.COPYWHITEBOARDCMD_BADCONTEXTROOMNOTFOUND, new Object[]{room}));
        }
        bean.duplicateRoomsToMainRoom(this.breakoutRooms);
    }

    private boolean breakoutRoomExists(String roomName, ScreenGroups roots) {
        for (int i = 0; i < roots.getChildCount(); ++i) {
            ScreenRoot grp = (ScreenRoot)roots.getChildAt(i);
            if (grp.getGroupID() == 0 || !grp.getDisplayName().equals(roomName)) continue;
            return true;
        }
        return false;
    }
}

