/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.CopyWhiteboardToBreakoutRoomsCommand;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.GoToScreen;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.groupware.whiteboard.module.AbstractWhiteboardCommand;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.util.ArrayList;

public class CopyWhiteboardToBreakoutRoomsCmd
extends AbstractWhiteboardCommand
implements CopyWhiteboardToBreakoutRoomsCommand {
    private String screen;
    private boolean searchFromScreenGroup = false;
    private boolean searchSubTopics = false;
    private ArrayList breakoutRooms = new ArrayList();
    @Inject
    private I18n i18n = I18n.create((Object)((Object)this));

    public void setScreen(String screen) {
        this.screen = screen;
    }

    public void setSearchFromScreenGroup(boolean searchFromScreenGroup) {
        this.searchFromScreenGroup = searchFromScreenGroup;
    }

    public void setSearchSubTopics(boolean searchSubTopics) {
        this.searchSubTopics = searchSubTopics;
    }

    public String[] getAvailableBreakoutRooms() {
        WhiteboardBean bean = this.getWhiteboardBean();
        DataModel model = bean.getContext().getDataModel();
        ScreenGroups roots = (ScreenGroups)model.getRoot();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < roots.getChildCount(); ++i) {
            ScreenRoot root = (ScreenRoot)roots.getChildAt(i);
            if (root.getGroupID() == 0) continue;
            list.add(root.getDisplayName());
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public void addBreakoutRoom(String breakoutRoom) {
        this.breakoutRooms.add(breakoutRoom);
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        WhiteboardBean bean = this.getWhiteboardBean();
        DataModel model = bean.getContext().getDataModel();
        ScreenGroups roots = (ScreenGroups)model.getRoot();
        ScreenModel scr = this.findScreenInMainGroup(this.screen, this.searchFromScreenGroup, this.searchSubTopics);
        if (scr == null) {
            throw new CommandParameterException("Screen not found", this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDCMD_BADRESULTSCREENNOTFOUND, new Object[]{this.screen}));
        }
        ArrayList<ScreenRoot> groups = new ArrayList<ScreenRoot>();
        if (this.breakoutRooms.size() != 0) {
            for (String room : this.breakoutRooms) {
                ScreenRoot grp = this.getBreakoutRoom(room, roots);
                if (grp == null) {
                    throw new CommandParameterException("Room not found", this.i18n.getString((PropertiesEnum)StringsProperties.COPYWHITEBOARDCMD_BADCONTEXTROOMNOTFOUND, new Object[]{room}));
                }
                groups.add(grp);
            }
        } else {
            for (int i = 0; i < roots.getChildCount(); ++i) {
                ScreenRoot grp = (ScreenRoot)roots.getChildAt(i);
                if (grp.getGroupID() == 0) continue;
                groups.add(grp);
            }
        }
        if (groups.size() == 0) {
            throw new CommandContextException("No breakout rooms", this.i18n.getString((PropertiesEnum)StringsProperties.COPYWHITEBOARDCMD_BADCONTEXTNOBREAKOUTROOMS));
        }
        ScreenRoot[] grps = groups.toArray(new ScreenRoot[0]);
        WhiteboardContext context = bean.getContext();
        ActionUtilities.duplicateScreensToGroups((WhiteboardContext)context, (ScreenModel[])new ScreenModel[]{scr}, (ScreenRoot[])grps);
        for (int i = 0; i < grps.length; ++i) {
            ScreenRoot grp = grps[i];
            scr = (ScreenModel)grp.getScreenAt(0);
            GoToScreen gotoScreen = new GoToScreen(context, scr.getObjectID(), Short.valueOf(grp.getGroupID()));
            context.getDataProcessor().sendDirective((byte)5, (StreamableObject)gotoScreen);
        }
    }

    private ScreenRoot getBreakoutRoom(String roomName, ScreenGroups roots) {
        for (int i = 0; i < roots.getChildCount(); ++i) {
            ScreenRoot grp = (ScreenRoot)roots.getChildAt(i);
            if (grp.getGroupID() == 0 || !grp.getDisplayName().equals(roomName)) continue;
            return grp;
        }
        return null;
    }
}

