/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.StringsProperties;
import com.elluminate.groupware.calculator.Term;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.text.ParseException;
import java.util.LinkedList;

class FunctionContext {
    private I18n i18n = I18n.create((Object)this);
    private LinkedList operators = new LinkedList();
    private LinkedList operands = new LinkedList();

    FunctionContext() {
    }

    public Term getTree() throws ParseException {
        this.collapse(-1);
        if (!this.operators.isEmpty()) {
            throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_MISSINGOPERATOR), 0);
        }
        if (this.operands.size() == 0) {
            throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_NULLEXPRESSION), 0);
        }
        if (this.operands.size() > 1) {
            throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_OPERATORMISSING), 0);
        }
        return (Term)this.operands.getLast();
    }

    public void pushOperand(Term term) {
        this.operands.addLast(term);
    }

    public void pushOperator(Term term) throws ParseException {
        if (!this.operators.isEmpty() && term.getPrecedence() <= this.getTopPrecedence()) {
            this.collapse(term.getPrecedence());
        }
        this.operators.addLast(term);
    }

    private void collapse(int precedence) throws ParseException {
        while (!this.operators.isEmpty() && this.getTopPrecedence() >= precedence) {
            Term op = (Term)this.operators.removeLast();
            int nArgs = op.getOperandCount();
            if (this.operands.size() < nArgs) {
                throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_NOTENOUGHARGS), 0);
            }
            for (int i = 0; i < nArgs; ++i) {
                op.setOperand((Term)this.operands.removeLast());
            }
            this.operands.addLast(op);
        }
    }

    private int getTopPrecedence() throws ParseException {
        if (this.operators.isEmpty()) {
            return -1;
        }
        return ((Term)this.operators.getLast()).getPrecedence();
    }
}

